/// <reference types="react" />
export interface DualListSelectorListWrapperProps extends React.HTMLProps<HTMLDivElement> {
    /** Additional classes applied to the dual list selector. */
    className?: string;
    /** Anything that can be rendered inside of the list. */
    children?: React.ReactNode;
    /** ID of the dual list selector list. */
    id?: string;
    /** Accessibly label for the list. */
    'aria-labelledby': string;
    /** @hide forwarded ref */
    innerRef?: React.RefObject<HTMLDivElement | null>;
    /** @hide Options to list in the pane. */
    options?: React.ReactNode[];
    /** @hide Options currently selected in the pane. */
    selectedOptions?: string[] | number[];
    /** @hide Function to determine if an option should be displayed depending on a custom filter value. */
    displayOption?: (option: React.ReactNode) => boolean;
    /** Flag indicating whether the component is disabled. */
    isDisabled?: boolean;
}
export declare const DualListSelectorListWrapperBase: React.FunctionComponent<DualListSelectorListWrapperProps>;
export declare const DualListSelectorListWrapper: import("react").ForwardRefExoticComponent<Omit<DualListSelectorListWrapperProps, "ref"> & import("react").RefAttributes<HTMLDivElement>>;
//# sourceMappingURL=DualListSelectorListWrapper.d.ts.map