/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public abstract class PatternMatchUtils {
    public static boolean simpleMatch(@Nullable String pattern, @Nullable String str) {
        return PatternMatchUtils.simpleMatch(pattern, str, false);
    }

    public static boolean simpleMatchIgnoreCase(@Nullable String pattern, @Nullable String str) {
        return PatternMatchUtils.simpleMatch(pattern, str, true);
    }

    private static boolean simpleMatch(@Nullable String pattern, @Nullable String str, boolean ignoreCase) {
        if (pattern == null || str == null) {
            return false;
        }
        int firstIndex = pattern.indexOf(42);
        if (firstIndex == -1) {
            return ignoreCase ? pattern.equalsIgnoreCase(str) : pattern.equals(str);
        }
        if (firstIndex == 0) {
            if (pattern.length() == 1) {
                return true;
            }
            int nextIndex = pattern.indexOf(42, 1);
            if (nextIndex == -1) {
                String part = pattern.substring(1);
                return ignoreCase ? StringUtils.endsWithIgnoreCase(str, part) : str.endsWith(part);
            }
            String part = pattern.substring(1, nextIndex);
            if (part.isEmpty()) {
                return PatternMatchUtils.simpleMatch(pattern.substring(nextIndex), str, ignoreCase);
            }
            int partIndex = PatternMatchUtils.indexOf(str, part, 0, ignoreCase);
            while (partIndex != -1) {
                if (PatternMatchUtils.simpleMatch(pattern.substring(nextIndex), str.substring(partIndex + part.length()), ignoreCase)) {
                    return true;
                }
                partIndex = PatternMatchUtils.indexOf(str, part, partIndex + 1, ignoreCase);
            }
            return false;
        }
        return str.length() >= firstIndex && PatternMatchUtils.checkStartsWith(pattern, str, firstIndex, ignoreCase) && PatternMatchUtils.simpleMatch(pattern.substring(firstIndex), str.substring(firstIndex), ignoreCase);
    }

    private static boolean checkStartsWith(String pattern, String str, int index, boolean ignoreCase) {
        String part = str.substring(0, index);
        return ignoreCase ? StringUtils.startsWithIgnoreCase(pattern, part) : pattern.startsWith(part);
    }

    private static int indexOf(String str, String otherStr, int startIndex, boolean ignoreCase) {
        if (!ignoreCase) {
            return str.indexOf(otherStr, startIndex);
        }
        for (int i2 = startIndex; i2 <= str.length() - otherStr.length(); ++i2) {
            if (!str.regionMatches(true, i2, otherStr, 0, otherStr.length())) continue;
            return i2;
        }
        return -1;
    }

    public static boolean simpleMatch(@Nullable String[] patterns, @Nullable String str) {
        if (patterns != null) {
            for (String pattern : patterns) {
                if (!PatternMatchUtils.simpleMatch(pattern, str)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean simpleMatchIgnoreCase(@Nullable String[] patterns, @Nullable String str) {
        if (patterns != null) {
            for (String pattern : patterns) {
                if (!PatternMatchUtils.simpleMatch(pattern, str, true)) continue;
                return true;
            }
        }
        return false;
    }
}

