/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.axiom.core.CoreNode;
import org.apache.axiom.core.NodeFactory;
import org.apache.axiom.core.NodeFactoryException;
import org.apache.axiom.core.util.EdgeRelation;
import org.apache.axiom.core.util.TopologicalSort;

public abstract class NodeFactoryImpl
implements NodeFactory {
    private final Map<Class<?>, Constructor<?>> constructorMap;

    public NodeFactoryImpl(ClassLoader cl, String ... packages) {
        List<Class<?>> implementations = new ArrayList();
        String[] stringArray = packages;
        int n = packages.length;
        int n2 = 0;
        while (n2 < n) {
            block16: {
                String pkg = stringArray[n2];
                try {
                    BufferedReader in = new BufferedReader(new InputStreamReader(cl.getResourceAsStream(String.valueOf(pkg.replace('.', '/')) + "/nodetypes.index"), "UTF-8"));
                    block10: while (true) {
                        String line;
                        while ((line = in.readLine()) != null) {
                            if (line.startsWith("#")) continue;
                            String string = String.valueOf(pkg) + "." + line;
                            try {
                                implementations.add(cl.loadClass(string));
                                continue block10;
                            }
                            catch (ClassNotFoundException ex) {
                                throw new NodeFactoryException("Failed to load class " + string, ex);
                            }
                        }
                        break block16;
                        {
                            continue block10;
                            break;
                        }
                        break;
                    }
                    finally {
                        in.close();
                    }
                }
                catch (IOException ex) {
                    throw new NodeFactoryException("Failed to load node type index for package " + pkg, ex);
                }
            }
            ++n2;
        }
        implementations = TopologicalSort.sort(implementations, new EdgeRelation<Class<?>>(){

            @Override
            public boolean isEdge(Class<?> from, Class<?> to) {
                return to.isAssignableFrom(from);
            }
        });
        HashMap<Class, Class> interfaceToImplementationMap = new HashMap<Class, Class>();
        HashMap implementationToConstructorMap = new HashMap();
        HashSet<Class> ambiguousInterfaces = new HashSet<Class>();
        for (Class clazz : implementations) {
            HashSet interfaces = new HashSet();
            NodeFactoryImpl.collectInterfaces(clazz, interfaces);
            for (Class clazz2 : interfaces) {
                if (ambiguousInterfaces.contains(clazz2)) continue;
                Class clazz3 = (Class)interfaceToImplementationMap.get(clazz2);
                if (clazz3 == null || clazz.isAssignableFrom(clazz3)) {
                    interfaceToImplementationMap.put(clazz2, clazz);
                    continue;
                }
                if (clazz3.isAssignableFrom(clazz)) continue;
                interfaceToImplementationMap.remove(clazz2);
                ambiguousInterfaces.add(clazz2);
            }
            try {
                implementationToConstructorMap.put(clazz, clazz.getConstructor(new Class[0]));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new NodeFactoryException("Failed to get constructor for " + clazz.getName(), noSuchMethodException);
            }
        }
        this.constructorMap = new HashMap();
        for (Map.Entry entry : interfaceToImplementationMap.entrySet()) {
            this.constructorMap.put((Class)entry.getKey(), (Constructor)implementationToConstructorMap.get(entry.getValue()));
        }
        this.constructorMap.putAll(implementationToConstructorMap);
    }

    private static void collectInterfaces(Class<?> clazz, Set<Class<?>> interfaces) {
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> iface = classArray[n2];
            if (interfaces.add(iface)) {
                NodeFactoryImpl.collectInterfaces(iface, interfaces);
            }
            ++n2;
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null) {
            NodeFactoryImpl.collectInterfaces(superclass, interfaces);
        }
    }

    @Override
    public final <T extends CoreNode> T createNode(Class<T> type) {
        Constructor<?> constructor = this.constructorMap.get(type);
        if (constructor == null) {
            throw new NodeFactoryException("Unknown node type " + type.getName());
        }
        try {
            return (T)((CoreNode)type.cast(constructor.newInstance(new Object[0])));
        }
        catch (InvocationTargetException ex) {
            throw new NodeFactoryException("Caught exception thrown by constructor", ex.getCause());
        }
        catch (InstantiationException ex) {
            throw new NodeFactoryException("Failed to invoke constructor", ex);
        }
        catch (IllegalAccessException ex) {
            throw new NodeFactoryException("Failed to invoke constructor", ex);
        }
    }
}

