/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.description.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Definition;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.MethodRetriever;
import org.apache.axis2.jaxws.description.ServiceDescriptionWSDL;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;
import org.apache.axis2.jaxws.description.builder.MethodDescriptionComposite;
import org.apache.axis2.jaxws.description.impl.DescriptionUtils;
import org.apache.axis2.jaxws.description.impl.EndpointInterfaceDescriptionImpl;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PostRI216MethodRetrieverImpl
extends MethodRetriever {
    private static final Log log = LogFactory.getLog(PostRI216MethodRetrieverImpl.class);
    private EndpointInterfaceDescriptionImpl eid = null;
    private DescriptionBuilderComposite dbc = null;

    public PostRI216MethodRetrieverImpl(DescriptionBuilderComposite dbc, EndpointInterfaceDescriptionImpl eid) {
        this.dbc = dbc;
        this.eid = eid;
    }

    @Override
    public Iterator<MethodDescriptionComposite> retrieveMethods() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"retrieveMethods: Enter");
        }
        ArrayList<MethodDescriptionComposite> retrieveList = new ArrayList();
        if (this.dbc.isInterface()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removing overridden methods for interface: " + this.dbc.getClassName() + " with super interface: " + this.dbc.getSuperClassName()));
            }
            retrieveList = this.retrieveSEIMethodsChain(this.dbc, this.eid);
            retrieveList = this.removeOverriddenMethods(retrieveList, this.dbc, this.eid);
        } else {
            retrieveList = this.retrieveImplicitSEIMethods(this.dbc);
            DescriptionBuilderComposite tempDBC = this.dbc;
            while (!DescriptionUtils.isEmpty(tempDBC.getSuperClassName()) && !DescriptionUtils.javifyClassName(tempDBC.getSuperClassName()).equals("java.lang.Object")) {
                DescriptionBuilderComposite superDBC = this.eid.getEndpointDescriptionImpl().getServiceDescriptionImpl().getDBCMap().get(tempDBC.getSuperClassName());
                if (log.isTraceEnabled()) {
                    log.trace((Object)("superclass name for this DBC is:" + tempDBC.getSuperClassName()));
                }
                if (superDBC == null) {
                    throw ExceptionFactory.makeWebServiceException(Messages.getMessage("seiNotFoundErr"));
                }
                retrieveList.addAll(this.retrieveImplicitSEIMethods(superDBC));
                tempDBC = superDBC;
            }
            retrieveList = this.removeOverriddenMethods(retrieveList, this.dbc, this.eid);
            boolean isWebmethodDefined = DescriptionUtils.isWebmethodDefined(this.dbc);
            for (MethodDescriptionComposite mdc : retrieveList) {
                Definition wsdlDef = ((ServiceDescriptionWSDL)((Object)this.eid.getEndpointDescription().getServiceDescription())).getWSDLDefinition();
                if (this.getLegacyWebMethod() != null || wsdlDef != null || !isWebmethodDefined || mdc.getWebMethodAnnot() != null || this.isConstructor(mdc)) continue;
                log.warn((Object)Messages.getMessage("MethodRetrieverWarning1", mdc.getMethodName()));
            }
        }
        return retrieveList.iterator();
    }

    private ArrayList<MethodDescriptionComposite> retrieveImplicitSEIMethods(DescriptionBuilderComposite dbc) {
        ArrayList<MethodDescriptionComposite> retrieveList = new ArrayList<MethodDescriptionComposite>();
        Iterator<MethodDescriptionComposite> iter = null;
        List<MethodDescriptionComposite> mdcList = dbc.getMethodDescriptionsList();
        if (mdcList != null) {
            iter = dbc.getMethodDescriptionsList().iterator();
            boolean isWebmethodDefined = DescriptionUtils.isWebmethodDefined(dbc);
            while (iter.hasNext()) {
                boolean isWebservice;
                MethodDescriptionComposite mdc = iter.next();
                boolean bl = isWebservice = !DescriptionUtils.isExcludeTrue(mdc) && !mdc.isStatic() && !mdc.isFinal();
                if (!isWebservice && log.isDebugEnabled()) {
                    log.debug((Object)(mdc.getMethodName() + " has static or final modifiers in method signature or has @Webmethod(exclude=true) set"));
                    log.debug((Object)(mdc.getMethodName() + " cannot be exposed as a webservice"));
                }
                if (!isWebservice) continue;
                mdc.setDeclaringClass(dbc.getClassName());
                retrieveList.add(mdc);
            }
        }
        return retrieveList;
    }

    private boolean isConstructor(MethodDescriptionComposite mdc) {
        return mdc.getMethodName().equals("<init>");
    }
}

