/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.core.stream.serializer.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.axiom.core.stream.serializer.writer.Latin1XmlWriter;
import org.apache.axiom.core.stream.serializer.writer.OutputStreamXmlWriter;
import org.apache.axiom.core.stream.serializer.writer.UTF8XmlWriter;
import org.apache.axiom.core.stream.serializer.writer.UnmappableCharacterHandler;
import org.apache.axiom.util.base64.AbstractBase64EncodingOutputStream;

public abstract class XmlWriter {
    public static XmlWriter create(OutputStream out, String encoding) {
        Charset charset = Charset.forName(encoding);
        String name = charset.name();
        if (name.equals("UTF-8")) {
            return new UTF8XmlWriter(out);
        }
        if (name.equals("US-ASCII")) {
            return new Latin1XmlWriter(out, 127);
        }
        if (name.equals("ISO-8859-1")) {
            return new Latin1XmlWriter(out, 255);
        }
        return new OutputStreamXmlWriter(out, charset);
    }

    public abstract void setUnmappableCharacterHandler(UnmappableCharacterHandler var1) throws IOException;

    public abstract void write(char var1) throws IOException;

    public abstract void write(String var1) throws IOException;

    public abstract void write(char[] var1, int var2, int var3) throws IOException;

    public abstract AbstractBase64EncodingOutputStream getBase64EncodingOutputStream();

    public abstract void flushBuffer() throws IOException;

    public final void writeCharacterReference(int codePoint) throws IOException {
        this.write("&#x");
        int digits = Math.max((32 - Integer.numberOfLeadingZeros(codePoint) + 3) / 4, 1);
        for (int i = digits - 1; i >= 0; --i) {
            int digit;
            this.write((char)(digit + ((digit = codePoint >> 4 * i & 0xF) < 10 ? 48 : 87)));
        }
        this.write(';');
    }
}

