/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationstatus.traits;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Objects;
import java.util.Optional;
import org.apache.camel.v1.integrationstatus.traits.SecurityContext;
import org.apache.camel.v1.integrationstatus.traits.securitycontext.Configuration;
import org.apache.camel.v1.integrationstatus.traits.securitycontext.ConfigurationBuilder;
import org.apache.camel.v1.integrationstatus.traits.securitycontext.ConfigurationFluent;

public class SecurityContextFluent<A extends SecurityContextFluent<A>>
extends BaseFluent<A> {
    private ConfigurationBuilder configuration;
    private Boolean enabled;
    private Boolean runAsNonRoot;
    private Long runAsUser;
    private SecurityContext.SeccompProfileType seccompProfileType;

    public SecurityContextFluent() {
    }

    public SecurityContextFluent(SecurityContext instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(SecurityContext instance) {
        SecurityContext securityContext = instance = instance != null ? instance : new SecurityContext();
        if (instance != null) {
            this.withConfiguration(instance.getConfiguration());
            this.withEnabled(instance.getEnabled());
            this.withRunAsNonRoot(instance.getRunAsNonRoot());
            this.withRunAsUser(instance.getRunAsUser());
            this.withSeccompProfileType(instance.getSeccompProfileType());
        }
    }

    public Configuration buildConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    public A withConfiguration(Configuration configuration) {
        this._visitables.remove((Object)"configuration");
        if (configuration != null) {
            this.configuration = new ConfigurationBuilder(configuration);
            this._visitables.get((Object)"configuration").add(this.configuration);
        } else {
            this.configuration = null;
            this._visitables.get((Object)"configuration").remove((Object)this.configuration);
        }
        return (A)((Object)this);
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNested(null);
    }

    public ConfigurationNested<A> withNewConfigurationLike(Configuration item) {
        return new ConfigurationNested(item);
    }

    public ConfigurationNested<A> editConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(null));
    }

    public ConfigurationNested<A> editOrNewConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(new ConfigurationBuilder().build()));
    }

    public ConfigurationNested<A> editOrNewConfigurationLike(Configuration item) {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(item));
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public Boolean getRunAsNonRoot() {
        return this.runAsNonRoot;
    }

    public A withRunAsNonRoot(Boolean runAsNonRoot) {
        this.runAsNonRoot = runAsNonRoot;
        return (A)((Object)this);
    }

    public boolean hasRunAsNonRoot() {
        return this.runAsNonRoot != null;
    }

    public Long getRunAsUser() {
        return this.runAsUser;
    }

    public A withRunAsUser(Long runAsUser) {
        this.runAsUser = runAsUser;
        return (A)((Object)this);
    }

    public boolean hasRunAsUser() {
        return this.runAsUser != null;
    }

    public SecurityContext.SeccompProfileType getSeccompProfileType() {
        return this.seccompProfileType;
    }

    public A withSeccompProfileType(SecurityContext.SeccompProfileType seccompProfileType) {
        this.seccompProfileType = seccompProfileType;
        return (A)((Object)this);
    }

    public boolean hasSeccompProfileType() {
        return this.seccompProfileType != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SecurityContextFluent that = (SecurityContextFluent)((Object)o);
        if (!Objects.equals((Object)this.configuration, (Object)that.configuration)) {
            return false;
        }
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        if (!Objects.equals(this.runAsNonRoot, that.runAsNonRoot)) {
            return false;
        }
        if (!Objects.equals(this.runAsUser, that.runAsUser)) {
            return false;
        }
        return Objects.equals((Object)this.seccompProfileType, (Object)that.seccompProfileType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.configuration, this.enabled, this.runAsNonRoot, this.runAsUser, this.seccompProfileType, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configuration != null) {
            sb.append("configuration:");
            sb.append(this.configuration + ",");
        }
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.runAsNonRoot != null) {
            sb.append("runAsNonRoot:");
            sb.append(this.runAsNonRoot + ",");
        }
        if (this.runAsUser != null) {
            sb.append("runAsUser:");
            sb.append(this.runAsUser + ",");
        }
        if (this.seccompProfileType != null) {
            sb.append("seccompProfileType:");
            sb.append((Object)this.seccompProfileType);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }

    public A withRunAsNonRoot() {
        return this.withRunAsNonRoot(true);
    }

    public class ConfigurationNested<N>
    extends ConfigurationFluent<ConfigurationNested<N>>
    implements Nested<N> {
        ConfigurationBuilder builder;

        ConfigurationNested(Configuration item) {
            this.builder = new ConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)SecurityContextFluent.this.withConfiguration(this.builder.build());
        }

        public N endConfiguration() {
            return this.and();
        }
    }
}

