/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.flush;

import java.util.Collections;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.ObjectDiff;
import org.apache.cayenne.access.flush.ArcValuesCreationHandler;
import org.apache.cayenne.access.flush.DbRowOpFactory;
import org.apache.cayenne.access.flush.OptimisticLockQualifierBuilder;
import org.apache.cayenne.access.flush.ValuesCreationHandler;
import org.apache.cayenne.access.flush.operation.DbRowOpType;
import org.apache.cayenne.access.flush.operation.DbRowOpVisitor;
import org.apache.cayenne.access.flush.operation.DeleteDbRowOp;
import org.apache.cayenne.access.flush.operation.InsertDbRowOp;
import org.apache.cayenne.access.flush.operation.UpdateDbRowOp;
import org.apache.cayenne.graph.GraphChangeHandler;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;

class RootRowOpProcessor
implements DbRowOpVisitor<Void> {
    private final DbRowOpFactory dbRowOpFactory;
    private final GraphChangeHandler insertHandler;
    private final GraphChangeHandler updateHandler;
    private final GraphChangeHandler deleteHandler;
    private ObjectDiff diff;

    RootRowOpProcessor(DbRowOpFactory dbRowOpFactory) {
        this.dbRowOpFactory = dbRowOpFactory;
        this.insertHandler = new ValuesCreationHandler(dbRowOpFactory, DbRowOpType.INSERT);
        this.updateHandler = new ValuesCreationHandler(dbRowOpFactory, DbRowOpType.UPDATE);
        this.deleteHandler = new ArcValuesCreationHandler(dbRowOpFactory, DbRowOpType.DELETE);
    }

    void setDiff(ObjectDiff diff) {
        this.diff = diff;
    }

    @Override
    public Void visitInsert(InsertDbRowOp dbRow) {
        this.diff.apply(this.insertHandler);
        return null;
    }

    @Override
    public Void visitUpdate(UpdateDbRowOp dbRow) {
        this.diff.apply(this.updateHandler);
        if (this.dbRowOpFactory.getDescriptor().getEntity().getDeclaredLockType() == 1) {
            this.dbRowOpFactory.getDescriptor().visitAllProperties(new OptimisticLockQualifierBuilder(dbRow, this.diff));
        }
        return null;
    }

    @Override
    public Void visitDelete(DeleteDbRowOp dbRow) {
        ObjEntity entity = this.dbRowOpFactory.getDescriptor().getEntity();
        if (entity.isReadOnly()) {
            throw new CayenneRuntimeException("Attempt to modify object(s) mapped to a read-only entity: '%s'. Can't commit changes.", entity.getName());
        }
        this.diff.apply(this.deleteHandler);
        DbEntity dbSource = entity.getDbEntity();
        Map<String, ObjectId> flattenedPathIdMap = this.dbRowOpFactory.getStore().getFlattenedPathIdMap(dbRow.getChangeId());
        flattenedPathIdMap.forEach((path, value) -> {
            int deleteRule;
            int indexOfDot = path.indexOf(46);
            String relName = indexOfDot == -1 ? path : path.substring(0, path.indexOf(46));
            DbRelationship dbRel = dbSource.getRelationship(relName);
            if (!dbRel.getReverseRelationship().isToMany() && (deleteRule = entity.getRelationships().stream().filter(r -> r.getDbRelationships().equals(Collections.singletonList(dbRel))).map(ObjRelationship::getDeleteRule).findFirst().orElse(2).intValue()) == 2) {
                this.dbRowOpFactory.getOrCreate(this.dbRowOpFactory.getDbEntity((ObjectId)value), (ObjectId)value, DbRowOpType.DELETE);
            }
        });
        if (entity.getDeclaredLockType() == 1) {
            this.dbRowOpFactory.getDescriptor().visitAllProperties(new OptimisticLockQualifierBuilder(dbRow, this.diff));
        }
        return null;
    }
}

