/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.util.IDUtil;

public class ByteType
implements ExtendedType<Byte> {
    protected boolean widenBytes;

    public ByteType(boolean widenBytes) {
        this.widenBytes = widenBytes;
    }

    @Override
    public String getClassName() {
        return Byte.class.getName();
    }

    @Override
    public Byte materializeObject(ResultSet rs, int index, int type) throws Exception {
        byte b = rs.getByte(index);
        return rs.wasNull() ? null : Byte.valueOf(b);
    }

    @Override
    public Byte materializeObject(CallableStatement st, int index, int type) throws Exception {
        byte b = st.getByte(index);
        return st.wasNull() ? null : Byte.valueOf(b);
    }

    @Override
    public void setJdbcObject(PreparedStatement statement, Byte value, int pos, int type, int precision) throws Exception {
        if (value == null) {
            statement.setNull(pos, type);
        } else if (this.widenBytes) {
            statement.setInt(pos, value.intValue());
        } else {
            statement.setByte(pos, value);
        }
    }

    @Override
    public String toString(Byte value) {
        if (value == null) {
            return "NULL";
        }
        StringBuilder buffer = new StringBuilder();
        IDUtil.appendFormattedByte(buffer, value);
        return buffer.toString();
    }
}

