/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.xml;

import java.util.Objects;
import org.apache.cayenne.configuration.xml.LoaderContext;
import org.apache.cayenne.configuration.xml.SAXNestedTagHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class NamespaceAwareNestedTagHandler
extends SAXNestedTagHandler {
    protected String targetNamespace;
    protected boolean allowAllNamespaces;
    private StringBuilder charactersBuffer = new StringBuilder();

    public NamespaceAwareNestedTagHandler(LoaderContext loaderContext) {
        super(loaderContext);
    }

    public NamespaceAwareNestedTagHandler(SAXNestedTagHandler parentHandler, String targetNamespace) {
        super(parentHandler);
        this.targetNamespace = Objects.requireNonNull(targetNamespace);
    }

    public NamespaceAwareNestedTagHandler(NamespaceAwareNestedTagHandler parentHandler) {
        this(parentHandler, parentHandler.targetNamespace);
    }

    @Override
    protected abstract boolean processElement(String var1, String var2, Attributes var3) throws SAXException;

    protected void processCharData(String localName, String data) {
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.charactersBuffer.append(ch, start, length);
    }

    @Override
    public final void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
        boolean validNamespace;
        ContentHandler childHandler = this.createChildTagHandler(namespaceURI, localName, qName, attributes);
        boolean bl = validNamespace = this.allowAllNamespaces || namespaceURI.equals(this.targetNamespace);
        if (!validNamespace || !this.processElement(namespaceURI, localName, attributes)) {
            childHandler.startElement(namespaceURI, localName, qName, attributes);
        }
        this.loaderContext.getXmlReader().setContentHandler(childHandler);
        this.charactersBuffer.delete(0, this.charactersBuffer.length());
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        super.endElement(namespaceURI, localName, qName);
        if (namespaceURI.equals(this.targetNamespace) && this.parentHandler instanceof NamespaceAwareNestedTagHandler) {
            ((NamespaceAwareNestedTagHandler)this.parentHandler).processCharData(localName, this.charactersBuffer.toString());
        }
    }

    @Override
    protected ContentHandler createChildTagHandler(String namespaceURI, String localName, String qName, Attributes attributes) {
        return this.loaderContext.getFactory().createHandler(namespaceURI, localName, this);
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public void setAllowAllNamespaces(boolean allowAllNamespaces) {
        this.allowAllNamespaces = allowAllNamespaces;
    }
}

