/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.gen;

import java.util.Collection;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.gen.ArtifactsGenerationMode;
import org.apache.cayenne.gen.CgenConfiguration;
import org.apache.cayenne.gen.ClassGenerationAction;
import org.apache.cayenne.gen.ClientDataMapArtifact;
import org.apache.cayenne.gen.ClientEntityArtifact;
import org.apache.cayenne.gen.TemplateType;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.QueryDescriptor;

public class ClientClassGenerationAction
extends ClassGenerationAction {
    private static final String TEMPLATES_DIR_NAME = "templates/v4_1/";
    public static final String SUBCLASS_TEMPLATE = "templates/v4_1/client-subclass.vm";
    public static final String SUPERCLASS_TEMPLATE = "templates/v4_1/client-superclass.vm";
    public static final String SINGLE_CLASS_TEMPLATE = "templates/v4_1/client-singleclass.vm";
    public static final String DMAP_SUBCLASS_TEMPLATE = "templates/v4_1/client-datamap-subclass.vm";
    public static final String DMAP_SUPERCLASS_TEMPLATE = "templates/v4_1/client-datamap-superclass.vm";
    public static final String DATAMAP_SINGLE_CLASS_TEMPLATE = "templates/v4_1/client-datamap-singleclass.vm";
    public static final String CLIENT_SUPERCLASS_PREFIX = "_Client";

    public ClientClassGenerationAction(CgenConfiguration config) {
        super(config);
    }

    @Override
    public String defaultTemplateName(TemplateType type) {
        switch (type) {
            case ENTITY_SUBCLASS: {
                return SUBCLASS_TEMPLATE;
            }
            case ENTITY_SUPERCLASS: {
                return SUPERCLASS_TEMPLATE;
            }
            case ENTITY_SINGLE_CLASS: {
                return SINGLE_CLASS_TEMPLATE;
            }
            case EMBEDDABLE_SUBCLASS: {
                return "templates/v4_1/embeddable-subclass.vm";
            }
            case EMBEDDABLE_SUPERCLASS: {
                return "templates/v4_1/embeddable-superclass.vm";
            }
            case EMBEDDABLE_SINGLE_CLASS: {
                return "templates/v4_1/embeddable-singleclass.vm";
            }
            case DATAMAP_SUPERCLASS: {
                return DMAP_SUPERCLASS_TEMPLATE;
            }
            case DATAMAP_SUBCLASS: {
                return DMAP_SUBCLASS_TEMPLATE;
            }
            case DATAMAP_SINGLE_CLASS: {
                return DATAMAP_SINGLE_CLASS_TEMPLATE;
            }
        }
        throw new IllegalArgumentException("Unsupported template type: " + (Object)((Object)type));
    }

    @Override
    public void addEntities(Collection<ObjEntity> entities) {
        if (!this.cgenConfiguration.getDataMap().isClientSupported()) {
            throw new CayenneRuntimeException("Can't create client classes. Check client supported option on DataMap configuration.", new Object[0]);
        }
        if (entities != null) {
            for (ObjEntity entity : entities) {
                if (entity.isServerOnly()) continue;
                this.cgenConfiguration.addArtifact(new ClientEntityArtifact(entity));
            }
        }
    }

    @Override
    public void addQueries(Collection<QueryDescriptor> queries) {
        if (this.cgenConfiguration.getArtifactsGenerationMode().equals(ArtifactsGenerationMode.ALL.getLabel()) && queries != null) {
            this.cgenConfiguration.addArtifact(new ClientDataMapArtifact(this.cgenConfiguration.getDataMap(), queries));
        }
    }

    @Override
    public void setCgenConfiguration(CgenConfiguration cgenConfiguration) {
        super.setCgenConfiguration(cgenConfiguration);
        cgenConfiguration.setQueryTemplate(DMAP_SUBCLASS_TEMPLATE);
        cgenConfiguration.setQuerySuperTemplate(DMAP_SUPERCLASS_TEMPLATE);
    }
}

