/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.dbsync;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.dbsync.BaseSchemaUpdateStrategy;
import org.apache.cayenne.access.dbsync.SchemaAnalyzer;
import org.apache.cayenne.map.DbEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrowOnPartialSchemaStrategy
extends BaseSchemaUpdateStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThrowOnPartialSchemaStrategy.class);

    @Override
    protected void processSchemaUpdate(DataNode dataNode) throws SQLException {
        SchemaAnalyzer analyzer = new SchemaAnalyzer();
        ArrayList<String> schemas = new ArrayList<String>();
        DatabaseMetaData md = null;
        try {
            try (Connection connection = dataNode.getDataSource().getConnection();){
                md = connection.getMetaData();
                try (ResultSet rs = md.getSchemas();){
                    while (rs.next()) {
                        String schemaName = rs.getString(1);
                        schemas.add(schemaName);
                    }
                }
            }
            analyzer.analyzeSchemas(schemas, md);
        }
        catch (Exception e) {
            LOGGER.debug("Exception analyzing schema, ignoring", e);
        }
        Collection<DbEntity> entities = dataNode.getEntityResolver().getDbEntities();
        boolean isIncluded = analyzer.compareTables(md, entities);
        if (isIncluded && analyzer.getErrorMessage() == null) {
            try {
                analyzer.compareColumns(md);
            }
            catch (SQLException e) {
                LOGGER.debug("Exception analyzing schema, ignoring", e);
            }
        }
        this.processSchemaUpdate(dataNode, analyzer.getTableNoInDB(), analyzer.getErrorMessage(), entities.size());
    }

    protected void processSchemaUpdate(DataNode dataNode, List<String> mergerOnlyTable, String errorMessage, int entitiesSize) throws SQLException {
        if (mergerOnlyTable.size() != 0 || errorMessage != null) {
            LOGGER.info("Error - missing or partial schema detected");
            StringBuilder buffer = new StringBuilder("Schema mismatch detected");
            if (errorMessage != null) {
                buffer.append(": ").append(errorMessage);
            } else if (mergerOnlyTable.size() == entitiesSize) {
                buffer.append(": no schema found");
            } else if (mergerOnlyTable.size() > 0) {
                buffer.append(": missing table '").append(mergerOnlyTable.get(0)).append('\'');
            }
            throw new CayenneRuntimeException(buffer.toString(), new Object[0]);
        }
        LOGGER.info("Full schema is present");
    }
}

