/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.util.UUID;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.types.ValueObjectType;

public class UUIDValueType
implements ValueObjectType<UUID, String> {
    @Override
    public Class<String> getTargetType() {
        return String.class;
    }

    @Override
    public Class<UUID> getValueType() {
        return UUID.class;
    }

    @Override
    public UUID toJavaObject(String value) {
        try {
            return UUID.fromString(value);
        }
        catch (IllegalArgumentException e) {
            throw new CayenneRuntimeException("Invalid UUID value: " + value, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public String fromJavaObject(UUID object) {
        return object.toString();
    }

    @Override
    public String toCacheKey(UUID object) {
        return object.toString();
    }
}

