/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.dbimport.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.FilterContainer;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.modeler.editor.dbimport.tree.Node;
import org.apache.cayenne.modeler.editor.dbimport.tree.Status;

abstract class TableNode<T extends Node>
extends Node<T> {
    TableNode(String name, T parent) {
        super(name, parent);
    }

    @Override
    public Status getStatus(ReverseEngineering config) {
        Status parentStatus;
        Object parent = this.getParent();
        if (parent != null && (parentStatus = ((Node)parent).getStatus(config)) != Status.INCLUDE) {
            return parentStatus;
        }
        ArrayList<IncludeTable> includeTables = new ArrayList<IncludeTable>();
        ArrayList<ExcludeTable> excludeTables = new ArrayList<ExcludeTable>();
        for (FilterContainer container : this.getContainers(config)) {
            if (container == null) continue;
            includeTables.addAll(container.getIncludeTables());
            excludeTables.addAll(container.getExcludeTables());
        }
        return this.includesTable(includeTables, excludeTables);
    }

    abstract List<FilterContainer> getContainers(ReverseEngineering var1);

    Status includesTable(Collection<IncludeTable> includeTables, Collection<ExcludeTable> excludeTables) {
        if (includeTables.isEmpty() && excludeTables.isEmpty()) {
            return Status.INCLUDE;
        }
        if (!includeTables.isEmpty() && this.getIncludeTable(includeTables) != null) {
            return Status.INCLUDE;
        }
        if (!excludeTables.isEmpty()) {
            if (this.getExcludeTable(excludeTables) != null) {
                return Status.EXCLUDE_EXPLICIT;
            }
            return includeTables.isEmpty() ? Status.INCLUDE : Status.EXCLUDE_IMPLICIT;
        }
        return Status.EXCLUDE_IMPLICIT;
    }

    IncludeTable getIncludeTable(Collection<IncludeTable> includeTables) {
        for (IncludeTable table : includeTables) {
            if (!this.getName().matches(table.getPattern())) continue;
            return table;
        }
        return null;
    }

    ExcludeTable getExcludeTable(Collection<ExcludeTable> excludeTables) {
        for (ExcludeTable table : excludeTables) {
            if (!this.getName().matches(table.getPattern())) continue;
            return table;
        }
        return null;
    }
}

