/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.hsqldb.HSQLDBAdapter;

class DbGeneratorPostprocessor {
    private static final Map<String, HSQLDBPostprocessor> postprocessors = new HashMap<String, HSQLDBPostprocessor>();

    DbGeneratorPostprocessor() {
    }

    void execute(Connection connection, DbAdapter adapter) throws SQLException {
        Postprocessor postprocessor;
        if (adapter != null && (postprocessor = (Postprocessor)postprocessors.get(adapter.getClass().getName())) != null) {
            postprocessor.execute(connection);
        }
    }

    static {
        postprocessors.put(HSQLDBAdapter.class.getName(), new HSQLDBPostprocessor());
    }

    static abstract class Postprocessor {
        Postprocessor() {
        }

        abstract void execute(Connection var1) throws SQLException;
    }

    static class HSQLDBPostprocessor
    extends Postprocessor {
        HSQLDBPostprocessor() {
        }

        @Override
        void execute(Connection c) throws SQLException {
            try (PreparedStatement st = c.prepareStatement("CHECKPOINT");){
                st.execute();
            }
        }
    }
}

