/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.value.json;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.value.json.AbstractJsonConsumer;
import org.apache.cayenne.value.json.JsonTokenizer;

class JsonReader
extends AbstractJsonConsumer<Object> {
    private final Deque<Object> objects = new ArrayDeque<Object>(4);
    private final Deque<Object> names = new ArrayDeque<Object>(4);

    JsonReader(String json) {
        super(json);
    }

    @Override
    protected void onArrayStart() {
        this.objects.addLast(new ArrayList(4));
    }

    @Override
    protected void onObjectStart() {
        this.objects.addLast(new HashMap());
    }

    @Override
    protected void onArrayValue(JsonTokenizer.JsonToken token) {
        this.onArrayValue((Object)token);
    }

    void onArrayValue(Object value) {
        Object array = this.objects.getLast();
        if (!(array instanceof List)) {
            throw new IllegalStateException("Expected List got " + array.getClass().getSimpleName());
        }
        ((List)array).add(value);
    }

    @Override
    protected void onObjectKey(JsonTokenizer.JsonToken token) {
        this.names.addLast(token);
    }

    @Override
    protected void onObjectValue(JsonTokenizer.JsonToken token) {
        this.onObjectValue(token, false);
    }

    protected void onObjectValue(Object value, boolean updateState) {
        Object name = this.names.pollLast();
        Object map = this.objects.getLast();
        if (!(map instanceof Map)) {
            throw new IllegalStateException("Expected Map got " + map.getClass().getSimpleName());
        }
        ((Map)map).put(name, value);
        if (updateState) {
            this.setState(AbstractJsonConsumer.State.OBJECT_KEY);
        }
    }

    @Override
    protected void onValue(JsonTokenizer.JsonToken token) {
        this.objects.addLast(token);
    }

    @Override
    protected void onArrayEnd() {
        Object value = this.objects.pollLast();
        this.onValue(value);
    }

    @Override
    protected void onObjectEnd() {
        Object value = this.objects.pollLast();
        this.onValue(value);
    }

    void onValue(Object value) {
        switch (this.currentState()) {
            case OBJECT_VALUE: {
                this.onObjectValue(value, true);
                break;
            }
            case ARRAY: {
                this.onArrayValue(value);
                break;
            }
            default: {
                this.objects.addLast(value);
            }
        }
    }

    @Override
    protected Object output() {
        if (this.objects.isEmpty()) {
            return null;
        }
        return this.objects.getFirst();
    }
}

