/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validation;

import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.project.validation.ConfigurationNodeValidator;
import org.apache.cayenne.project.validation.NameValidationHelper;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationResult;

class ObjRelationshipValidator
extends ConfigurationNodeValidator {
    ObjRelationshipValidator() {
    }

    void validate(ObjRelationship relationship, ValidationResult validationResult) {
        ObjRelationship reverseRelationship;
        ObjRelationship inverse;
        if (Util.isEmptyString((CharSequence)relationship.getName())) {
            this.addFailure(validationResult, relationship, "Unnamed ObjRelationship", new Object[0]);
        } else if (relationship.getSourceEntity().getAttribute(relationship.getName()) != null) {
            this.addFailure(validationResult, relationship, "ObjRelationship '%s' has the same name as one of ObjAttributes", this.toString(relationship));
        } else {
            NameValidationHelper helper = NameValidationHelper.getInstance();
            String invalidChars = helper.invalidCharsInObjPathComponent(relationship.getName());
            if (invalidChars != null) {
                this.addFailure(validationResult, relationship, "ObjRelationship name '%s' contains invalid characters: %s", this.toString(relationship), invalidChars);
            } else if (helper.invalidDataObjectProperty(relationship.getName())) {
                this.addFailure(validationResult, relationship, "ObjRelationship name '%s' is a reserved word", this.toString(relationship));
            }
        }
        if (relationship.getTargetEntity() == null) {
            this.addFailure(validationResult, relationship, "ObjRelationship '%s' has no target entity", this.toString(relationship));
        } else {
            List dbRels = relationship.getDbRelationships();
            if (dbRels.isEmpty()) {
                this.addFailure(validationResult, relationship, "ObjRelationship '%s' has no DbRelationship mapping", this.toString(relationship));
            } else {
                DbEntity expectedSrc = relationship.getSourceEntity().getDbEntity();
                DbEntity expectedTarget = relationship.getTargetEntity().getDbEntity();
                if (((DbRelationship)dbRels.get(0)).getSourceEntity() != expectedSrc || ((DbRelationship)dbRels.get(dbRels.size() - 1)).getTargetEntity() != expectedTarget) {
                    this.addFailure(validationResult, relationship, "ObjRelationship '%s' has incomplete DbRelationship mapping", this.toString(relationship));
                }
            }
        }
        if (relationship.isToMany() && !relationship.isFlattened() && relationship.getDeleteRule() == 1 && (inverse = relationship.getReverseRelationship()) != null) {
            DbRelationship firstRel = (DbRelationship)inverse.getDbRelationships().get(0);
            Iterator attributePairIterator = firstRel.getJoins().iterator();
            boolean check = true;
            while (attributePairIterator.hasNext()) {
                DbJoin pair = (DbJoin)attributePairIterator.next();
                if (pair.getSource().isMandatory()) continue;
                check = false;
                break;
            }
            if (check) {
                this.addFailure(validationResult, relationship, "ObjRelationship '%s' has a Nullify delete rule and a mandatory reverse relationship", this.toString(relationship));
            }
        }
        if (!(relationship.getDbRelationships().isEmpty() || relationship.isToPK() || (reverseRelationship = relationship.getReverseRelationship()) == null || relationship.getDbRelationships().isEmpty() || reverseRelationship.isToPK())) {
            this.addFailure(validationResult, relationship, "ObjRelationship '%s' has join not to PK. This is not fully supported by Cayenne.", this.toString(relationship));
        }
        ObjEntity entity = relationship.getSourceEntity();
        for (ObjRelationship rel : entity.getRelationships()) {
            if (relationship.getDbRelationshipPath() == null || !relationship.getDbRelationshipPath().equals(rel.getDbRelationshipPath()) || relationship == rel || relationship.getTargetEntity() != rel.getTargetEntity() || relationship.getSourceEntity() != rel.getSourceEntity()) continue;
            this.addFailure(validationResult, relationship, "ObjectRelationship '%s' duplicates relationship '%s'", this.toString(relationship), this.toString(rel));
        }
        if (relationship.getReverseRelationship() != null) {
            ObjRelationship revRel = relationship.getReverseRelationship();
            if (relationship.getSourceEntity() != revRel.getTargetEntity() || relationship.getTargetEntity() != revRel.getSourceEntity()) {
                this.addFailure(validationResult, revRel, "Usage of super entity's relationships '%s' as reversed relationships for sub entity is discouraged", this.toString(revRel));
            }
        }
        this.checkForDuplicates(relationship, validationResult);
    }

    private void checkForDuplicates(ObjRelationship relationship, ValidationResult validationResult) {
        if (relationship != null && relationship.getName() != null && relationship.getTargetEntityName() != null) {
            String dbRelationshipPath = relationship.getTargetEntityName() + "." + relationship.getDbRelationshipPath();
            ObjEntity entity = relationship.getSourceEntity();
            for (ObjRelationship comparisonRelationship : entity.getRelationships()) {
                String comparisonDbRelationshipPath;
                if (relationship == comparisonRelationship || !dbRelationshipPath.equals(comparisonDbRelationshipPath = comparisonRelationship.getTargetEntityName() + "." + comparisonRelationship.getDbRelationshipPath())) continue;
                this.addFailure(validationResult, relationship, "ObjEntity '%s' contains a duplicate ObjRelationship mapping ('%s' -> '%s')", entity.getName(), relationship.getName(), dbRelationshipPath);
                return;
            }
        }
    }

    private String toString(ObjRelationship relationship) {
        if (relationship.getSourceEntity() == null) {
            return "[null source entity]." + relationship.getName();
        }
        return relationship.getSourceEntity().getName() + "." + relationship.getName();
    }
}

