/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.graph.ArcId;
import org.apache.cayenne.graph.GraphChangeHandler;
import org.apache.cayenne.graph.GraphManager;

class ObjectContextStateLog
implements GraphChangeHandler {
    Set<Object> dirtyIds = new HashSet<Object>();
    GraphManager graphManager;

    ObjectContextStateLog(GraphManager graphManager) {
        this.graphManager = graphManager;
    }

    void clear() {
        this.dirtyIds = new HashSet<Object>();
    }

    void graphCommitted() {
        ArrayList<Object> deletedIds = new ArrayList<Object>();
        for (Object id : this.dirtyIds) {
            Object node = this.graphManager.getNode(id);
            if (!(node instanceof Persistent)) continue;
            Persistent persistentNode = (Persistent)node;
            switch (persistentNode.getPersistenceState()) {
                case 2: 
                case 4: {
                    persistentNode.setPersistenceState(3);
                    break;
                }
                case 6: {
                    deletedIds.add(id);
                    persistentNode.setPersistenceState(1);
                }
            }
        }
        for (Object id : deletedIds) {
            this.graphManager.unregisterNode(id);
        }
        this.clear();
    }

    void graphReverted() {
        for (Object id : this.dirtyIds) {
            Object node = this.graphManager.getNode(id);
            if (!(node instanceof Persistent)) continue;
            Persistent persistentNode = (Persistent)node;
            switch (persistentNode.getPersistenceState()) {
                case 4: 
                case 6: {
                    persistentNode.setPersistenceState(3);
                    break;
                }
                case 2: {
                    persistentNode.setPersistenceState(1);
                }
            }
        }
        this.clear();
    }

    boolean hasChanges() {
        return !this.dirtyIds.isEmpty();
    }

    Collection<Object> dirtyIds() {
        return this.dirtyIds;
    }

    Collection<Object> dirtyNodes() {
        if (this.dirtyIds.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList<Object> objects = new ArrayList<Object>(this.dirtyIds.size());
        for (Object id : this.dirtyIds) {
            objects.add(this.graphManager.getNode(id));
        }
        return objects;
    }

    Collection<Object> dirtyNodes(int state) {
        if (this.dirtyIds.isEmpty()) {
            return Collections.emptySet();
        }
        int size = this.dirtyIds.size();
        ArrayList<Object> objects = new ArrayList<Object>(size > 50 ? size / 2 : size);
        for (Object id : this.dirtyIds) {
            Persistent o = (Persistent)this.graphManager.getNode(id);
            if (o.getPersistenceState() != state) continue;
            objects.add(o);
        }
        return objects;
    }

    void unregisterNode(Object nodeId) {
        this.dirtyIds.remove(nodeId);
    }

    @Override
    public void nodeIdChanged(Object nodeId, Object newId) {
        if (this.dirtyIds.remove(nodeId)) {
            this.dirtyIds.add(newId);
        }
    }

    @Override
    public void nodeCreated(Object nodeId) {
        this.dirtyIds.add(nodeId);
    }

    @Override
    public void nodeRemoved(Object nodeId) {
        this.dirtyIds.add(nodeId);
    }

    @Override
    public void nodePropertyChanged(Object nodeId, String property, Object oldValue, Object newValue) {
        this.dirtyIds.add(nodeId);
    }

    @Override
    public void arcCreated(Object nodeId, Object targetNodeId, ArcId arcId) {
        this.dirtyIds.add(nodeId);
    }

    @Override
    public void arcDeleted(Object nodeId, Object targetNodeId, ArcId arcId) {
        this.dirtyIds.add(nodeId);
    }
}

