/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.flush;

import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.ObjectDiff;
import org.apache.cayenne.access.flush.ObjectIdValueSupplier;
import org.apache.cayenne.access.flush.operation.DbRowOpWithQualifier;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;

class OptimisticLockQualifierBuilder
implements PropertyVisitor {
    private final DbRowOpWithQualifier dbRow;
    private final ObjectDiff diff;

    OptimisticLockQualifierBuilder(DbRowOpWithQualifier dbRow, ObjectDiff diff) {
        this.dbRow = dbRow;
        this.diff = diff;
    }

    @Override
    public boolean visitAttribute(AttributeProperty property) {
        ObjAttribute attribute = property.getAttribute();
        DbAttribute dbAttribute = attribute.getDbAttribute();
        if (attribute.isUsedForLocking() && dbAttribute.getEntity() == this.dbRow.getEntity()) {
            this.dbRow.getQualifier().addAdditionalQualifier(dbAttribute, this.diff.getSnapshotValue(property.getName()), true);
        }
        return true;
    }

    @Override
    public boolean visitToOne(ToOneProperty property) {
        ObjRelationship relationship = property.getRelationship();
        if (relationship.isUsedForLocking()) {
            ObjectId value = this.diff.getArcSnapshotValue(property.getName());
            DbRelationship dbRelationship = relationship.getDbRelationships().get(0);
            for (DbJoin join : dbRelationship.getJoins()) {
                DbAttribute source = join.getSource();
                if (source.isPrimaryKey()) continue;
                Object valueObjectId = value != null ? ObjectIdValueSupplier.getFor(value, join.getTargetName()) : null;
                this.dbRow.getQualifier().addAdditionalQualifier(source, valueObjectId, true);
            }
        }
        return true;
    }

    @Override
    public boolean visitToMany(ToManyProperty property) {
        return true;
    }
}

