/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.util.IDUtil;
import org.apache.cayenne.util.MemoryBlob;

public class ByteArrayType
implements ExtendedType<byte[]> {
    private static final int BUF_SIZE = 8192;
    protected boolean trimmingBytes;
    protected boolean usingBlobs;

    public static void logBytes(StringBuilder buffer, byte[] bytes) {
        buffer.append("<");
        int len = bytes.length;
        boolean trimming = false;
        if (len > 30) {
            len = 30;
            trimming = true;
        }
        for (int i = 0; i < len; ++i) {
            IDUtil.appendFormattedByte(buffer, bytes[i]);
        }
        if (trimming) {
            buffer.append("...");
        }
        buffer.append('>');
    }

    public static byte[] trimBytes(byte[] bytes) {
        int bytesToTrim = 0;
        for (int i = bytes.length - 1; i >= 0; --i) {
            if (bytes[i] == 0) continue;
            bytesToTrim = bytes.length - 1 - i;
            break;
        }
        if (bytesToTrim == 0) {
            return bytes;
        }
        byte[] dest = new byte[bytes.length - bytesToTrim];
        System.arraycopy(bytes, 0, dest, 0, dest.length);
        return dest;
    }

    public ByteArrayType(boolean trimmingBytes, boolean usingBlobs) {
        this.usingBlobs = usingBlobs;
        this.trimmingBytes = trimmingBytes;
    }

    @Override
    public String getClassName() {
        return "byte[]";
    }

    @Override
    public byte[] materializeObject(ResultSet rs, int index, int type) throws Exception {
        byte[] bytes = null;
        if (type == 2004) {
            bytes = this.isUsingBlobs() ? this.readBlob(rs.getBlob(index)) : this.readBinaryStream(rs, index);
        } else {
            bytes = rs.getBytes(index);
            if (bytes != null && type == -2 && this.isTrimmingBytes()) {
                bytes = ByteArrayType.trimBytes(bytes);
            }
        }
        return bytes;
    }

    @Override
    public byte[] materializeObject(CallableStatement cs, int index, int type) throws Exception {
        byte[] bytes = null;
        if (type == 2004) {
            if (!this.isUsingBlobs()) {
                throw new CayenneRuntimeException("Binary streams are not supported in stored procedure parameters.", new Object[0]);
            }
            bytes = this.readBlob(cs.getBlob(index));
        } else {
            bytes = cs.getBytes(index);
            if (bytes != null && type == -2 && this.isTrimmingBytes()) {
                bytes = ByteArrayType.trimBytes(bytes);
            }
        }
        return bytes;
    }

    @Override
    public void setJdbcObject(PreparedStatement st, byte[] val, int pos, int type, int scale) throws Exception {
        if (type == 2004) {
            if (this.isUsingBlobs()) {
                st.setBlob(pos, this.writeBlob(val));
            } else {
                st.setBytes(pos, val);
            }
        } else if (scale != -1) {
            st.setObject(pos, (Object)val, type, scale);
        } else {
            st.setObject(pos, (Object)val, type);
        }
    }

    @Override
    public String toString(byte[] value) {
        if (value == null) {
            return "NULL";
        }
        StringBuilder buffer = new StringBuilder();
        ByteArrayType.logBytes(buffer, value);
        return buffer.toString();
    }

    protected Blob writeBlob(byte[] bytes) {
        return bytes != null ? new MemoryBlob(bytes) : null;
    }

    protected byte[] readBlob(Blob blob) throws IOException, SQLException {
        if (blob == null) {
            return null;
        }
        if (blob.length() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("BLOB is too big to be read as byte[] in memory: " + blob.length());
        }
        int size = (int)blob.length();
        if (size == 0) {
            return new byte[0];
        }
        return blob.getBytes(1L, size);
    }

    protected byte[] readBinaryStream(ResultSet rs, int index) throws IOException, SQLException {
        try (InputStream in = rs.getBinaryStream(index);){
            byte[] byArray = in != null ? this.readValueStream(in, -1, 8192) : null;
            return byArray;
        }
    }

    protected byte[] readValueStream(InputStream in, int streamSize, int bufSize) throws IOException {
        int read;
        ByteArrayOutputStream out;
        byte[] buf = new byte[bufSize];
        ByteArrayOutputStream byteArrayOutputStream = out = streamSize > 0 ? new ByteArrayOutputStream(streamSize) : new ByteArrayOutputStream();
        while ((read = in.read(buf, 0, bufSize)) >= 0) {
            out.write(buf, 0, read);
        }
        return out.toByteArray();
    }

    public boolean isUsingBlobs() {
        return this.usingBlobs;
    }

    public void setUsingBlobs(boolean usingBlobs) {
        this.usingBlobs = usingBlobs;
    }

    public boolean isTrimmingBytes() {
        return this.trimmingBytes;
    }

    public void setTrimmingBytes(boolean trimingBytes) {
        this.trimmingBytes = trimingBytes;
    }
}

