/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.dbimport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cayenne.configuration.ConfigurationNodeVisitor;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeRelationship;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.PatternParam;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;

public class IncludeTable
extends PatternParam
implements XMLSerializable {
    private final List<IncludeColumn> includeColumns = new ArrayList<IncludeColumn>();
    private final List<ExcludeColumn> excludeColumns = new ArrayList<ExcludeColumn>();
    private final List<ExcludeRelationship> excludeRelationship = new ArrayList<ExcludeRelationship>();

    public IncludeTable() {
    }

    public IncludeTable(String pattern) {
        super(pattern);
    }

    public IncludeTable(IncludeTable original) {
        super(original);
        for (IncludeColumn includeColumn : original.getIncludeColumns()) {
            this.addIncludeColumn(new IncludeColumn(includeColumn));
        }
        for (ExcludeColumn excludeColumn : original.getExcludeColumns()) {
            this.addExcludeColumn(new ExcludeColumn(excludeColumn));
        }
    }

    public List<IncludeColumn> getIncludeColumns() {
        return this.includeColumns;
    }

    public void setIncludeColumns(Collection<IncludeColumn> includeColumns) {
        this.includeColumns.addAll(includeColumns);
    }

    public List<ExcludeColumn> getExcludeColumns() {
        return this.excludeColumns;
    }

    public void setExcludeColumns(Collection<ExcludeColumn> excludeColumns) {
        this.excludeColumns.addAll(excludeColumns);
    }

    public List<ExcludeRelationship> getExcludeRelationship() {
        return this.excludeRelationship;
    }

    public void setExcludeRelationship(Collection<ExcludeRelationship> excludeRelationship) {
        this.excludeRelationship.addAll(excludeRelationship);
    }

    public void addIncludeColumn(IncludeColumn includeColumn) {
        this.includeColumns.add(includeColumn);
    }

    public void addExcludeColumn(ExcludeColumn excludeColumn) {
        this.excludeColumns.add(excludeColumn);
    }

    public void addExcludeRelationship(ExcludeRelationship excludeRelationship) {
        this.excludeRelationship.add(excludeRelationship);
    }

    @Override
    public void encodeAsXML(XMLEncoder encoder, ConfigurationNodeVisitor delegate) {
        encoder.start("includeTable").simpleTag("name", this.getPattern()).nested(this.getIncludeColumns(), delegate).nested(this.getExcludeColumns(), delegate).end();
    }

    @Override
    public StringBuilder toString(StringBuilder res, String s) {
        super.toString(res, s);
        String prefix = s + "  ";
        if (this.includeColumns != null && !this.includeColumns.isEmpty()) {
            for (IncludeColumn includeColumn : this.includeColumns) {
                includeColumn.toString(res, prefix);
            }
        }
        if (this.excludeColumns != null && !this.excludeColumns.isEmpty()) {
            for (ExcludeColumn excludeColumn : this.excludeColumns) {
                excludeColumn.toString(res, prefix);
            }
        }
        if (this.excludeRelationship != null && !this.excludeRelationship.isEmpty()) {
            for (ExcludeRelationship excludeRelationship : this.excludeRelationship) {
                excludeRelationship.toString(res, prefix);
            }
        }
        return res;
    }
}

