/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.dbload;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoadDataStore;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoaderConfiguration;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoaderDelegate;
import org.apache.cayenne.dbsync.reverse.dbload.ExportedKey;
import org.apache.cayenne.dbsync.reverse.dbload.PerEntityLoader;
import org.apache.cayenne.map.DbEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExportedKeyLoader
extends PerEntityLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportedKeyLoader.class);

    ExportedKeyLoader(DbLoaderConfiguration config, DbLoaderDelegate delegate) {
        super(null, config, delegate);
    }

    @Override
    boolean shouldLoad(DbEntity entity) {
        return this.delegate.dbRelationship(entity);
    }

    @Override
    boolean catchException(DbEntity entity, SQLException ex) {
        LOGGER.info("Error getting relationships for '" + entity.getCatalog() + "." + entity.getSchema() + "', ignoring. " + ex.getMessage(), ex);
        return true;
    }

    @Override
    ResultSet getResultSet(DbEntity dbEntity, DatabaseMetaData metaData) throws SQLException {
        return metaData.getExportedKeys(dbEntity.getCatalog(), dbEntity.getSchema(), dbEntity.getName());
    }

    @Override
    void processResultSet(DbEntity dbEntity, DbLoadDataStore map, ResultSet rs) throws SQLException {
        ExportedKey key = new ExportedKey(rs);
        DbEntity pkEntity = map.getDbEntity(key.getPk().getTable());
        if (!key.getPk().validateEntity(pkEntity)) {
            LOGGER.info("Skip relation: '" + key + "' because table '" + key.getPk().getTable() + "' is not found or in different catalog/schema");
            return;
        }
        DbEntity fkEntity = map.getDbEntity(key.getFk().getTable());
        if (!key.getFk().validateEntity(fkEntity)) {
            LOGGER.info("Skip relation: '" + key + "' because table '" + key.getFk().getTable() + "' is not found or in different catalog/schema");
            return;
        }
        map.addExportedKey(key);
    }
}

