/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.di.spi;

import java.util.Map;
import org.apache.cayenne.di.DIRuntimeException;
import org.apache.cayenne.di.Key;
import org.apache.cayenne.di.MapBuilder;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.di.spi.Binding;
import org.apache.cayenne.di.spi.DICollectionBuilder;
import org.apache.cayenne.di.spi.DefaultInjector;
import org.apache.cayenne.di.spi.MapProvider;

class DefaultMapBuilder<T>
extends DICollectionBuilder<Map<String, T>, T>
implements MapBuilder<T> {
    DefaultMapBuilder(Key<Map<String, T>> bindingKey, DefaultInjector injector) {
        super(bindingKey, injector);
        this.findOrCreateMapProvider();
    }

    @Override
    public MapBuilder<T> put(String key, Class<? extends T> interfaceType) throws DIRuntimeException {
        Provider<? extends T> provider = this.createTypeProvider(interfaceType);
        this.findOrCreateMapProvider().put(key, provider);
        return this;
    }

    @Override
    public MapBuilder<T> put(String key, T value) throws DIRuntimeException {
        this.findOrCreateMapProvider().put(key, this.createInstanceProvider(value));
        return this;
    }

    @Override
    public MapBuilder<T> putAll(Map<String, T> map) throws DIRuntimeException {
        MapProvider<T> provider = this.findOrCreateMapProvider();
        for (Map.Entry<String, T> entry : map.entrySet()) {
            provider.put(entry.getKey(), this.createInstanceProvider(entry.getValue()));
        }
        return this;
    }

    private MapProvider<T> findOrCreateMapProvider() {
        MapProvider provider;
        Binding binding = this.injector.getBinding(this.bindingKey);
        if (binding == null) {
            provider = new MapProvider();
            this.injector.putBinding(this.bindingKey, provider);
        } else {
            provider = (MapProvider)binding.getOriginal();
        }
        return provider;
    }
}

