/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.io.IOException;
import java.util.List;
import org.apache.cayenne.exp.parser.EvaluatedNode;

public abstract class ASTFunctionCall
extends EvaluatedNode {
    protected String functionName;

    ASTFunctionCall(int id, String functionName) {
        super(id);
        this.setFunctionName(functionName);
    }

    public ASTFunctionCall(int id, String functionName, Object ... nodes) {
        this(id, functionName);
        this.setFunctionName(functionName);
        int len = nodes.length;
        for (int i = 0; i < len; ++i) {
            this.jjtAddChild(this.wrapChild(nodes[i]), i);
        }
        this.connectChildren();
    }

    @Override
    public int getType() {
        return 45;
    }

    public boolean needParenthesis() {
        return true;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    protected void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    @Override
    protected String getExpressionOperator(int index) {
        return ",";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ASTFunctionCall that = (ASTFunctionCall)o;
        return this.functionName.equals(that.functionName);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.functionName.hashCode();
    }

    protected void appendFunctionNameAsString(Appendable out) throws IOException {
        out.append(ASTFunctionCall.nameToCamelCase(this.getFunctionName()));
    }

    @Override
    public void appendAsString(Appendable out) throws IOException {
        this.appendFunctionNameAsString(out);
        if (this.parent == null) {
            out.append("(");
        }
        super.appendAsString(out);
        if (this.parent == null) {
            out.append(")");
        }
    }

    @Override
    public void appendAsEJBQL(List<Object> parameterAccumulator, Appendable out, String rootId) throws IOException {
        out.append(this.getFunctionName());
        out.append("(");
        super.appendChildrenAsEJBQL(parameterAccumulator, out, rootId);
        out.append(")");
    }

    protected static String nameToCamelCase(String functionName) {
        String[] parts = functionName.split("_");
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String part : parts) {
            if (first) {
                sb.append(part.toLowerCase());
                first = false;
                continue;
            }
            char[] chars = part.toLowerCase().toCharArray();
            chars[0] = Character.toTitleCase(chars[0]);
            sb.append(chars);
        }
        return sb.toString();
    }
}

