/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog;

import java.util.prefs.Preferences;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.dialog.pref.GeneralPreferences;

public class ConfirmRemoveDialog {
    private static final String DELETE = "Delete";
    private boolean shouldDelete = true;
    private boolean allowAsking;

    public ConfirmRemoveDialog(boolean allowAsking) {
        this.allowAsking = allowAsking;
    }

    private void showDialog(String name) {
        JCheckBox neverPromptAgainBox = new JCheckBox("Always delete without prompt.");
        Object[] message = new Object[]{String.format("Are you sure you would like to delete the %s?", name), neverPromptAgainBox};
        JOptionPane pane = new JOptionPane(message, 3);
        pane.setOptions(new Object[]{DELETE, "Cancel"});
        pane.setInitialValue(DELETE);
        pane.createDialog(Application.getFrame(), "Confirm Delete").setVisible(true);
        this.shouldDelete = DELETE.equals(pane.getValue());
        if (this.shouldDelete) {
            Preferences pref = Application.getInstance().getPreferencesNode(GeneralPreferences.class, "");
            pref.putBoolean("deletePrompt", neverPromptAgainBox.isSelected());
        }
    }

    public boolean shouldDelete(String type, String name) {
        return this.shouldDelete(String.format("%s named '%s'", type, name));
    }

    public boolean shouldDelete(String name) {
        Preferences pref;
        if (this.allowAsking && ((pref = Application.getInstance().getPreferencesNode(GeneralPreferences.class, "")) == null || !pref.getBoolean("deletePrompt", false))) {
            this.showDialog(name);
        }
        return this.shouldDelete;
    }
}

