/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.table.TableColumn;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.dbsync.naming.NameBuilder;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.event.RelationshipEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.DbRelationshipDialogView;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.DbJoinTableModel;
import org.apache.cayenne.modeler.dialog.WarningDialogByDbTargetChange;
import org.apache.cayenne.modeler.event.RelationshipDisplayEvent;
import org.apache.cayenne.modeler.undo.CreateRelationshipUndoableEdit;
import org.apache.cayenne.modeler.undo.RelationshipUndoableEdit;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.modeler.util.combo.AutoCompletion;
import org.apache.cayenne.project.extension.info.ObjectInfo;
import org.apache.cayenne.util.Util;

public class DbRelationshipDialog
extends CayenneController {
    private static final Comparator<DbEntity> DB_ENTITY_COMPARATOR = Comparator.comparing(ent -> ent.getDataMap().getName()).thenComparing(Entity::getName);
    private DbRelationship relationship;
    private DbRelationship reverseRelationship;
    private DbRelationshipDialogView view = new DbRelationshipDialogView();
    private boolean isCreate = false;
    private ProjectController projectController;
    private RelationshipUndoableEdit undo;

    public DbRelationshipDialog(ProjectController projectController) {
        this.projectController = projectController;
    }

    @Override
    public Component getView() {
        return this.view;
    }

    public DbRelationshipDialog createNewRelationship(DbEntity dbEntity) {
        this.isCreate = true;
        DbRelationship rel = new DbRelationship();
        rel.setName(NameBuilder.builder(rel, dbEntity).name());
        rel.setSourceEntity(dbEntity);
        return this.modifyRaltionship(rel);
    }

    public DbRelationshipDialog modifyRaltionship(DbRelationship dbRelationship) {
        this.undo = new RelationshipUndoableEdit(dbRelationship);
        this.relationship = dbRelationship;
        this.reverseRelationship = this.relationship.getReverseRelationship();
        if (this.relationship.getSourceEntity() == null) {
            throw new CayenneRuntimeException("Null source entity: %s", this.relationship);
        }
        if (this.relationship.getSourceEntity().getDataMap() == null) {
            throw new CayenneRuntimeException("Null DataMap: %s", this.relationship.getSourceEntity());
        }
        this.initController();
        this.initFromModel();
        return this;
    }

    public void startUp() {
        this.view.setVisible(true);
        this.view.dispose();
    }

    private void initFromModel() {
        TargetComboBoxModel targetComboBoxModel = new TargetComboBoxModel(this.projectController.getEntityResolver().getDbEntities());
        this.view.getTargetEntities().setModel(targetComboBoxModel);
        this.view.getSourceName().setText(this.relationship.getSourceEntityName());
        this.view.getToDepPk().setSelected(this.relationship.isToDependentPK());
        this.view.getToMany().setSelected(this.relationship.isToMany());
        this.view.getNameField().setText(this.relationship.getName());
        if (this.reverseRelationship != null) {
            this.view.getReverseName().setText(this.reverseRelationship.getName());
        }
        if (this.relationship.getTargetEntity() == null) {
            this.enableOptions(false);
        } else {
            this.enableInfo();
        }
        this.view.getComment().setText(ObjectInfo.getFromMetaData(this.projectController.getApplication().getMetaData(), this.relationship, "comment"));
    }

    private void initController() {
        this.view.getTargetEntities().addActionListener(action -> {
            DbEntity selectedItem = ((TargetComboBoxModel)this.view.getTargetEntities().getModel()).selected;
            if (this.relationship.getTargetEntityName() == null) {
                this.relationship.setTargetEntityName(selectedItem.getName());
            } else if (!this.relationship.getTargetEntityName().equals(selectedItem.getName())) {
                if (WarningDialogByDbTargetChange.showWarningDialog(this.projectController, this.relationship)) {
                    this.relationship.removeAllJoins();
                    this.relationship.setTargetEntityName(selectedItem.getName());
                } else {
                    this.view.getTargetEntities().setSelectedItem(this.relationship.getTargetEntityName());
                }
                this.relationship.setToDependentPK(false);
                this.view.getToDepPk().setSelected(this.relationship.isValidForDepPk());
                this.projectController.fireDbRelationshipEvent(new RelationshipEvent((Object)this, this.relationship, this.relationship.getSourceEntity()));
            }
            this.enableInfo();
        });
        this.view.getAddButton().addActionListener(e -> {
            DbJoinTableModel model = (DbJoinTableModel)this.view.getTable().getModel();
            DbJoin join = new DbJoin(this.relationship);
            this.relationship.addJoin(join);
            model.addRow(join);
            this.view.getTable().select(model.getRowCount() - 1);
        });
        this.view.getRemoveButton().addActionListener(e -> {
            DbJoinTableModel model = (DbJoinTableModel)this.view.getTable().getModel();
            this.stopEditing();
            int row = this.view.getTable().getSelectedRow();
            DbJoin join = model.getJoin(row);
            this.relationship.removeJoin(join);
            if (this.relationship.isValidForDepPk()) {
                this.view.getToDepPk().setEnabled(true);
            } else {
                this.view.getToDepPk().setEnabled(false);
                this.view.getToDepPk().setSelected(false);
                this.relationship.setToDependentPK(false);
            }
            model.removeRow(join);
        });
        this.view.getSaveButton().addActionListener(e -> {
            this.view.setCancelPressed(false);
            this.save();
            this.view.dispose();
            this.view.setVisible(false);
        });
        this.view.getCancelButton().addActionListener(e -> {
            this.view.setCancelPressed(true);
            this.view.setVisible(false);
        });
        this.view.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DbRelationshipDialog.this.view.setCancelPressed(true);
            }
        });
        this.view.getToDepPk().setEnabled(this.relationship.isValidForDepPk());
        this.view.getToDepPk().addActionListener(selected -> {
            boolean isSelected = this.view.getToDepPk().isSelected();
            DbRelationship reverseRelationship = this.relationship.getReverseRelationship();
            if (reverseRelationship != null && reverseRelationship.isToDependentPK() && isSelected) {
                boolean setToDepPk = JOptionPane.showConfirmDialog(Application.getFrame(), "Unset reverse relationship's \"To Dep PK\" setting?", "Warning", 2, -1) == 0;
                this.relationship.setToDependentPK(setToDepPk);
                reverseRelationship.setToDependentPK(!setToDepPk);
            } else {
                this.relationship.setToDependentPK(this.view.getToDepPk().isSelected());
            }
        });
    }

    private void enableInfo() {
        this.enableOptions(true);
        this.view.getTable().setModel(new DbJoinTableModel(this.relationship, this.projectController, this, true));
        this.view.getTable().getModel().addTableModelListener(change -> {
            if (change.getLastRow() != Integer.MAX_VALUE) {
                if (this.relationship.isValidForDepPk()) {
                    this.view.getToDepPk().setEnabled(true);
                } else {
                    this.view.getToDepPk().setEnabled(false);
                }
            }
        });
        TableColumn sourceColumn = this.view.getTable().getColumnModel().getColumn(0);
        JComboBox<String> comboBox = Application.getWidgetFactory().createComboBox(ModelerUtil.getDbAttributeNames(this.relationship.getSourceEntity()), true);
        AutoCompletion.enable(comboBox);
        sourceColumn.setCellEditor(Application.getWidgetFactory().createCellEditor(comboBox));
        TableColumn targetColumn = this.view.getTable().getColumnModel().getColumn(1);
        comboBox = Application.getWidgetFactory().createComboBox(ModelerUtil.getDbAttributeNames(this.relationship.getTargetEntity()), true);
        AutoCompletion.enable(comboBox);
        targetColumn.setCellEditor(Application.getWidgetFactory().createCellEditor(comboBox));
        this.view.getTablePreferences().bind(this.view.getTable(), null, null, null, 0, true);
    }

    private void enableOptions(boolean enable) {
        this.view.enableOptions(enable);
    }

    private void stopEditing() {
        int col_index = this.view.getTable().getEditingColumn();
        if (col_index >= 0) {
            TableColumn col = this.view.getTable().getColumnModel().getColumn(col_index);
            col.getCellEditor().stopCellEditing();
        }
    }

    private void save() {
        this.stopEditing();
        DbJoinTableModel model = (DbJoinTableModel)this.view.getTable().getModel();
        boolean updatingReverse = model.getObjectList().size() > 0;
        this.handleNameUpdate(this.relationship, this.view.getNameField().getText().trim());
        model.commit();
        this.relationship.setToMany(this.view.getToMany().isSelected());
        ObjectInfo.putToMetaData(this.projectController.getApplication().getMetaData(), this.relationship, "comment", this.view.getComment().getText());
        if (updatingReverse) {
            if (this.reverseRelationship == null) {
                this.reverseRelationship = new DbRelationship();
                this.reverseRelationship.setName(NameBuilder.builder(this.reverseRelationship, this.relationship.getTargetEntity()).baseName(this.view.getReverseName().getText().trim()).name());
                this.reverseRelationship.setSourceEntity(this.relationship.getTargetEntity());
                this.reverseRelationship.setTargetEntityName(this.relationship.getSourceEntity());
                this.reverseRelationship.setToMany(!this.relationship.isToMany());
                this.relationship.getTargetEntity().addRelationship(this.reverseRelationship);
                if (this.relationship.getSourceEntity() == this.relationship.getTargetEntity()) {
                    this.projectController.fireDbRelationshipEvent(new RelationshipEvent((Object)this, (Relationship)this.reverseRelationship, (Entity)this.reverseRelationship.getSourceEntity(), 2));
                }
            } else {
                this.handleNameUpdate(this.reverseRelationship, this.view.getReverseName().getText().trim());
            }
            Collection<DbJoin> reverseJoins = this.getReverseJoins();
            this.reverseRelationship.setJoins(reverseJoins);
            if (!this.relationship.isToDependentPK() && this.reverseRelationship.isValidForDepPk()) {
                this.reverseRelationship.setToDependentPK(true);
            }
        }
        this.fireDbRelationshipEvent(this.isCreate);
    }

    private void handleNameUpdate(DbRelationship relationship, String userInputName) {
        if (Util.nullSafeEquals(relationship.getName(), userInputName)) {
            return;
        }
        String sourceEntityName = NameBuilder.builder(relationship, relationship.getSourceEntity()).baseName(userInputName).name();
        if (Util.nullSafeEquals(sourceEntityName, relationship.getName())) {
            return;
        }
        String oldName = relationship.getName();
        relationship.setName(sourceEntityName);
        this.projectController.fireDbRelationshipEvent(new RelationshipEvent((Object)this, (Relationship)relationship, (Entity)relationship.getSourceEntity(), oldName));
    }

    private Collection<DbJoin> getReverseJoins() {
        List<DbJoin> joins = this.relationship.getJoins();
        if (joins == null || joins.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<DbJoin> reverseJoins = new ArrayList<DbJoin>(joins.size());
        for (DbJoin pair : joins) {
            DbJoin reverseJoin = pair.createReverseJoin();
            reverseJoin.setRelationship(this.reverseRelationship);
            reverseJoins.add(reverseJoin);
        }
        return reverseJoins;
    }

    private void fireDbRelationshipEvent(boolean isCreate) {
        if (!isCreate) {
            this.projectController.fireDbRelationshipEvent(new RelationshipEvent((Object)this, (Relationship)this.relationship, (Entity)this.relationship.getSourceEntity(), 1));
            Application.getInstance().getUndoManager().addEdit(this.undo);
        } else {
            DbEntity dbEntity = this.relationship.getSourceEntity();
            if (dbEntity.getRelationship(this.relationship.getName()) == null) {
                dbEntity.addRelationship(this.relationship);
            }
            this.projectController.fireDbRelationshipEvent(new RelationshipEvent((Object)this, (Relationship)this.relationship, (Entity)dbEntity, 2));
            RelationshipDisplayEvent rde = new RelationshipDisplayEvent((Object)this, this.relationship, (Entity)dbEntity, this.projectController.getCurrentDataMap(), (DataChannelDescriptor)this.projectController.getProject().getRootNode());
            this.projectController.fireDbRelationshipDisplayEvent(rde);
            Application.getInstance().getUndoManager().addEdit(new CreateRelationshipUndoableEdit(this.relationship.getSourceEntity(), new DbRelationship[]{this.relationship}));
        }
    }

    public Optional<DbRelationship> getRelationship() {
        return this.view.isCancelPressed() ? Optional.empty() : Optional.of(this.relationship);
    }

    final class TargetComboBoxModel
    extends AbstractListModel<String>
    implements ComboBoxModel<String> {
        private List<DbEntity> entities;
        private DbEntity selected;

        TargetComboBoxModel(Collection<DbEntity> dbEntities) {
            this.entities = new ArrayList<DbEntity>(dbEntities);
            this.entities.sort(DB_ENTITY_COMPARATOR);
            this.selected = DbRelationshipDialog.this.relationship.getTargetEntity();
        }

        private String getTitle(DbEntity entity) {
            if (entity == null) {
                return "";
            }
            return DbRelationshipDialog.this.relationship.getSourceEntity().getDataMap() == entity.getDataMap() ? entity.getName() : entity.getName() + " (" + entity.getDataMap().getName() + ')';
        }

        @Override
        public int getSize() {
            return this.entities.size();
        }

        @Override
        public String getElementAt(int index) {
            return this.getTitle(this.entities.get(index));
        }

        @Override
        public void setSelectedItem(Object anItem) {
            int spacer;
            String title = (String)anItem;
            if (title != null && (spacer = title.indexOf(32)) != -1) {
                title = title.substring(0, spacer);
            }
            this.selected = DbRelationshipDialog.this.projectController.getEntityResolver().getDbEntity(title);
        }

        @Override
        public Object getSelectedItem() {
            return this.getTitle(this.selected);
        }
    }
}

