/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.objentity;

import java.awt.Component;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.modeler.dialog.objentity.ClassNameUpdaterView;
import org.apache.cayenne.modeler.util.CayenneController;

public class ClassNameUpdater
extends CayenneController {
    protected ClassNameUpdaterView view;
    protected ObjEntity entity;
    protected boolean updatePerformed;

    public ClassNameUpdater(CayenneController parent, ObjEntity entity) {
        super(parent);
        this.entity = entity;
    }

    public boolean doNameUpdate() {
        this.view = null;
        this.updatePerformed = false;
        boolean askForServerUpdate = true;
        boolean askForClientUpdate = true;
        String oldServerName = this.entity.getClassName();
        String suggestedServerName = this.suggestedServerClassName();
        if (oldServerName == null || oldServerName.length() == 0) {
            askForServerUpdate = false;
        } else if (suggestedServerName == null || suggestedServerName.equals(oldServerName)) {
            askForServerUpdate = false;
        } else if (oldServerName.contains("UntitledObjEntity")) {
            this.entity.setClassName(suggestedServerName);
            this.updatePerformed = true;
            askForServerUpdate = false;
        }
        String suggestedClientName = this.suggestedClientClassName();
        String oldClientName = this.entity.getClientClassName();
        if (suggestedClientName == null || suggestedClientName.equals(oldClientName)) {
            askForClientUpdate = false;
        } else if (oldClientName == null || oldClientName.length() == 0 || oldClientName.contains("UntitledObjEntity")) {
            this.entity.setClientClassName(suggestedClientName);
            this.updatePerformed = true;
            askForClientUpdate = false;
        }
        if (askForClientUpdate || askForServerUpdate) {
            this.view = new ClassNameUpdaterView();
            if (askForServerUpdate) {
                this.view.getServerClass().setVisible(true);
                this.view.getServerClass().setSelected(true);
                this.view.getServerClass().setText("Change Class Name to '" + suggestedServerName + "'");
            }
            if (askForClientUpdate) {
                this.view.getClientClass().setVisible(true);
                this.view.getClientClass().setSelected(true);
                this.view.getClientClass().setText("Change Client Class Name to '" + suggestedClientName + "'");
            }
            this.initBindings(suggestedServerName, suggestedClientName);
            this.view.pack();
            this.view.setModal(true);
            this.centerView();
            this.makeCloseableOnEscape();
            this.view.setVisible(true);
        }
        return this.updatePerformed;
    }

    private String suggestedServerClassName() {
        String pkg = this.entity.getDataMap() == null ? null : this.entity.getDataMap().getDefaultPackage();
        return ClassNameUpdater.suggestedClassName(this.entity.getName(), pkg, this.entity.getClassName());
    }

    private String suggestedClientClassName() {
        if (!this.entity.isClientAllowed()) {
            return null;
        }
        String pkg = this.entity.getDataMap() == null ? null : this.entity.getDataMap().getDefaultClientPackage();
        return ClassNameUpdater.suggestedClassName(this.entity.getName(), pkg, this.entity.getClientClassName());
    }

    private static String suggestedClassName(String entityName, String suggestedPackage, String oldClassName) {
        int lastDotIndex;
        if (entityName == null || entityName.trim().isEmpty()) {
            return null;
        }
        String pkg = suggestedPackage;
        if (oldClassName != null && oldClassName.lastIndexOf(46) > 0) {
            pkg = oldClassName.substring(0, oldClassName.lastIndexOf(46));
        }
        if ((lastDotIndex = entityName.lastIndexOf(46)) >= 0 && lastDotIndex < entityName.length() - 1) {
            entityName = entityName.substring(lastDotIndex + 1);
        }
        return DataMap.getNameWithPackage(pkg, entityName);
    }

    protected void initBindings(String suggestedServerName, String suggestedClientName) {
        this.view.getUpdateButton().addActionListener(e -> {
            if (this.view.getClientClass().isSelected()) {
                this.entity.setClientClassName(suggestedClientName);
                this.updatePerformed = true;
            }
            if (this.view.getServerClass().isSelected()) {
                this.entity.setClassName(suggestedServerName);
                this.updatePerformed = true;
            }
            this.view.dispose();
        });
        this.view.getCancelButton().addActionListener(e -> this.view.dispose());
    }

    @Override
    public Component getView() {
        return this.view;
    }
}

