/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.map.event.ObjEntityListener;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.ActionManager;
import org.apache.cayenne.modeler.action.CopyAttributeRelationshipAction;
import org.apache.cayenne.modeler.action.CreateAttributeAction;
import org.apache.cayenne.modeler.action.CreateRelationshipAction;
import org.apache.cayenne.modeler.action.CutAttributeRelationshipAction;
import org.apache.cayenne.modeler.action.ObjEntityCounterpartAction;
import org.apache.cayenne.modeler.action.ObjEntitySyncAction;
import org.apache.cayenne.modeler.action.PasteAction;
import org.apache.cayenne.modeler.action.RemoveAttributeRelationshipAction;
import org.apache.cayenne.modeler.editor.ObjEntityAttributePanel;
import org.apache.cayenne.modeler.editor.ObjEntityRelationshipPanel;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.event.ObjEntityDisplayListener;
import org.apache.cayenne.modeler.pref.ComponentGeometry;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.swing.components.image.FilteredIconFactory;
import org.slf4j.LoggerFactory;

public class ObjEntityAttributeRelationshipTab
extends JPanel
implements ObjEntityDisplayListener,
ObjEntityListener {
    public ObjEntityAttributePanel attributePanel;
    public ObjEntityRelationshipPanel relationshipPanel;
    public JButton resolve = new CayenneAction.CayenneToolbarButton(null, 0);
    private JSplitPane splitPane;
    private ProjectController mediator;
    private CutAttributeRelationshipAction cut;
    private RemoveAttributeRelationshipAction remove;
    private CopyAttributeRelationshipAction copy;
    private JToolBar toolBar;

    public ObjEntityAttributeRelationshipTab(ProjectController mediator) {
        this.mediator = mediator;
        this.init();
        this.initToolBar();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.attributePanel = new ObjEntityAttributePanel(this.mediator, this);
        this.relationshipPanel = new ObjEntityRelationshipPanel(this.mediator, this);
        this.splitPane = new JSplitPane(0, this.attributePanel, this.relationshipPanel);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setResizeWeight(0.5);
        try {
            ComponentGeometry geometry = new ComponentGeometry(this.getClass(), "objEntityAttrRelTab/splitPane/divider");
            geometry.bindIntProperty(this.splitPane, "dividerLocation", -1);
        }
        catch (Exception ex) {
            LoggerFactory.getLogger(this.getClass()).error("Cannot bind divider property", ex);
        }
        this.add(this.splitPane);
    }

    private void initToolBar() {
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        ActionManager actionManager = Application.getInstance().getActionManager();
        this.toolBar.add(actionManager.getAction(CreateAttributeAction.class).buildButton(1));
        this.toolBar.add(actionManager.getAction(CreateRelationshipAction.class).buildButton(3));
        this.toolBar.addSeparator();
        this.toolBar.add(actionManager.getAction(ObjEntitySyncAction.class).buildButton(1));
        this.toolBar.add(actionManager.getAction(ObjEntityCounterpartAction.class).buildButton(3));
        this.toolBar.addSeparator();
        ImageIcon ico = ModelerUtil.buildIcon("icon-edit.png");
        this.resolve.setToolTipText("Edit");
        this.resolve.setIcon(ico);
        this.resolve.setDisabledIcon(FilteredIconFactory.createDisabledIcon(ico));
        this.toolBar.add(this.resolve).setEnabled(false);
        this.cut = actionManager.getAction(CutAttributeRelationshipAction.class);
        this.remove = actionManager.getAction(RemoveAttributeRelationshipAction.class);
        this.copy = actionManager.getAction(CopyAttributeRelationshipAction.class);
        this.toolBar.addSeparator();
        this.toolBar.add(this.remove.buildButton());
        this.toolBar.addSeparator();
        this.toolBar.add(this.cut.buildButton(1));
        this.toolBar.add(this.copy.buildButton(2));
        this.toolBar.add(actionManager.getAction(PasteAction.class).buildButton(3));
        this.add((Component)this.toolBar, "North");
    }

    public void updateActions(Object[] params) {
        ModelerUtil.updateActions(params.length, RemoveAttributeRelationshipAction.class, CutAttributeRelationshipAction.class, CopyAttributeRelationshipAction.class);
        this.resolve.setEnabled(params.length > 0);
    }

    public JButton getResolve() {
        return this.resolve;
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public ObjEntityAttributePanel getAttributePanel() {
        return this.attributePanel;
    }

    public ObjEntityRelationshipPanel getRelationshipPanel() {
        return this.relationshipPanel;
    }

    @Override
    public void objEntityChanged(EntityEvent e) {
        this.attributePanel.objEntityChanged(e);
        this.relationshipPanel.objEntityChanged(e);
    }

    @Override
    public void objEntityAdded(EntityEvent e) {
        this.attributePanel.objEntityAdded(e);
        this.relationshipPanel.objEntityAdded(e);
    }

    @Override
    public void objEntityRemoved(EntityEvent e) {
        this.attributePanel.objEntityRemoved(e);
        this.relationshipPanel.objEntityRemoved(e);
    }

    @Override
    public void currentObjEntityChanged(EntityDisplayEvent e) {
        this.attributePanel.currentObjEntityChanged(e);
        this.relationshipPanel.currentObjEntityChanged(e);
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }
}

