/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.dbimport.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.FilterContainer;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.modeler.editor.dbimport.tree.Node;
import org.apache.cayenne.modeler.editor.dbimport.tree.Status;

abstract class ProcedureNode<T extends Node>
extends Node<T> {
    ProcedureNode(String name, T parent) {
        super(name, parent);
    }

    @Override
    public Status getStatus(ReverseEngineering config) {
        Status parentStatus = ((Node)this.getParent()).getStatus(config);
        if (parentStatus != Status.INCLUDE) {
            return parentStatus;
        }
        ArrayList<IncludeProcedure> includeProcedures = new ArrayList<IncludeProcedure>();
        ArrayList<ExcludeProcedure> excludeProcedures = new ArrayList<ExcludeProcedure>();
        for (FilterContainer container : this.getContainers(config)) {
            if (container == null) continue;
            includeProcedures.addAll(container.getIncludeProcedures());
            excludeProcedures.addAll(container.getExcludeProcedures());
        }
        return this.includesProcedure(includeProcedures, excludeProcedures);
    }

    abstract List<FilterContainer> getContainers(ReverseEngineering var1);

    private Status includesProcedure(Collection<IncludeProcedure> includeProcedures, Collection<ExcludeProcedure> excludeProcedures) {
        if (includeProcedures.isEmpty() && excludeProcedures.isEmpty()) {
            return Status.INCLUDE;
        }
        if (!includeProcedures.isEmpty() && this.includesProcedure(includeProcedures)) {
            return Status.INCLUDE;
        }
        if (!excludeProcedures.isEmpty()) {
            if (this.excludesProcedure(excludeProcedures)) {
                return Status.EXCLUDE_EXPLICIT;
            }
            return includeProcedures.isEmpty() ? Status.INCLUDE : Status.EXCLUDE_IMPLICIT;
        }
        return Status.EXCLUDE_IMPLICIT;
    }

    private boolean includesProcedure(Collection<IncludeProcedure> includeProcedures) {
        for (IncludeProcedure procedure : includeProcedures) {
            if (!this.getName().matches(procedure.getPattern())) continue;
            return true;
        }
        return false;
    }

    private boolean excludesProcedure(Collection<ExcludeProcedure> excludeProcedures) {
        for (ExcludeProcedure procedure : excludeProcedures) {
            if (!this.getName().matches(procedure.getPattern())) continue;
            return true;
        }
        return false;
    }
}

