/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.modeler.action.CreateProcedureParameterAction;
import org.apache.cayenne.modeler.action.RemoveProcedureParameterAction;
import org.apache.cayenne.modeler.event.ProcedureDisplayEvent;
import org.apache.cayenne.modeler.undo.CayenneUndoableEdit;

public class CreateProcedureParameterUndoableEdit
extends CayenneUndoableEdit {
    private DataChannelDescriptor domain;
    private DataMap dataMap;
    private Procedure procedure;
    private ProcedureParameter parameter;

    public CreateProcedureParameterUndoableEdit(DataChannelDescriptor dataDomain, DataMap dataMap, Procedure procedure, ProcedureParameter parameter) {
        this.domain = dataDomain;
        this.dataMap = dataMap;
        this.procedure = procedure;
        this.parameter = parameter;
    }

    @Override
    public void undo() throws CannotUndoException {
        RemoveProcedureParameterAction action = this.actionManager.getAction(RemoveProcedureParameterAction.class);
        if (this.procedure != null) {
            action.removeProcedureParameters(this.procedure, new ProcedureParameter[]{this.parameter});
            this.controller.fireProcedureDisplayEvent(new ProcedureDisplayEvent((Object)this, this.procedure, this.dataMap, this.domain));
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        CreateProcedureParameterAction action = this.actionManager.getAction(CreateProcedureParameterAction.class);
        if (this.procedure != null) {
            action.createProcedureParameter(this.procedure, this.parameter);
        }
    }

    @Override
    public String getPresentationName() {
        return "Create Procedure Parameter";
    }
}

