/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.inflector;

import java.util.Locale;
import org.jvnet.inflector.Pluralizer;

public class Noun {
    public static Pluralizer pluralizer() {
        return Noun.pluralizer(Locale.getDefault());
    }

    public static Pluralizer pluralizer(Locale locale) {
        String className = "org.jvnet.inflector.lang." + locale.getLanguage() + ".NounPluralizer";
        try {
            Class<?> c = Class.forName(className);
            return (Pluralizer)c.newInstance();
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Problem instantiating " + className, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Problem instantiating " + className, e);
        }
    }

    public static String pluralOf(String word) {
        return Noun.pluralOf(word, Noun.pluralizer());
    }

    public static String pluralOf(String word, int number) {
        return Noun.pluralOf(word, number, Noun.pluralizer());
    }

    public static String pluralOf(String word, Locale locale) {
        return Noun.pluralOf(word, Noun.pluralizer(locale));
    }

    public static String pluralOf(String word, int number, Locale locale) {
        return Noun.pluralOf(word, number, Noun.pluralizer(locale));
    }

    public static String pluralOf(String word, Pluralizer pluralizer) {
        return pluralizer == null ? null : pluralizer.pluralize(word);
    }

    public static String pluralOf(String word, int number, Pluralizer pluralizer) {
        return pluralizer == null ? null : pluralizer.pluralize(word, number);
    }
}

