/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dbsync.merge.factory.DefaultMergerTokenFactory;
import org.apache.cayenne.dbsync.merge.token.MergerToken;
import org.apache.cayenne.dbsync.merge.token.db.CreateTableToDb;
import org.apache.cayenne.dbsync.merge.token.db.DropRelationshipToDb;
import org.apache.cayenne.dbsync.merge.token.db.SetAllowNullToDb;
import org.apache.cayenne.dbsync.merge.token.db.SetColumnTypeToDb;
import org.apache.cayenne.dbsync.merge.token.db.SetNotNullToDb;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;

public class OpenBaseMergerTokenFactory
extends DefaultMergerTokenFactory {
    @Override
    public MergerToken createCreateTableToDb(DbEntity entity) {
        return new CreateTableToDb(entity){

            @Override
            public List<String> createSql(DbAdapter adapter) {
                ArrayList<String> sqls = new ArrayList<String>();
                sqls.add(adapter.createTable(this.getEntity()));
                sqls.addAll(adapter.getPkGenerator().createAutoPkStatements(Collections.singletonList(this.getEntity())));
                return sqls;
            }
        };
    }

    @Override
    public MergerToken createDropRelationshipToDb(DbEntity entity, final DbRelationship rel) {
        return new DropRelationshipToDb(entity, rel){

            @Override
            public List<String> createSql(DbAdapter adapter) {
                DbEntity source = this.getEntity();
                DbEntity dest = rel.getTargetEntity();
                DbJoin join = (DbJoin)rel.getJoins().get(0);
                return Collections.singletonList("delete from _SYS_RELATIONSHIP where  source_table = '" + dest.getFullyQualifiedName() + "' and source_column = '" + join.getTargetName() + "' and dest_table = '" + source.getFullyQualifiedName() + "' and dest_column = '" + join.getSourceName() + "'");
            }
        };
    }

    @Override
    public MergerToken createSetColumnTypeToDb(final DbEntity entity, final DbAttribute columnOriginal, final DbAttribute columnNew) {
        return new SetColumnTypeToDb(entity, columnOriginal, columnNew){

            @Override
            public List<String> createSql(DbAdapter adapter) {
                ArrayList<String> sqls = new ArrayList<String>();
                if (columnOriginal.getMaxLength() != columnNew.getMaxLength()) {
                    sqls.add("ALTER TABLE " + entity.getFullyQualifiedName() + " COLUMN " + columnNew.getName() + " SET LENGTH " + columnNew.getMaxLength());
                }
                return sqls;
            }
        };
    }

    @Override
    public MergerToken createSetNotNullToDb(DbEntity entity, DbAttribute column) {
        return new SetNotNullToDb(entity, column){

            @Override
            public List<String> createSql(DbAdapter adapter) {
                return Collections.singletonList("ALTER TABLE " + this.getEntity().getFullyQualifiedName() + " COLUMN " + this.getColumn().getName() + " SET NOT NULL");
            }
        };
    }

    @Override
    public MergerToken createSetAllowNullToDb(DbEntity entity, DbAttribute column) {
        return new SetAllowNullToDb(entity, column){

            @Override
            public List<String> createSql(DbAdapter adapter) {
                return Collections.singletonList("ALTER TABLE " + this.getEntity().getFullyQualifiedName() + " COLUMN " + this.getColumn().getName() + " SET NULL");
            }
        };
    }
}

