/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.crypto.transformer.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import org.apache.cayenne.crypto.transformer.value.BytesConverter;
import org.apache.cayenne.crypto.transformer.value.IntegerConverter;

public class BigDecimalConverter
implements BytesConverter<BigDecimal> {
    public static final BytesConverter<BigDecimal> INSTANCE = new BigDecimalConverter();
    private static final int INTEGER_BYTES = 4;
    private static final int MIN_BYTES = 5;

    static BigDecimal getBigDecimal(byte[] bytes) {
        if (bytes.length < 5) {
            throw new IllegalArgumentException("byte[] is too small for a BigDecimal value: " + bytes.length);
        }
        byte[] scaleBytes = Arrays.copyOfRange(bytes, 0, 4);
        byte[] unscaledBytes = Arrays.copyOfRange(bytes, 4, bytes.length);
        return new BigDecimal(new BigInteger(unscaledBytes), IntegerConverter.getInt(scaleBytes));
    }

    static byte[] getBytes(BigDecimal bigDecimal) {
        byte[] unscaledBytes = bigDecimal.unscaledValue().toByteArray();
        byte[] scaleBytes = IntegerConverter.getBytes(bigDecimal.scale());
        byte[] result = new byte[4 + unscaledBytes.length];
        System.arraycopy(scaleBytes, 0, result, 4 - scaleBytes.length, scaleBytes.length);
        System.arraycopy(unscaledBytes, 0, result, 4, unscaledBytes.length);
        return result;
    }

    @Override
    public BigDecimal fromBytes(byte[] bytes) {
        return BigDecimalConverter.getBigDecimal(bytes);
    }

    @Override
    public byte[] toBytes(BigDecimal value) {
        return BigDecimalConverter.getBytes(value);
    }
}

