/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.crypto.transformer.value;

import java.time.LocalDate;
import java.util.Objects;
import org.apache.cayenne.crypto.transformer.value.BytesConverter;
import org.apache.cayenne.crypto.transformer.value.LongConverter;

public class LocalDateConverter
implements BytesConverter<LocalDate> {
    public static final BytesConverter<LocalDate> INSTANCE = new LocalDateConverter(LongConverter.INSTANCE);
    private BytesConverter<Long> longConverter;

    public LocalDateConverter(BytesConverter<Long> longConverter) {
        this.longConverter = Objects.requireNonNull(longConverter);
    }

    @Override
    public LocalDate fromBytes(byte[] bytes) {
        return LocalDate.ofEpochDay(this.longConverter.fromBytes(bytes));
    }

    @Override
    public byte[] toBytes(LocalDate value) {
        return this.longConverter.toBytes(value.toEpochDay());
    }
}

