/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.apache.commons.compress.archivers.zip.CharsetAccessor;
import org.apache.commons.compress.archivers.zip.NioZipEncoding;
import org.apache.commons.compress.archivers.zip.ZipEncoding;
import org.apache.commons.compress.archivers.zip.ZipEncodingHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ZipEncodingTest {
    private static final String UNENC_STRING = "\u2016";
    private static final String BAD_STRING = "\u2016\u2015\u2016\u2015\u2016\u2015\u2016\u2015\u2016\u2015\u2016";
    private static final String BAD_STRING_ENC = "%U2016%U2015%U2016%U2015%U2016%U2015%U2016%U2015%U2016%U2015%U2016";

    ZipEncodingTest() {
    }

    private static void assertEquals(byte[] expected, ByteBuffer actual) {
        Assertions.assertEquals((int)expected.length, (int)actual.limit());
        for (byte anExpected : expected) {
            byte a = actual.get();
            Assertions.assertEquals((byte)anExpected, (byte)a);
        }
    }

    private void doSimpleEncodingsTest(int n) throws IOException {
        this.doSimpleEncodingTest("Cp" + n, null);
        this.doSimpleEncodingTest("cp" + n, null);
        this.doSimpleEncodingTest("CP" + n, null);
        this.doSimpleEncodingTest("IBM" + n, null);
        this.doSimpleEncodingTest("ibm" + n, null);
    }

    private void doSimpleEncodingTest(String name, byte[] testBytes) throws IOException {
        ZipEncoding enc = ZipEncodingHelper.getZipEncoding((String)name);
        Assertions.assertInstanceOf(NioZipEncoding.class, (Object)enc);
        if (testBytes == null) {
            testBytes = new byte[256];
            for (int i = 0; i < 256; ++i) {
                testBytes[i] = (byte)i;
            }
        }
        String decoded = enc.decode(testBytes);
        Assertions.assertTrue((boolean)enc.canEncode(decoded));
        ByteBuffer encoded = enc.encode(decoded);
        ZipEncodingTest.assertEquals(testBytes, encoded);
        Assertions.assertFalse((boolean)enc.canEncode(UNENC_STRING));
        ZipEncodingTest.assertEquals("%U2016".getBytes(name), enc.encode(UNENC_STRING));
        Assertions.assertFalse((boolean)enc.canEncode(BAD_STRING));
        ZipEncodingTest.assertEquals(BAD_STRING_ENC.getBytes(name), enc.encode(BAD_STRING));
    }

    @Test
    void testEbcidic() throws IOException {
        this.doSimpleEncodingTest("IBM1047", null);
    }

    @Test
    void testGetNonexistentEncoding() {
        ZipEncoding ze = ZipEncodingHelper.getZipEncoding((String)"I-am-a-banana");
        Assertions.assertNotNull((Object)ze);
        if (ze instanceof CharsetAccessor) {
            CharsetAccessor hasCharset = (CharsetAccessor)ze;
            Assertions.assertEquals((Object)Charset.defaultCharset(), (Object)hasCharset.getCharset());
        }
    }

    @Test
    void testNioCp1252Encoding() throws IOException {
        byte[] b = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, -128, -126, -125, -124, -123, -122, -121, -120, -119, -118, -117, -116, -114, -111, -110, -109, -108, -107, -106, -105, -104, -103, -102, -101, -100, -98, -97, -96, -95, -94, -93, -92, -91, -90, -89, -88, -87, -86, -85, -84, -83, -82, -81, -80, -79, -78, -77, -76, -75, -74, -73, -72, -71, -70, -69, -68, -67, -66, -65, -64, -63, -62, -61, -60, -59, -58, -57, -56, -55, -54, -53, -52, -51, -50, -49, -48, -47, -46, -45, -44, -43, -42, -41, -40, -39, -38, -37, -36, -35, -34, -33, -32, -31, -30, -29, -28, -27, -26, -25, -24, -23, -22, -21, -20, -19, -18, -17, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, -6, -5, -4, -3, -2, -1};
        this.doSimpleEncodingTest("Cp1252", b);
    }

    @Test
    void testNothingToMakeCoverallsHappier() {
        ZipEncodingHelper o = new ZipEncodingHelper(){};
        Assertions.assertNotNull((Object)o);
    }

    @Test
    void testSimpleCp437Encoding() throws IOException {
        this.doSimpleEncodingsTest(437);
    }

    @Test
    void testSimpleCp850Encoding() throws IOException {
        this.doSimpleEncodingsTest(850);
    }
}

