/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.function.Predicate;
import org.apache.commons.io.function.Constants;
import org.apache.commons.io.function.Erase;
import org.apache.commons.io.function.IOPredicate;
import org.apache.commons.io.function.TestConstants;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

class IOPredicateTest {
    private static final IOPredicate<Path> IS_HIDDEN = Files::isHidden;
    private static final Path PATH_FIXTURE = Paths.get("src/test/resources/org/apache/commons/io/abitmorethan16k.txt", new String[0]);
    private static final Object THROWING_EQUALS = new Object(){

        public boolean equals(Object obj) {
            throw Erase.rethrow((Throwable)new IOException("Expected"));
        }

        public int hashCode() {
            return super.hashCode();
        }
    };
    private static final Predicate<Object> THROWING_UNCHECKED_PREDICATE = TestConstants.THROWING_IO_PREDICATE.asPredicate();

    IOPredicateTest() {
    }

    private void assertThrowsChecked(Executable executable) {
        Assertions.assertThrows(IOException.class, (Executable)executable);
    }

    private void assertThrowsUnchecked(Executable executable) {
        Assertions.assertThrows(UncheckedIOException.class, (Executable)executable);
    }

    @Test
    void testAndChecked() throws IOException {
        Assertions.assertFalse((boolean)IS_HIDDEN.and(IS_HIDDEN).test((Object)PATH_FIXTURE));
        Assertions.assertTrue((boolean)IOPredicate.alwaysTrue().and(IOPredicate.alwaysTrue()).test((Object)PATH_FIXTURE));
        Assertions.assertFalse((boolean)IOPredicate.alwaysFalse().and(IOPredicate.alwaysTrue()).test((Object)PATH_FIXTURE));
        Assertions.assertFalse((boolean)IOPredicate.alwaysTrue().and(IOPredicate.alwaysFalse()).test((Object)PATH_FIXTURE));
        Assertions.assertFalse((boolean)IOPredicate.alwaysFalse().and(IOPredicate.alwaysFalse()).test((Object)PATH_FIXTURE));
    }

    @Test
    void testAndUnchecked() {
        this.assertThrowsUnchecked(() -> THROWING_UNCHECKED_PREDICATE.and(THROWING_UNCHECKED_PREDICATE).test(PATH_FIXTURE));
    }

    @Test
    void testAsPredicate() throws IOException {
        new ArrayList<Object>().removeIf(THROWING_UNCHECKED_PREDICATE);
        ArrayList<String> list = new ArrayList<String>();
        list.add("A");
        list.add("B");
        list.removeIf(Predicate.isEqual("A"));
        Assertions.assertFalse((boolean)list.contains("A"));
        list.removeIf(IOPredicate.isEqual((Object)"B").asPredicate());
        Assertions.assertFalse((boolean)list.contains("B"));
        Assertions.assertFalse((boolean)IS_HIDDEN.test((Object)PATH_FIXTURE));
    }

    @Test
    void testFalse() throws IOException {
        Assertions.assertFalse((boolean)Constants.IO_PREDICATE_FALSE.test((Object)"A"));
        IOPredicate alwaysFalse = IOPredicate.alwaysFalse();
        Assertions.assertFalse((boolean)alwaysFalse.test((Object)"A"));
        Assertions.assertEquals((Object)IOPredicate.alwaysFalse(), (Object)IOPredicate.alwaysFalse());
        Assertions.assertSame((Object)IOPredicate.alwaysFalse(), (Object)IOPredicate.alwaysFalse());
    }

    @Test
    void testIsEqualChecked() throws IOException {
        this.assertThrowsChecked(() -> IOPredicate.isEqual((Object)THROWING_EQUALS).test((Object)"B"));
        Assertions.assertFalse((boolean)IOPredicate.isEqual(null).test((Object)"A"));
        Assertions.assertTrue((boolean)IOPredicate.isEqual((Object)"B").test((Object)"B"));
        Assertions.assertFalse((boolean)IOPredicate.isEqual((Object)"A").test((Object)"B"));
        Assertions.assertFalse((boolean)IOPredicate.isEqual((Object)"B").test((Object)"A"));
    }

    @Test
    void testIsEqualUnchecked() {
        this.assertThrowsUnchecked(() -> IOPredicate.isEqual((Object)THROWING_EQUALS).asPredicate().test("B"));
        Assertions.assertFalse((boolean)IOPredicate.isEqual(null).asPredicate().test("A"));
        Assertions.assertTrue((boolean)IOPredicate.isEqual((Object)"B").asPredicate().test("B"));
        Assertions.assertFalse((boolean)IOPredicate.isEqual((Object)"A").asPredicate().test("B"));
        Assertions.assertFalse((boolean)IOPredicate.isEqual((Object)"B").asPredicate().test("A"));
    }

    @Test
    void testNegateChecked() throws IOException {
        Assertions.assertTrue((boolean)IS_HIDDEN.negate().test((Object)PATH_FIXTURE));
        Assertions.assertFalse((boolean)IOPredicate.alwaysTrue().negate().test((Object)PATH_FIXTURE));
    }

    @Test
    void testNegateUnchecked() {
        Assertions.assertTrue((boolean)IS_HIDDEN.negate().asPredicate().test(PATH_FIXTURE));
        Assertions.assertTrue((boolean)IS_HIDDEN.asPredicate().negate().test(PATH_FIXTURE));
        this.assertThrowsUnchecked(() -> THROWING_UNCHECKED_PREDICATE.negate().test(PATH_FIXTURE));
    }

    @Test
    void testOrChecked() throws IOException {
        Assertions.assertFalse((boolean)IS_HIDDEN.or(IS_HIDDEN).test((Object)PATH_FIXTURE));
        Assertions.assertTrue((boolean)IOPredicate.alwaysTrue().or(IOPredicate.alwaysFalse()).test((Object)PATH_FIXTURE));
        Assertions.assertTrue((boolean)IOPredicate.alwaysFalse().or(IOPredicate.alwaysTrue()).test((Object)PATH_FIXTURE));
    }

    @Test
    void testOrUnchecked() {
        Assertions.assertFalse((boolean)IS_HIDDEN.asPredicate().or(e -> false).test(PATH_FIXTURE));
        this.assertThrowsUnchecked(() -> THROWING_UNCHECKED_PREDICATE.or(THROWING_UNCHECKED_PREDICATE).test(PATH_FIXTURE));
    }

    @Test
    void testTestChecked() throws IOException {
        this.assertThrowsChecked(() -> TestConstants.THROWING_IO_PREDICATE.test(null));
        Assertions.assertTrue((boolean)Constants.IO_PREDICATE_TRUE.test((Object)"A"));
    }

    @Test
    void testTestUnchecked() {
        this.assertThrowsUnchecked(() -> THROWING_UNCHECKED_PREDICATE.test(null));
        Assertions.assertTrue((boolean)Constants.IO_PREDICATE_TRUE.asPredicate().test("A"));
    }

    @Test
    void testTrue() throws IOException {
        Assertions.assertTrue((boolean)Constants.IO_PREDICATE_TRUE.test((Object)"A"));
        IOPredicate alwaysTrue = IOPredicate.alwaysTrue();
        Assertions.assertTrue((boolean)alwaysTrue.test((Object)"A"));
        Assertions.assertEquals((Object)IOPredicate.alwaysTrue(), (Object)IOPredicate.alwaysTrue());
        Assertions.assertSame((Object)IOPredicate.alwaysTrue(), (Object)IOPredicate.alwaysTrue());
    }
}

