/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.math.BigInteger;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlEvalContext;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlOptions;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class AntishCallTest
extends JexlTestCase {
    public static Object callConstructor(JexlEngine engine, Class<?> clazz, Object ... args) {
        if (clazz == null || clazz.isPrimitive() || clazz.isInterface() || clazz.isMemberClass() || clazz.isAnnotation() || clazz.isArray()) {
            throw new ArithmeticException("not a constructible object");
        }
        JexlEngine jexl = engine;
        if (jexl == null && (jexl = JexlEngine.getThreadEngine()) == null) {
            throw new ArithmeticException("no engine to solve constructor");
        }
        return jexl.newInstance(clazz, args);
    }

    public static Object callConstructor(JexlEngine engine, ClassReference ref, Object ... args) {
        return AntishCallTest.callConstructor(engine, ref.clazz, args);
    }

    public AntishCallTest() {
        super("AntishCallTest");
    }

    void runTestCall(JexlEngine jexl, JexlContext jc) throws Exception {
        JexlScript check1 = jexl.createScript("var x = java.math.BigInteger; x('1234')");
        JexlScript check2 = jexl.createScript("java.math.BigInteger('4321')");
        Object o1 = check1.execute(jc);
        Assertions.assertEquals((Object)new BigInteger("1234"), (Object)o1, (String)"Result is not 1234");
        Object o2 = check2.execute(jc);
        Assertions.assertEquals((Object)new BigInteger("4321"), (Object)o2, (String)"Result is not 4321");
    }

    @Test
    void testAntishArithmetic() throws Exception {
        CallSupportArithmetic ja = new CallSupportArithmetic(true);
        JexlEngine jexl = new JexlBuilder().cache(512).arithmetic((JexlArithmetic)ja).create();
        TreeMap<String, Object> lmap = new TreeMap<String, Object>();
        MapContext jc = new MapContext(lmap);
        lmap.put("java.math.BigInteger", BigInteger.class);
        this.runTestCall(jexl, (JexlContext)jc);
        lmap.put("java.math.BigInteger", new ClassReference(BigInteger.class));
        this.runTestCall(jexl, (JexlContext)jc);
        lmap.remove("java.math.BigInteger");
        Assertions.assertThrows(JexlException.class, () -> this.lambda$testAntishArithmetic$0(jexl, (JexlContext)jc));
    }

    @Test
    void testAntishContextVar() throws Exception {
        TreeMap<String, Object> lmap = new TreeMap<String, Object>();
        CallSupportContext jc = new CallSupportContext(lmap).engine(this.JEXL);
        this.runTestCall(this.JEXL, (JexlContext)jc);
        lmap.put("java.math.BigInteger", new ClassReference(BigInteger.class));
        this.runTestCall(this.JEXL, (JexlContext)jc);
        lmap.remove("java.math.BigInteger");
        this.runTestCall(this.JEXL, (JexlContext)jc);
    }

    @Test
    void testSafeAnt() throws Exception {
        JexlEvalContext ctxt = new JexlEvalContext();
        JexlOptions options = ctxt.getEngineOptions();
        ctxt.set("x.y.z", 42);
        JexlScript script0 = this.JEXL.createScript("x.y.z");
        Object result = script0.execute((JexlContext)ctxt);
        Assertions.assertEquals((Object)42, (Object)result);
        Assertions.assertEquals((Object)42, (Object)ctxt.get("x.y.z"));
        options.setAntish(false);
        Assertions.assertThrows(JexlException.class, () -> script0.execute((JexlContext)ctxt), (String)"antish var shall not be resolved");
        options.setAntish(true);
        JexlScript script = this.JEXL.createScript("x?.y?.z");
        result = script.execute((JexlContext)ctxt);
        Assertions.assertNull((Object)result);
        JexlScript script1 = this.JEXL.createScript("x?.y?.z = 3");
        Assertions.assertThrows(JexlException.class, () -> script1.execute((JexlContext)ctxt), (String)"not antish assign");
        JexlScript script2 = this.JEXL.createScript("x.y?.z");
        Assertions.assertThrows(JexlException.class, () -> script2.execute((JexlContext)ctxt), (String)"x not defined");
        JexlScript script3 = this.JEXL.createScript("x.y?.z = 3");
        Assertions.assertThrows(JexlException.class, () -> script3.execute((JexlContext)ctxt), (String)"x not defined");
        JexlScript script4 = this.JEXL.createScript("x.`'y'`.z = 3");
        Assertions.assertThrows(JexlException.class, () -> script4.execute((JexlContext)ctxt), (String)"x not defined");
    }

    private /* synthetic */ void lambda$testAntishArithmetic$0(JexlEngine jexl, JexlContext jc) throws Throwable {
        this.runTestCall(jexl, jc);
    }

    public static class ClassReference {
        final Class<?> clazz;

        ClassReference(Class<?> c) {
            this.clazz = c;
        }
    }

    public class CallSupportArithmetic
    extends JexlArithmetic {
        public CallSupportArithmetic(boolean strict) {
            super(strict);
        }

        public Object call(Class<?> clazz, Object ... args) {
            return AntishCallTest.callConstructor(null, clazz, args);
        }

        public Object call(ClassReference clazz, Object ... args) {
            return AntishCallTest.callConstructor(null, clazz, args);
        }
    }

    public static class CallSupportContext
    extends MapContext {
        private JexlEngine engine;

        CallSupportContext(Map<String, Object> map) {
            super(map);
        }

        public Object call(Class<?> clazz, Object ... args) {
            return AntishCallTest.callConstructor(this.engine, clazz, args);
        }

        public Object call(ClassReference clazz, Object ... args) {
            return AntishCallTest.callConstructor(this.engine, clazz, args);
        }

        CallSupportContext engine(JexlEngine j) {
            this.engine = j;
            return this;
        }

        public Object get(String str) {
            if (!super.has(str)) {
                try {
                    return CallSupportContext.class.getClassLoader().loadClass(str);
                }
                catch (Exception xany) {
                    return null;
                }
            }
            return super.get(str);
        }

        public boolean has(String str) {
            if (!super.has(str)) {
                try {
                    return CallSupportContext.class.getClassLoader().loadClass(str) != null;
                }
                catch (Exception xany) {
                    return false;
                }
            }
            return true;
        }
    }
}

