/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.ArraySorter;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.LangAssertions;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.compare.ObjectToStringComparator;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.testbed.Ambig;
import org.apache.commons.lang3.reflect.testbed.Annotated;
import org.apache.commons.lang3.reflect.testbed.AnotherParent;
import org.apache.commons.lang3.reflect.testbed.Foo;
import org.apache.commons.lang3.reflect.testbed.PrivatelyShadowedChild;
import org.apache.commons.lang3.reflect.testbed.PublicChild;
import org.apache.commons.lang3.reflect.testbed.PubliclyShadowedChild;
import org.apache.commons.lang3.reflect.testbed.StaticContainer;
import org.apache.commons.lang3.reflect.testbed.StaticContainerChild;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class FieldUtilsTest
extends AbstractLangTest {
    private static final String JACOCO_DATA_FIELD_NAME = "$jacocoData";
    static final Integer I0 = 0;
    static final Integer I1 = 1;
    static final Double D0 = 0.0;
    static final Double D1 = 1.0;
    @Annotated
    private PublicChild publicChild;
    private PubliclyShadowedChild publiclyShadowedChild;
    @Annotated
    private PrivatelyShadowedChild privatelyShadowedChild;
    private final Class<? super PublicChild> parentClass = PublicChild.class.getSuperclass();

    FieldUtilsTest() {
    }

    private void callRemoveFinalModifierCheckForException(Field field, Boolean forceAccess) {
        try {
            FieldUtils.removeFinalModifier((Field)field, (boolean)forceAccess);
        }
        catch (UnsupportedOperationException exception) {
            if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_12)) {
                Assertions.assertInstanceOf(NoSuchFieldException.class, (Object)exception.getCause());
            }
            Assertions.fail((String)"No exception should be thrown for java prior to 12.0");
        }
    }

    @BeforeEach
    public void setUp() {
        StaticContainer.reset();
        this.publicChild = new PublicChild();
        this.publiclyShadowedChild = new PubliclyShadowedChild();
        this.privatelyShadowedChild = new PrivatelyShadowedChild();
    }

    private Field[] sort(Field[] fields) {
        return (Field[])ArraySorter.sort((Object[])fields, (Comparator)ObjectToStringComparator.INSTANCE);
    }

    @Test
    void testAmbig() {
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.getField(Ambig.class, (String)"VALUE"));
    }

    @Test
    void testConstructor() {
        Assertions.assertNotNull((Object)new FieldUtils());
        Constructor<?>[] cons = FieldUtils.class.getDeclaredConstructors();
        Assertions.assertEquals((int)1, (int)cons.length);
        Assertions.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assertions.assertTrue((boolean)Modifier.isPublic(FieldUtils.class.getModifiers()));
        Assertions.assertFalse((boolean)Modifier.isFinal(FieldUtils.class.getModifiers()));
    }

    @Test
    void testGetAllFieldListsNullPointerException() {
        LangAssertions.assertNullPointerException(() -> FieldUtils.getAllFieldsList(null));
    }

    @Test
    void testGetAllFields() {
        Assertions.assertArrayEquals((Object[])new Field[0], (Object[])FieldUtils.getAllFields(Object.class));
        Object[] fieldsNumber = this.sort(Number.class.getDeclaredFields());
        Assertions.assertArrayEquals((Object[])fieldsNumber, (Object[])this.sort(FieldUtils.getAllFields(Number.class)));
        Object[] fieldsInteger = Integer.class.getDeclaredFields();
        Assertions.assertArrayEquals((Object[])this.sort((Field[])ArrayUtils.addAll((Object[])fieldsInteger, (Object[])fieldsNumber)), (Object[])this.sort(FieldUtils.getAllFields(Integer.class)));
        Object[] allFields = FieldUtils.getAllFields(PublicChild.class);
        int expected = 5;
        for (Field field : allFields) {
            if (!field.getName().equals(JACOCO_DATA_FIELD_NAME)) continue;
            ++expected;
        }
        Assertions.assertEquals((int)expected, (int)allFields.length, (String)Arrays.toString(allFields));
    }

    @Test
    void testGetAllFieldsList() {
        Assertions.assertEquals((int)0, (int)FieldUtils.getAllFieldsList(Object.class).size());
        List<Field> fieldsNumber = Arrays.asList(Number.class.getDeclaredFields());
        Assertions.assertEquals(fieldsNumber, (Object)FieldUtils.getAllFieldsList(Number.class));
        List<Field> fieldsInteger = Arrays.asList(Integer.class.getDeclaredFields());
        ArrayList<Field> allFieldsInteger = new ArrayList<Field>(fieldsInteger);
        allFieldsInteger.addAll(fieldsNumber);
        Assertions.assertEquals(new HashSet<Field>(allFieldsInteger), new HashSet(FieldUtils.getAllFieldsList(Integer.class)));
        List allFields = FieldUtils.getAllFieldsList(PublicChild.class);
        int expected = 5;
        for (Field field : allFields) {
            if (!field.getName().equals(JACOCO_DATA_FIELD_NAME)) continue;
            ++expected;
        }
        Assertions.assertEquals((int)expected, (int)allFields.size(), (String)allFields.toString());
    }

    @Test
    void testGetAllFieldsNullPointerException() {
        LangAssertions.assertNullPointerException(() -> FieldUtils.getAllFields(null));
    }

    @Test
    void testGetDeclaredField() {
        Assertions.assertNull((Object)FieldUtils.getDeclaredField(PublicChild.class, (String)"VALUE"));
        Assertions.assertNull((Object)FieldUtils.getDeclaredField(PublicChild.class, (String)"s"));
        Assertions.assertNull((Object)FieldUtils.getDeclaredField(PublicChild.class, (String)"b"));
        Assertions.assertNull((Object)FieldUtils.getDeclaredField(PublicChild.class, (String)"i"));
        Assertions.assertNull((Object)FieldUtils.getDeclaredField(PublicChild.class, (String)"d"));
        Assertions.assertNull((Object)FieldUtils.getDeclaredField(PubliclyShadowedChild.class, (String)"VALUE"));
        Assertions.assertEquals(PubliclyShadowedChild.class, FieldUtils.getDeclaredField(PubliclyShadowedChild.class, (String)"s").getDeclaringClass());
        Assertions.assertEquals(PubliclyShadowedChild.class, FieldUtils.getDeclaredField(PubliclyShadowedChild.class, (String)"b").getDeclaringClass());
        Assertions.assertEquals(PubliclyShadowedChild.class, FieldUtils.getDeclaredField(PubliclyShadowedChild.class, (String)"i").getDeclaringClass());
        Assertions.assertEquals(PubliclyShadowedChild.class, FieldUtils.getDeclaredField(PubliclyShadowedChild.class, (String)"d").getDeclaringClass());
        Assertions.assertNull((Object)FieldUtils.getDeclaredField(PrivatelyShadowedChild.class, (String)"VALUE"));
        Assertions.assertNull((Object)FieldUtils.getDeclaredField(PrivatelyShadowedChild.class, (String)"s"));
        Assertions.assertNull((Object)FieldUtils.getDeclaredField(PrivatelyShadowedChild.class, (String)"b"));
        Assertions.assertNull((Object)FieldUtils.getDeclaredField(PrivatelyShadowedChild.class, (String)"i"));
        Assertions.assertNull((Object)FieldUtils.getDeclaredField(PrivatelyShadowedChild.class, (String)"d"));
    }

    @Test
    void testGetDeclaredFieldAccessIllegalArgumentException1() {
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.getDeclaredField(PublicChild.class, null));
    }

    @Test
    void testGetDeclaredFieldAccessIllegalArgumentException2() {
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.getDeclaredField(PublicChild.class, (String)""));
    }

    @Test
    void testGetDeclaredFieldAccessIllegalArgumentException3() {
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.getDeclaredField(PublicChild.class, (String)" "));
    }

    @Test
    void testGetDeclaredFieldAccessNullPointerException() {
        LangAssertions.assertNullPointerException(() -> FieldUtils.getDeclaredField(null, (String)"none"));
    }

    @Test
    void testGetDeclaredFieldForceAccess() {
        Assertions.assertEquals(PublicChild.class, FieldUtils.getDeclaredField(PublicChild.class, (String)"VALUE", (boolean)true).getDeclaringClass());
        Assertions.assertNull((Object)FieldUtils.getDeclaredField(PublicChild.class, (String)"s", (boolean)true));
        Assertions.assertNull((Object)FieldUtils.getDeclaredField(PublicChild.class, (String)"b", (boolean)true));
        Assertions.assertNull((Object)FieldUtils.getDeclaredField(PublicChild.class, (String)"i", (boolean)true));
        Assertions.assertNull((Object)FieldUtils.getDeclaredField(PublicChild.class, (String)"d", (boolean)true));
        Assertions.assertNull((Object)FieldUtils.getDeclaredField(PubliclyShadowedChild.class, (String)"VALUE", (boolean)true));
        Assertions.assertEquals(PubliclyShadowedChild.class, FieldUtils.getDeclaredField(PubliclyShadowedChild.class, (String)"s", (boolean)true).getDeclaringClass());
        Assertions.assertEquals(PubliclyShadowedChild.class, FieldUtils.getDeclaredField(PubliclyShadowedChild.class, (String)"b", (boolean)true).getDeclaringClass());
        Assertions.assertEquals(PubliclyShadowedChild.class, FieldUtils.getDeclaredField(PubliclyShadowedChild.class, (String)"i", (boolean)true).getDeclaringClass());
        Assertions.assertEquals(PubliclyShadowedChild.class, FieldUtils.getDeclaredField(PubliclyShadowedChild.class, (String)"d", (boolean)true).getDeclaringClass());
        Assertions.assertNull((Object)FieldUtils.getDeclaredField(PrivatelyShadowedChild.class, (String)"VALUE", (boolean)true));
        Assertions.assertEquals(PrivatelyShadowedChild.class, FieldUtils.getDeclaredField(PrivatelyShadowedChild.class, (String)"s", (boolean)true).getDeclaringClass());
        Assertions.assertEquals(PrivatelyShadowedChild.class, FieldUtils.getDeclaredField(PrivatelyShadowedChild.class, (String)"b", (boolean)true).getDeclaringClass());
        Assertions.assertEquals(PrivatelyShadowedChild.class, FieldUtils.getDeclaredField(PrivatelyShadowedChild.class, (String)"i", (boolean)true).getDeclaringClass());
        Assertions.assertEquals(PrivatelyShadowedChild.class, FieldUtils.getDeclaredField(PrivatelyShadowedChild.class, (String)"d", (boolean)true).getDeclaringClass());
    }

    @Test
    void testGetDeclaredFieldForceAccessIllegalArgumentException1() {
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.getDeclaredField(PublicChild.class, null, (boolean)true));
    }

    @Test
    void testGetDeclaredFieldForceAccessIllegalArgumentException2() {
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.getDeclaredField(PublicChild.class, (String)"", (boolean)true));
    }

    @Test
    void testGetDeclaredFieldForceAccessIllegalArgumentException3() {
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.getDeclaredField(PublicChild.class, (String)" ", (boolean)true));
    }

    @Test
    void testGetDeclaredFieldForceAccessNullPointerException() {
        LangAssertions.assertNullPointerException(() -> FieldUtils.getDeclaredField(null, (String)"none", (boolean)true));
    }

    @Test
    void testGetField() {
        Assertions.assertEquals(Foo.class, FieldUtils.getField(PublicChild.class, (String)"VALUE").getDeclaringClass());
        Assertions.assertEquals(this.parentClass, FieldUtils.getField(PublicChild.class, (String)"s").getDeclaringClass());
        Assertions.assertNull((Object)FieldUtils.getField(PublicChild.class, (String)"b"));
        Assertions.assertNull((Object)FieldUtils.getField(PublicChild.class, (String)"i"));
        Assertions.assertNull((Object)FieldUtils.getField(PublicChild.class, (String)"d"));
        Assertions.assertEquals(Foo.class, FieldUtils.getField(PubliclyShadowedChild.class, (String)"VALUE").getDeclaringClass());
        Assertions.assertEquals(PubliclyShadowedChild.class, FieldUtils.getField(PubliclyShadowedChild.class, (String)"s").getDeclaringClass());
        Assertions.assertEquals(PubliclyShadowedChild.class, FieldUtils.getField(PubliclyShadowedChild.class, (String)"b").getDeclaringClass());
        Assertions.assertEquals(PubliclyShadowedChild.class, FieldUtils.getField(PubliclyShadowedChild.class, (String)"i").getDeclaringClass());
        Assertions.assertEquals(PubliclyShadowedChild.class, FieldUtils.getField(PubliclyShadowedChild.class, (String)"d").getDeclaringClass());
        Assertions.assertEquals(Foo.class, FieldUtils.getField(PrivatelyShadowedChild.class, (String)"VALUE").getDeclaringClass());
        Assertions.assertEquals(this.parentClass, FieldUtils.getField(PrivatelyShadowedChild.class, (String)"s").getDeclaringClass());
        Assertions.assertNull((Object)FieldUtils.getField(PrivatelyShadowedChild.class, (String)"b"));
        Assertions.assertNull((Object)FieldUtils.getField(PrivatelyShadowedChild.class, (String)"i"));
        Assertions.assertNull((Object)FieldUtils.getField(PrivatelyShadowedChild.class, (String)"d"));
    }

    @Test
    void testGetFieldForceAccess() {
        Assertions.assertEquals(PublicChild.class, FieldUtils.getField(PublicChild.class, (String)"VALUE", (boolean)true).getDeclaringClass());
        Assertions.assertEquals(this.parentClass, FieldUtils.getField(PublicChild.class, (String)"s", (boolean)true).getDeclaringClass());
        Assertions.assertEquals(this.parentClass, FieldUtils.getField(PublicChild.class, (String)"b", (boolean)true).getDeclaringClass());
        Assertions.assertEquals(this.parentClass, FieldUtils.getField(PublicChild.class, (String)"i", (boolean)true).getDeclaringClass());
        Assertions.assertEquals(this.parentClass, FieldUtils.getField(PublicChild.class, (String)"d", (boolean)true).getDeclaringClass());
        Assertions.assertEquals(Foo.class, FieldUtils.getField(PubliclyShadowedChild.class, (String)"VALUE", (boolean)true).getDeclaringClass());
        Assertions.assertEquals(PubliclyShadowedChild.class, FieldUtils.getField(PubliclyShadowedChild.class, (String)"s", (boolean)true).getDeclaringClass());
        Assertions.assertEquals(PubliclyShadowedChild.class, FieldUtils.getField(PubliclyShadowedChild.class, (String)"b", (boolean)true).getDeclaringClass());
        Assertions.assertEquals(PubliclyShadowedChild.class, FieldUtils.getField(PubliclyShadowedChild.class, (String)"i", (boolean)true).getDeclaringClass());
        Assertions.assertEquals(PubliclyShadowedChild.class, FieldUtils.getField(PubliclyShadowedChild.class, (String)"d", (boolean)true).getDeclaringClass());
        Assertions.assertEquals(Foo.class, FieldUtils.getField(PrivatelyShadowedChild.class, (String)"VALUE", (boolean)true).getDeclaringClass());
        Assertions.assertEquals(PrivatelyShadowedChild.class, FieldUtils.getField(PrivatelyShadowedChild.class, (String)"s", (boolean)true).getDeclaringClass());
        Assertions.assertEquals(PrivatelyShadowedChild.class, FieldUtils.getField(PrivatelyShadowedChild.class, (String)"b", (boolean)true).getDeclaringClass());
        Assertions.assertEquals(PrivatelyShadowedChild.class, FieldUtils.getField(PrivatelyShadowedChild.class, (String)"i", (boolean)true).getDeclaringClass());
        Assertions.assertEquals(PrivatelyShadowedChild.class, FieldUtils.getField(PrivatelyShadowedChild.class, (String)"d", (boolean)true).getDeclaringClass());
    }

    @Test
    void testGetFieldForceAccessIllegalArgumentException1() {
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.getField(PublicChild.class, null, (boolean)true));
    }

    @Test
    void testGetFieldForceAccessIllegalArgumentException2() {
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.getField(PublicChild.class, (String)"", (boolean)true));
    }

    @Test
    void testGetFieldForceAccessIllegalArgumentException3() {
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.getField(PublicChild.class, (String)" ", (boolean)true));
    }

    @Test
    void testGetFieldForceAccessNullPointerException() {
        LangAssertions.assertNullPointerException(() -> FieldUtils.getField(null, (String)"none", (boolean)true));
    }

    @Test
    void testGetFieldIllegalArgumentException1() {
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.getField(PublicChild.class, null));
    }

    @Test
    void testGetFieldIllegalArgumentException2() {
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.getField(PublicChild.class, (String)""));
    }

    @Test
    void testGetFieldIllegalArgumentException3() {
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.getField(PublicChild.class, (String)" "));
    }

    @Test
    void testGetFieldNullPointerException() {
        LangAssertions.assertNullPointerException(() -> FieldUtils.getField(null, (String)"none"));
    }

    @Test
    void testGetFieldsListWithAnnotation() throws NoSuchFieldException {
        Assertions.assertEquals((int)0, (int)FieldUtils.getFieldsListWithAnnotation(Object.class, Annotated.class).size());
        List<Field> annotatedFields = Arrays.asList(FieldUtilsTest.class.getDeclaredField("publicChild"), FieldUtilsTest.class.getDeclaredField("privatelyShadowedChild"));
        List fieldUtilsTestAnnotatedFields = FieldUtils.getFieldsListWithAnnotation(FieldUtilsTest.class, Annotated.class);
        Assertions.assertEquals((int)annotatedFields.size(), (int)fieldUtilsTestAnnotatedFields.size());
        Assertions.assertTrue((boolean)fieldUtilsTestAnnotatedFields.contains(annotatedFields.get(0)));
        Assertions.assertTrue((boolean)fieldUtilsTestAnnotatedFields.contains(annotatedFields.get(1)));
    }

    @Test
    void testGetFieldsListWithAnnotationNullPointerException() {
        LangAssertions.assertNullPointerException(() -> FieldUtils.getFieldsListWithAnnotation(FieldUtilsTest.class, null));
    }

    @Test
    void testGetFieldsListWithAnnotationNullPointerException2() {
        LangAssertions.assertNullPointerException(() -> FieldUtils.getFieldsListWithAnnotation(null, Annotated.class));
    }

    @Test
    void testGetFieldsListWithAnnotationNullPointerException3() {
        LangAssertions.assertNullPointerException(() -> FieldUtils.getFieldsListWithAnnotation(null, null));
    }

    @Test
    void testGetFieldsWithAnnotation() throws NoSuchFieldException {
        Assertions.assertArrayEquals((Object[])new Field[0], (Object[])FieldUtils.getFieldsWithAnnotation(Object.class, Annotated.class));
        Object[] annotatedFields = this.sort(new Field[]{FieldUtilsTest.class.getDeclaredField("publicChild"), FieldUtilsTest.class.getDeclaredField("privatelyShadowedChild")});
        Assertions.assertArrayEquals((Object[])annotatedFields, (Object[])this.sort(FieldUtils.getFieldsWithAnnotation(FieldUtilsTest.class, Annotated.class)));
    }

    @Test
    void testGetFieldsWithAnnotationNullPointerException1() {
        LangAssertions.assertNullPointerException(() -> FieldUtils.getFieldsWithAnnotation(FieldUtilsTest.class, null));
    }

    @Test
    void testGetFieldsWithAnnotationNullPointerException2() {
        LangAssertions.assertNullPointerException(() -> FieldUtils.getFieldsWithAnnotation(null, Annotated.class));
    }

    @Test
    void testGetFieldsWithAnnotationNullPointerException3() {
        LangAssertions.assertNullPointerException(() -> FieldUtils.getFieldsWithAnnotation(null, null));
    }

    @Test
    void testReadDeclaredNamedField() throws Exception {
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readDeclaredField((Object)this.publicChild, null), "a null field name should cause an IllegalArgumentException");
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readDeclaredField((Object)this.publicChild, (String)""), "an empty field name should cause an IllegalArgumentException");
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readDeclaredField((Object)this.publicChild, (String)" "), "a blank field name should cause an IllegalArgumentException");
        LangAssertions.assertNullPointerException(() -> FieldUtils.readDeclaredField(null, (String)"none"), "a null target should cause an NullPointerException");
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readDeclaredField((Object)this.publicChild, (String)"s"));
        Assertions.assertEquals((Object)"ss", (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"s"));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readDeclaredField((Object)this.privatelyShadowedChild, (String)"s"));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readDeclaredField((Object)this.publicChild, (String)"b"));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"b"));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readDeclaredField((Object)this.privatelyShadowedChild, (String)"b"));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readDeclaredField((Object)this.publicChild, (String)"i"));
        Assertions.assertEquals((Object)I1, (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"i"));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readDeclaredField((Object)this.privatelyShadowedChild, (String)"i"));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readDeclaredField((Object)this.publicChild, (String)"d"));
        Assertions.assertEquals((Object)D1, (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"d"));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readDeclaredField((Object)this.privatelyShadowedChild, (String)"d"));
    }

    @Test
    void testReadDeclaredNamedFieldForceAccess() throws Exception {
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readDeclaredField((Object)this.publicChild, null, (boolean)true), "a null field name should cause an IllegalArgumentException");
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readDeclaredField((Object)this.publicChild, (String)"", (boolean)true), "an empty field name should cause an IllegalArgumentException");
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readDeclaredField((Object)this.publicChild, (String)" ", (boolean)true), "a blank field name should cause an IllegalArgumentException");
        LangAssertions.assertNullPointerException(() -> FieldUtils.readDeclaredField(null, (String)"none", (boolean)true), "a null target should cause an NullPointerException");
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readDeclaredField((Object)this.publicChild, (String)"s", (boolean)true));
        Assertions.assertEquals((Object)"ss", (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"s", (boolean)true));
        Assertions.assertEquals((Object)"ss", (Object)FieldUtils.readDeclaredField((Object)this.privatelyShadowedChild, (String)"s", (boolean)true));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readDeclaredField((Object)this.publicChild, (String)"b", (boolean)true));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"b", (boolean)true));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)FieldUtils.readDeclaredField((Object)this.privatelyShadowedChild, (String)"b", (boolean)true));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readDeclaredField((Object)this.publicChild, (String)"i", (boolean)true));
        Assertions.assertEquals((Object)I1, (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"i", (boolean)true));
        Assertions.assertEquals((Object)I1, (Object)FieldUtils.readDeclaredField((Object)this.privatelyShadowedChild, (String)"i", (boolean)true));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readDeclaredField((Object)this.publicChild, (String)"d", (boolean)true));
        Assertions.assertEquals((Object)D1, (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"d", (boolean)true));
        Assertions.assertEquals((Object)D1, (Object)FieldUtils.readDeclaredField((Object)this.privatelyShadowedChild, (String)"d", (boolean)true));
    }

    @Test
    void testReadDeclaredNamedStaticField() throws Exception {
        LangAssertions.assertNullPointerException(() -> FieldUtils.readDeclaredStaticField(AnotherParent.class, (String)"doesNotExist"));
        Assertions.assertEquals((Object)"foo", (Object)FieldUtils.readDeclaredStaticField(Foo.class, (String)"VALUE"));
        LangAssertions.assertNullPointerException(() -> FieldUtils.readDeclaredField(null, (String)"VALUE"));
        LangAssertions.assertNullPointerException(() -> FieldUtils.readDeclaredStaticField(PublicChild.class, (String)"VALUE"));
        LangAssertions.assertNullPointerException(() -> FieldUtils.readDeclaredStaticField(PubliclyShadowedChild.class, (String)"VALUE"));
        LangAssertions.assertNullPointerException(() -> FieldUtils.readDeclaredStaticField(PrivatelyShadowedChild.class, (String)"VALUE"));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readDeclaredStaticField(PublicChild.class, null));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readDeclaredStaticField(PublicChild.class, (String)""));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readDeclaredStaticField(PublicChild.class, (String)" "));
    }

    @Test
    void testReadDeclaredNamedStaticFieldForceAccess() throws Exception {
        Assertions.assertEquals((Object)"foo", (Object)FieldUtils.readDeclaredStaticField(Foo.class, (String)"VALUE", (boolean)true));
        Assertions.assertEquals((Object)"child", (Object)FieldUtils.readDeclaredStaticField(PublicChild.class, (String)"VALUE", (boolean)true));
        LangAssertions.assertNullPointerException(() -> FieldUtils.readDeclaredStaticField(PubliclyShadowedChild.class, (String)"VALUE", (boolean)true));
        LangAssertions.assertNullPointerException(() -> FieldUtils.readDeclaredStaticField(PrivatelyShadowedChild.class, (String)"VALUE", (boolean)true));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readDeclaredStaticField(PrivatelyShadowedChild.class, null, (boolean)true));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readDeclaredStaticField(PrivatelyShadowedChild.class, (String)"", (boolean)true));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readDeclaredStaticField(PrivatelyShadowedChild.class, (String)" ", (boolean)true));
    }

    @Test
    void testReadField() throws Exception {
        Field parentS = FieldUtils.getDeclaredField(this.parentClass, (String)"s");
        Assertions.assertEquals((Object)"s", (Object)FieldUtils.readField((Field)parentS, (Object)this.publicChild));
        Assertions.assertEquals((Object)"s", (Object)FieldUtils.readField((Field)parentS, (Object)this.publiclyShadowedChild));
        Assertions.assertEquals((Object)"s", (Object)FieldUtils.readField((Field)parentS, (Object)this.privatelyShadowedChild));
        Field parentB = FieldUtils.getDeclaredField(this.parentClass, (String)"b", (boolean)true);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.readField((Field)parentB, (Object)this.publicChild));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.readField((Field)parentB, (Object)this.publiclyShadowedChild));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.readField((Field)parentB, (Object)this.privatelyShadowedChild));
        Field parentI = FieldUtils.getDeclaredField(this.parentClass, (String)"i", (boolean)true);
        Assertions.assertEquals((Object)I0, (Object)FieldUtils.readField((Field)parentI, (Object)this.publicChild));
        Assertions.assertEquals((Object)I0, (Object)FieldUtils.readField((Field)parentI, (Object)this.publiclyShadowedChild));
        Assertions.assertEquals((Object)I0, (Object)FieldUtils.readField((Field)parentI, (Object)this.privatelyShadowedChild));
        Field parentD = FieldUtils.getDeclaredField(this.parentClass, (String)"d", (boolean)true);
        Assertions.assertEquals((Object)D0, (Object)FieldUtils.readField((Field)parentD, (Object)this.publicChild));
        Assertions.assertEquals((Object)D0, (Object)FieldUtils.readField((Field)parentD, (Object)this.publiclyShadowedChild));
        Assertions.assertEquals((Object)D0, (Object)FieldUtils.readField((Field)parentD, (Object)this.privatelyShadowedChild));
        LangAssertions.assertNullPointerException(() -> FieldUtils.readField(null, (Object)this.publicChild), "a null field should cause an NullPointerException");
    }

    @Test
    void testReadFieldForceAccess() throws Exception {
        Field parentS = FieldUtils.getDeclaredField(this.parentClass, (String)"s");
        parentS.setAccessible(false);
        Assertions.assertEquals((Object)"s", (Object)FieldUtils.readField((Field)parentS, (Object)this.publicChild, (boolean)true));
        Assertions.assertEquals((Object)"s", (Object)FieldUtils.readField((Field)parentS, (Object)this.publiclyShadowedChild, (boolean)true));
        Assertions.assertEquals((Object)"s", (Object)FieldUtils.readField((Field)parentS, (Object)this.privatelyShadowedChild, (boolean)true));
        Field parentB = FieldUtils.getDeclaredField(this.parentClass, (String)"b", (boolean)true);
        parentB.setAccessible(false);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.readField((Field)parentB, (Object)this.publicChild, (boolean)true));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.readField((Field)parentB, (Object)this.publiclyShadowedChild, (boolean)true));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.readField((Field)parentB, (Object)this.privatelyShadowedChild, (boolean)true));
        Field parentI = FieldUtils.getDeclaredField(this.parentClass, (String)"i", (boolean)true);
        parentI.setAccessible(false);
        Assertions.assertEquals((Object)I0, (Object)FieldUtils.readField((Field)parentI, (Object)this.publicChild, (boolean)true));
        Assertions.assertEquals((Object)I0, (Object)FieldUtils.readField((Field)parentI, (Object)this.publiclyShadowedChild, (boolean)true));
        Assertions.assertEquals((Object)I0, (Object)FieldUtils.readField((Field)parentI, (Object)this.privatelyShadowedChild, (boolean)true));
        Field parentD = FieldUtils.getDeclaredField(this.parentClass, (String)"d", (boolean)true);
        parentD.setAccessible(false);
        Assertions.assertEquals((Object)D0, (Object)FieldUtils.readField((Field)parentD, (Object)this.publicChild, (boolean)true));
        Assertions.assertEquals((Object)D0, (Object)FieldUtils.readField((Field)parentD, (Object)this.publiclyShadowedChild, (boolean)true));
        Assertions.assertEquals((Object)D0, (Object)FieldUtils.readField((Field)parentD, (Object)this.privatelyShadowedChild, (boolean)true));
        LangAssertions.assertNullPointerException(() -> FieldUtils.readField(null, (Object)this.publicChild, (boolean)true), "a null field should cause an NullPointerException");
    }

    @Test
    void testReadNamedField() throws Exception {
        Assertions.assertEquals((Object)"s", (Object)FieldUtils.readField((Object)this.publicChild, (String)"s"));
        Assertions.assertEquals((Object)"ss", (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"s"));
        Assertions.assertEquals((Object)"s", (Object)FieldUtils.readField((Object)this.privatelyShadowedChild, (String)"s"));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readField((Object)this.publicChild, null), "a null field name should cause an IllegalArgumentException");
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readField((Object)this.publicChild, (String)""), "an empty field name should cause an IllegalArgumentException");
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readField((Object)this.publicChild, (String)" "), "a blank field name should cause an IllegalArgumentException");
        LangAssertions.assertNullPointerException(() -> FieldUtils.readField(null, (String)"none"), "a null target should cause an NullPointerException");
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readField((Object)this.publicChild, (String)"b"));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"b"));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readField((Object)this.privatelyShadowedChild, (String)"b"));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readField((Object)this.publicChild, (String)"i"));
        Assertions.assertEquals((Object)I1, (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"i"));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readField((Object)this.privatelyShadowedChild, (String)"i"));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readField((Object)this.publicChild, (String)"d"));
        Assertions.assertEquals((Object)D1, (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"d"));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readField((Object)this.privatelyShadowedChild, (String)"d"));
    }

    @Test
    void testReadNamedFieldForceAccess() throws Exception {
        Assertions.assertEquals((Object)"s", (Object)FieldUtils.readField((Object)this.publicChild, (String)"s", (boolean)true));
        Assertions.assertEquals((Object)"ss", (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"s", (boolean)true));
        Assertions.assertEquals((Object)"ss", (Object)FieldUtils.readField((Object)this.privatelyShadowedChild, (String)"s", (boolean)true));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.readField((Object)this.publicChild, (String)"b", (boolean)true));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"b", (boolean)true));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)FieldUtils.readField((Object)this.privatelyShadowedChild, (String)"b", (boolean)true));
        Assertions.assertEquals((Object)I0, (Object)FieldUtils.readField((Object)this.publicChild, (String)"i", (boolean)true));
        Assertions.assertEquals((Object)I1, (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"i", (boolean)true));
        Assertions.assertEquals((Object)I1, (Object)FieldUtils.readField((Object)this.privatelyShadowedChild, (String)"i", (boolean)true));
        Assertions.assertEquals((Object)D0, (Object)FieldUtils.readField((Object)this.publicChild, (String)"d", (boolean)true));
        Assertions.assertEquals((Object)D1, (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"d", (boolean)true));
        Assertions.assertEquals((Object)D1, (Object)FieldUtils.readField((Object)this.privatelyShadowedChild, (String)"d", (boolean)true));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readField((Object)this.publicChild, null, (boolean)true), "a null field name should cause an IllegalArgumentException");
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readField((Object)this.publicChild, (String)"", (boolean)true), "an empty field name should cause an IllegalArgumentException");
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readField((Object)this.publicChild, (String)" ", (boolean)true), "a blank field name should cause an IllegalArgumentException");
        LangAssertions.assertNullPointerException(() -> FieldUtils.readField(null, (String)"none", (boolean)true), "a null target should cause an NullPointerException");
    }

    @Test
    void testReadNamedStaticField() throws Exception {
        Assertions.assertEquals((Object)"foo", (Object)FieldUtils.readStaticField(Foo.class, (String)"VALUE"));
        Assertions.assertEquals((Object)"foo", (Object)FieldUtils.readStaticField(PubliclyShadowedChild.class, (String)"VALUE"));
        Assertions.assertEquals((Object)"foo", (Object)FieldUtils.readStaticField(PrivatelyShadowedChild.class, (String)"VALUE"));
        Assertions.assertEquals((Object)"foo", (Object)FieldUtils.readStaticField(PublicChild.class, (String)"VALUE"));
        LangAssertions.assertNullPointerException(() -> FieldUtils.readStaticField(null, (String)"none"), "null class should cause an NullPointerException");
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readStaticField(Foo.class, null), "null field name should cause an IllegalArgumentException");
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readStaticField(Foo.class, (String)""), "empty field name should cause an IllegalArgumentException");
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readStaticField(Foo.class, (String)" "), "blank field name should cause an IllegalArgumentException");
        LangAssertions.assertNullPointerException(() -> FieldUtils.readStaticField(Foo.class, (String)"does_not_exist"), "a field that doesn't exist should cause an NullPointerException");
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readStaticField(PublicChild.class, (String)"s"), "non-static field should cause an IllegalArgumentException");
    }

    @Test
    void testReadNamedStaticFieldForceAccess() throws Exception {
        Assertions.assertEquals((Object)"foo", (Object)FieldUtils.readStaticField(Foo.class, (String)"VALUE", (boolean)true));
        Assertions.assertEquals((Object)"foo", (Object)FieldUtils.readStaticField(PubliclyShadowedChild.class, (String)"VALUE", (boolean)true));
        Assertions.assertEquals((Object)"foo", (Object)FieldUtils.readStaticField(PrivatelyShadowedChild.class, (String)"VALUE", (boolean)true));
        Assertions.assertEquals((Object)"child", (Object)FieldUtils.readStaticField(PublicChild.class, (String)"VALUE", (boolean)true));
        LangAssertions.assertNullPointerException(() -> FieldUtils.readStaticField(null, (String)"none", (boolean)true), "null class should cause an NullPointerException");
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readStaticField(Foo.class, null, (boolean)true), "null field name should cause an IllegalArgumentException");
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readStaticField(Foo.class, (String)"", (boolean)true), "empty field name should cause an IllegalArgumentException");
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readStaticField(Foo.class, (String)" ", (boolean)true), "blank field name should cause an IllegalArgumentException");
        LangAssertions.assertNullPointerException(() -> FieldUtils.readStaticField(Foo.class, (String)"does_not_exist", (boolean)true), "a field that doesn't exist should cause an NullPointerException");
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readStaticField(PublicChild.class, (String)"s", (boolean)false), "non-static field should cause an IllegalArgumentException");
    }

    @Test
    void testReadStaticField() throws Exception {
        Assertions.assertEquals((Object)"foo", (Object)FieldUtils.readStaticField((Field)FieldUtils.getField(Foo.class, (String)"VALUE")));
    }

    @Test
    void testReadStaticFieldForceAccess() throws Exception {
        Assertions.assertEquals((Object)"foo", (Object)FieldUtils.readStaticField((Field)FieldUtils.getField(Foo.class, (String)"VALUE")));
        Assertions.assertEquals((Object)"foo", (Object)FieldUtils.readStaticField((Field)FieldUtils.getField(PublicChild.class, (String)"VALUE")));
    }

    @Test
    void testReadStaticFieldForceAccessIllegalArgumentException() {
        Field nonStaticField = FieldUtils.getField(PublicChild.class, (String)"s", (boolean)true);
        Assumptions.assumeTrue((nonStaticField != null ? 1 : 0) != 0);
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readStaticField((Field)nonStaticField, (boolean)true));
    }

    @Test
    void testReadStaticFieldForceAccessNullPointerException() {
        LangAssertions.assertNullPointerException(() -> FieldUtils.readStaticField(null, (boolean)true));
    }

    @Test
    void testReadStaticFieldIllegalArgumentException() throws Exception {
        Assertions.assertEquals((Object)"foo", (Object)FieldUtils.readStaticField((Field)FieldUtils.getField(Foo.class, (String)"VALUE")));
        Field nonStaticField = FieldUtils.getField(PublicChild.class, (String)"s");
        Assumptions.assumeTrue((nonStaticField != null ? 1 : 0) != 0);
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.readStaticField((Field)nonStaticField));
    }

    @Test
    void testReadStaticFieldNullPointerException() {
        LangAssertions.assertNullPointerException(() -> FieldUtils.readStaticField(null));
    }

    @Test
    void testRemoveFinalModifier() throws Exception {
        Field field = StaticContainer.class.getDeclaredField("IMMUTABLE_PRIVATE_2");
        Assertions.assertFalse((boolean)field.isAccessible());
        Assertions.assertTrue((boolean)Modifier.isFinal(field.getModifiers()));
        this.callRemoveFinalModifierCheckForException(field, true);
        if (SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_11)) {
            Assertions.assertFalse((boolean)Modifier.isFinal(field.getModifiers()));
            Assertions.assertFalse((boolean)field.isAccessible());
        }
    }

    @Test
    void testRemoveFinalModifierAccessNotNeeded() throws Exception {
        Field field = StaticContainer.class.getDeclaredField("IMMUTABLE_PACKAGE");
        Assertions.assertFalse((boolean)field.isAccessible());
        Assertions.assertTrue((boolean)Modifier.isFinal(field.getModifiers()));
        this.callRemoveFinalModifierCheckForException(field, false);
        if (SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_11)) {
            Assertions.assertTrue((boolean)Modifier.isFinal(field.getModifiers()));
            Assertions.assertFalse((boolean)field.isAccessible());
        }
    }

    @Test
    void testRemoveFinalModifierNullPointerException() {
        LangAssertions.assertNullPointerException(() -> FieldUtils.removeFinalModifier(null));
    }

    @Test
    void testRemoveFinalModifierWithAccess() throws Exception {
        Field field = StaticContainer.class.getDeclaredField("IMMUTABLE_PRIVATE_2");
        Assertions.assertFalse((boolean)field.isAccessible());
        Assertions.assertTrue((boolean)Modifier.isFinal(field.getModifiers()));
        this.callRemoveFinalModifierCheckForException(field, true);
        if (SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_11)) {
            Assertions.assertFalse((boolean)Modifier.isFinal(field.getModifiers()));
            Assertions.assertFalse((boolean)field.isAccessible());
        }
    }

    @Test
    void testRemoveFinalModifierWithAccessNullPointerException() {
        LangAssertions.assertNullPointerException(() -> FieldUtils.removeFinalModifier(null, (boolean)true));
    }

    @Test
    void testRemoveFinalModifierWithoutAccess() throws Exception {
        Field field = StaticContainer.class.getDeclaredField("IMMUTABLE_PRIVATE_2");
        Assertions.assertFalse((boolean)field.isAccessible());
        Assertions.assertTrue((boolean)Modifier.isFinal(field.getModifiers()));
        this.callRemoveFinalModifierCheckForException(field, false);
        if (SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_11)) {
            Assertions.assertTrue((boolean)Modifier.isFinal(field.getModifiers()));
            Assertions.assertFalse((boolean)field.isAccessible());
        }
    }

    @Test
    void testWriteDeclaredNamedField() throws Exception {
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.writeDeclaredField((Object)this.publicChild, (String)"s", (Object)"S"));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.writeDeclaredField((Object)this.publicChild, (String)"b", (Object)Boolean.TRUE));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.writeDeclaredField((Object)this.publicChild, (String)"i", (Object)1));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.writeDeclaredField((Object)this.publicChild, (String)"d", (Object)1.0));
        FieldUtils.writeDeclaredField((Object)this.publiclyShadowedChild, (String)"s", (Object)"S");
        Assertions.assertEquals((Object)"S", (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"s"));
        FieldUtils.writeDeclaredField((Object)this.publiclyShadowedChild, (String)"b", (Object)Boolean.FALSE);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"b"));
        FieldUtils.writeDeclaredField((Object)this.publiclyShadowedChild, (String)"i", (Object)0);
        Assertions.assertEquals((Object)0, (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"i"));
        FieldUtils.writeDeclaredField((Object)this.publiclyShadowedChild, (String)"d", (Object)0.0);
        Assertions.assertEquals((Object)0.0, (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"d"));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.writeDeclaredField((Object)this.privatelyShadowedChild, (String)"s", (Object)"S"));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.writeDeclaredField((Object)this.privatelyShadowedChild, (String)"b", (Object)Boolean.TRUE));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.writeDeclaredField((Object)this.privatelyShadowedChild, (String)"i", (Object)1));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.writeDeclaredField((Object)this.privatelyShadowedChild, (String)"d", (Object)1.0));
        LangAssertions.assertNullPointerException(() -> FieldUtils.writeDeclaredField(null, (String)"s", (Object)"S"));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.writeDeclaredField((Object)this.publicChild, (String)"null", (Object)"S"));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.writeDeclaredField((Object)this.publicChild, (String)"", (Object)"S"));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.writeDeclaredField((Object)this.publicChild, (String)" ", (Object)"S"));
    }

    @Test
    void testWriteDeclaredNamedFieldForceAccess() throws Exception {
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.writeDeclaredField((Object)this.publicChild, (String)"s", (Object)"S", (boolean)true));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.writeDeclaredField((Object)this.publicChild, (String)"b", (Object)Boolean.TRUE, (boolean)true));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.writeDeclaredField((Object)this.publicChild, (String)"i", (Object)1, (boolean)true));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.writeDeclaredField((Object)this.publicChild, (String)"d", (Object)1.0, (boolean)true));
        FieldUtils.writeDeclaredField((Object)this.publiclyShadowedChild, (String)"s", (Object)"S", (boolean)true);
        Assertions.assertEquals((Object)"S", (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"s", (boolean)true));
        FieldUtils.writeDeclaredField((Object)this.publiclyShadowedChild, (String)"b", (Object)Boolean.FALSE, (boolean)true);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"b", (boolean)true));
        FieldUtils.writeDeclaredField((Object)this.publiclyShadowedChild, (String)"i", (Object)0, (boolean)true);
        Assertions.assertEquals((Object)0, (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"i", (boolean)true));
        FieldUtils.writeDeclaredField((Object)this.publiclyShadowedChild, (String)"d", (Object)0.0, (boolean)true);
        Assertions.assertEquals((Object)0.0, (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"d", (boolean)true));
        FieldUtils.writeDeclaredField((Object)this.privatelyShadowedChild, (String)"s", (Object)"S", (boolean)true);
        Assertions.assertEquals((Object)"S", (Object)FieldUtils.readDeclaredField((Object)this.privatelyShadowedChild, (String)"s", (boolean)true));
        FieldUtils.writeDeclaredField((Object)this.privatelyShadowedChild, (String)"b", (Object)Boolean.FALSE, (boolean)true);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.readDeclaredField((Object)this.privatelyShadowedChild, (String)"b", (boolean)true));
        FieldUtils.writeDeclaredField((Object)this.privatelyShadowedChild, (String)"i", (Object)0, (boolean)true);
        Assertions.assertEquals((Object)0, (Object)FieldUtils.readDeclaredField((Object)this.privatelyShadowedChild, (String)"i", (boolean)true));
        FieldUtils.writeDeclaredField((Object)this.privatelyShadowedChild, (String)"d", (Object)0.0, (boolean)true);
        Assertions.assertEquals((Object)0.0, (Object)FieldUtils.readDeclaredField((Object)this.privatelyShadowedChild, (String)"d", (boolean)true));
        LangAssertions.assertNullPointerException(() -> FieldUtils.writeDeclaredField(null, (String)"s", (Object)"S", (boolean)true));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.writeDeclaredField((Object)this.publicChild, (String)"null", (Object)"S", (boolean)true));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.writeDeclaredField((Object)this.publicChild, (String)"", (Object)"S", (boolean)true));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.writeDeclaredField((Object)this.publicChild, (String)" ", (Object)"S", (boolean)true));
    }

    @Test
    void testWriteDeclaredNamedStaticField() throws Exception {
        FieldUtils.writeStaticField(StaticContainer.class, (String)"mutablePublic", (Object)"new");
        Assertions.assertEquals((Object)"new", (Object)StaticContainer.mutablePublic);
        LangAssertions.assertNullPointerException(() -> FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"mutableProtected", (Object)"new"));
        LangAssertions.assertNullPointerException(() -> FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"mutablePackage", (Object)"new"));
        LangAssertions.assertNullPointerException(() -> FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"mutablePrivate", (Object)"new"));
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"IMMUTABLE_PUBLIC", (Object)"new"));
        LangAssertions.assertNullPointerException(() -> FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"IMMUTABLE_PROTECTED", (Object)"new"));
        LangAssertions.assertNullPointerException(() -> FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"IMMUTABLE_PACKAGE", (Object)"new"));
        LangAssertions.assertNullPointerException(() -> FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"IMMUTABLE_PRIVATE", (Object)"new"));
        LangAssertions.assertNullPointerException(() -> FieldUtils.writeDeclaredStaticField(null, (String)"mutablePublic", (Object)"new"));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.writeDeclaredStaticField(StaticContainer.class, null, (Object)"new"));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"", (Object)"new"));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)" ", (Object)"new"));
    }

    @Test
    void testWriteDeclaredNamedStaticFieldForceAccess() throws Exception {
        FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"mutablePublic", (Object)"new", (boolean)true);
        Assertions.assertEquals((Object)"new", (Object)StaticContainer.mutablePublic);
        FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"mutableProtected", (Object)"new", (boolean)true);
        Assertions.assertEquals((Object)"new", (Object)StaticContainer.getMutableProtected());
        FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"mutablePackage", (Object)"new", (boolean)true);
        Assertions.assertEquals((Object)"new", (Object)StaticContainer.getMutablePackage());
        FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"mutablePrivate", (Object)"new", (boolean)true);
        Assertions.assertEquals((Object)"new", (Object)StaticContainer.getMutablePrivate());
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"IMMUTABLE_PUBLIC", (Object)"new", (boolean)true));
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"IMMUTABLE_PROTECTED", (Object)"new", (boolean)true));
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"IMMUTABLE_PACKAGE", (Object)"new", (boolean)true));
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"IMMUTABLE_PRIVATE", (Object)"new", (boolean)true));
        LangAssertions.assertNullPointerException(() -> FieldUtils.writeDeclaredStaticField(null, (String)"mutablePublic", (Object)"new", (boolean)true));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.writeDeclaredStaticField(StaticContainer.class, null, (Object)"new", (boolean)true));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"", (Object)"new", (boolean)true));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)" ", (Object)"new", (boolean)true));
    }

    @Test
    void testWriteField() throws Exception {
        Field field = this.parentClass.getDeclaredField("s");
        FieldUtils.writeField((Field)field, (Object)this.publicChild, (Object)"S");
        Assertions.assertEquals((Object)"S", (Object)field.get(this.publicChild));
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeField((Field)this.parentClass.getDeclaredField("b"), (Object)this.publicChild, (Object)Boolean.TRUE));
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeField((Field)this.parentClass.getDeclaredField("i"), (Object)this.publicChild, (Object)Integer.MAX_VALUE));
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeField((Field)this.parentClass.getDeclaredField("d"), (Object)this.publicChild, (Object)Double.MAX_VALUE));
        LangAssertions.assertNullPointerException(() -> FieldUtils.writeField(null, (Object)this.publicChild, (Object)"S"));
    }

    @Test
    void testWriteFieldForceAccess() throws Exception {
        Field field = this.parentClass.getDeclaredField("s");
        FieldUtils.writeField((Field)field, (Object)this.publicChild, (Object)"S", (boolean)true);
        Assertions.assertEquals((Object)"S", (Object)field.get(this.publicChild));
        field = this.parentClass.getDeclaredField("b");
        FieldUtils.writeField((Field)field, (Object)this.publicChild, (Object)Boolean.TRUE, (boolean)true);
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)field.get(this.publicChild));
        field = this.parentClass.getDeclaredField("i");
        FieldUtils.writeField((Field)field, (Object)this.publicChild, (Object)Integer.MAX_VALUE, (boolean)true);
        Assertions.assertEquals((Object)Integer.MAX_VALUE, (Object)field.get(this.publicChild));
        field = this.parentClass.getDeclaredField("d");
        FieldUtils.writeField((Field)field, (Object)this.publicChild, (Object)Double.MAX_VALUE, (boolean)true);
        Assertions.assertEquals((Object)Double.MAX_VALUE, (Object)field.get(this.publicChild));
        LangAssertions.assertNullPointerException(() -> FieldUtils.writeField(null, (Object)this.publicChild, (Object)"S", (boolean)true));
    }

    @Test
    void testWriteNamedField() throws Exception {
        FieldUtils.writeField((Object)this.publicChild, (String)"s", (Object)"S");
        Assertions.assertEquals((Object)"S", (Object)FieldUtils.readField((Object)this.publicChild, (String)"s"));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.writeField((Object)this.publicChild, (String)"b", (Object)Boolean.TRUE));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.writeField((Object)this.publicChild, (String)"i", (Object)1));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.writeField((Object)this.publicChild, (String)"d", (Object)1.0));
        FieldUtils.writeField((Object)this.publiclyShadowedChild, (String)"s", (Object)"S");
        Assertions.assertEquals((Object)"S", (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"s"));
        FieldUtils.writeField((Object)this.publiclyShadowedChild, (String)"b", (Object)Boolean.FALSE);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"b"));
        FieldUtils.writeField((Object)this.publiclyShadowedChild, (String)"i", (Object)0);
        Assertions.assertEquals((Object)0, (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"i"));
        FieldUtils.writeField((Object)this.publiclyShadowedChild, (String)"d", (Object)0.0);
        Assertions.assertEquals((Object)0.0, (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"d"));
        FieldUtils.writeField((Object)this.privatelyShadowedChild, (String)"s", (Object)"S");
        Assertions.assertEquals((Object)"S", (Object)FieldUtils.readField((Object)this.privatelyShadowedChild, (String)"s"));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.writeField((Object)this.privatelyShadowedChild, (String)"b", (Object)Boolean.TRUE));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.writeField((Object)this.privatelyShadowedChild, (String)"i", (Object)1));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.writeField((Object)this.privatelyShadowedChild, (String)"d", (Object)1.0));
        LangAssertions.assertNullPointerException(() -> FieldUtils.writeField(null, (String)"s", (Object)"s"));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.writeField((Object)this.publicChild, null, (Object)"s"));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.writeField((Object)this.publicChild, (String)"", (Object)"s"));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.writeField((Object)this.publicChild, (String)" ", (Object)"s"));
    }

    @Test
    void testWriteNamedFieldForceAccess() throws Exception {
        FieldUtils.writeField((Object)this.publicChild, (String)"s", (Object)"S", (boolean)true);
        Assertions.assertEquals((Object)"S", (Object)FieldUtils.readField((Object)this.publicChild, (String)"s", (boolean)true));
        FieldUtils.writeField((Object)this.publicChild, (String)"b", (Object)Boolean.TRUE, (boolean)true);
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)FieldUtils.readField((Object)this.publicChild, (String)"b", (boolean)true));
        FieldUtils.writeField((Object)this.publicChild, (String)"i", (Object)1, (boolean)true);
        Assertions.assertEquals((Object)1, (Object)FieldUtils.readField((Object)this.publicChild, (String)"i", (boolean)true));
        FieldUtils.writeField((Object)this.publicChild, (String)"d", (Object)1.0, (boolean)true);
        Assertions.assertEquals((Object)1.0, (Object)FieldUtils.readField((Object)this.publicChild, (String)"d", (boolean)true));
        FieldUtils.writeField((Object)this.publiclyShadowedChild, (String)"s", (Object)"S", (boolean)true);
        Assertions.assertEquals((Object)"S", (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"s", (boolean)true));
        FieldUtils.writeField((Object)this.publiclyShadowedChild, (String)"b", (Object)Boolean.FALSE, (boolean)true);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"b", (boolean)true));
        FieldUtils.writeField((Object)this.publiclyShadowedChild, (String)"i", (Object)0, (boolean)true);
        Assertions.assertEquals((Object)0, (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"i", (boolean)true));
        FieldUtils.writeField((Object)this.publiclyShadowedChild, (String)"d", (Object)0.0, (boolean)true);
        Assertions.assertEquals((Object)0.0, (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"d", (boolean)true));
        FieldUtils.writeField((Object)this.privatelyShadowedChild, (String)"s", (Object)"S", (boolean)true);
        Assertions.assertEquals((Object)"S", (Object)FieldUtils.readField((Object)this.privatelyShadowedChild, (String)"s", (boolean)true));
        FieldUtils.writeField((Object)this.privatelyShadowedChild, (String)"b", (Object)Boolean.FALSE, (boolean)true);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.readField((Object)this.privatelyShadowedChild, (String)"b", (boolean)true));
        FieldUtils.writeField((Object)this.privatelyShadowedChild, (String)"i", (Object)0, (boolean)true);
        Assertions.assertEquals((Object)0, (Object)FieldUtils.readField((Object)this.privatelyShadowedChild, (String)"i", (boolean)true));
        FieldUtils.writeField((Object)this.privatelyShadowedChild, (String)"d", (Object)0.0, (boolean)true);
        Assertions.assertEquals((Object)0.0, (Object)FieldUtils.readField((Object)this.privatelyShadowedChild, (String)"d", (boolean)true));
        LangAssertions.assertNullPointerException(() -> FieldUtils.writeField(null, (String)"s", (Object)"s", (boolean)true));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.writeField((Object)this.publicChild, null, (Object)"s", (boolean)true));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.writeField((Object)this.publicChild, (String)"", (Object)"s", (boolean)true));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.writeField((Object)this.publicChild, (String)" ", (Object)"s", (boolean)true));
    }

    @Test
    void testWriteNamedStaticField() throws Exception {
        FieldUtils.writeStaticField(StaticContainerChild.class, (String)"mutablePublic", (Object)"new");
        Assertions.assertEquals((Object)"new", (Object)StaticContainer.mutablePublic);
        LangAssertions.assertNullPointerException(() -> FieldUtils.writeStaticField(StaticContainerChild.class, (String)"mutableProtected", (Object)"new"));
        LangAssertions.assertNullPointerException(() -> FieldUtils.writeStaticField(StaticContainerChild.class, (String)"mutablePackage", (Object)"new"));
        LangAssertions.assertNullPointerException(() -> FieldUtils.writeStaticField(StaticContainerChild.class, (String)"mutablePrivate", (Object)"new"));
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeStaticField(StaticContainerChild.class, (String)"IMMUTABLE_PUBLIC", (Object)"new"));
        LangAssertions.assertNullPointerException(() -> FieldUtils.writeStaticField(StaticContainerChild.class, (String)"IMMUTABLE_PROTECTED", (Object)"new"));
        LangAssertions.assertNullPointerException(() -> FieldUtils.writeStaticField(StaticContainerChild.class, (String)"IMMUTABLE_PACKAGE", (Object)"new"));
        LangAssertions.assertNullPointerException(() -> FieldUtils.writeStaticField(StaticContainerChild.class, (String)"IMMUTABLE_PRIVATE", (Object)"new"));
        LangAssertions.assertNullPointerException(() -> FieldUtils.writeStaticField(null, (String)"IMMUTABLE_PRIVATE", (Object)"new"));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.writeStaticField(StaticContainerChild.class, null, (Object)"new"));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.writeStaticField(StaticContainerChild.class, (String)"", (Object)"new"));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.writeStaticField(StaticContainerChild.class, (String)" ", (Object)"new"));
    }

    @Test
    void testWriteNamedStaticFieldForceAccess() throws Exception {
        FieldUtils.writeStaticField(StaticContainerChild.class, (String)"mutablePublic", (Object)"new", (boolean)true);
        Assertions.assertEquals((Object)"new", (Object)StaticContainer.mutablePublic);
        FieldUtils.writeStaticField(StaticContainerChild.class, (String)"mutableProtected", (Object)"new", (boolean)true);
        Assertions.assertEquals((Object)"new", (Object)StaticContainer.getMutableProtected());
        FieldUtils.writeStaticField(StaticContainerChild.class, (String)"mutablePackage", (Object)"new", (boolean)true);
        Assertions.assertEquals((Object)"new", (Object)StaticContainer.getMutablePackage());
        FieldUtils.writeStaticField(StaticContainerChild.class, (String)"mutablePrivate", (Object)"new", (boolean)true);
        Assertions.assertEquals((Object)"new", (Object)StaticContainer.getMutablePrivate());
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeStaticField(StaticContainerChild.class, (String)"IMMUTABLE_PUBLIC", (Object)"new", (boolean)true));
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeStaticField(StaticContainerChild.class, (String)"IMMUTABLE_PROTECTED", (Object)"new", (boolean)true));
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeStaticField(StaticContainerChild.class, (String)"IMMUTABLE_PACKAGE", (Object)"new", (boolean)true));
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeStaticField(StaticContainerChild.class, (String)"IMMUTABLE_PRIVATE", (Object)"new", (boolean)true));
        LangAssertions.assertNullPointerException(() -> FieldUtils.writeStaticField(null, (String)"IMMUTABLE_PRIVATE", (Object)"new", (boolean)true));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.writeStaticField(StaticContainerChild.class, null, (Object)"new", (boolean)true));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.writeStaticField(StaticContainerChild.class, (String)"", (Object)"new", (boolean)true));
        LangAssertions.assertIllegalArgumentException(() -> FieldUtils.writeStaticField(StaticContainerChild.class, (String)" ", (Object)"new", (boolean)true));
    }

    @Test
    void testWriteStaticField() throws Exception {
        Field field = StaticContainer.class.getDeclaredField("mutablePublic");
        FieldUtils.writeStaticField((Field)field, (Object)"new");
        Assertions.assertEquals((Object)"new", (Object)StaticContainer.mutablePublic);
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeStaticField((Field)StaticContainer.class.getDeclaredField("mutableProtected"), (Object)"new"));
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeStaticField((Field)StaticContainer.class.getDeclaredField("mutablePackage"), (Object)"new"));
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeStaticField((Field)StaticContainer.class.getDeclaredField("mutablePrivate"), (Object)"new"));
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeStaticField((Field)StaticContainer.class.getDeclaredField("IMMUTABLE_PUBLIC"), (Object)"new"));
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeStaticField((Field)StaticContainer.class.getDeclaredField("IMMUTABLE_PROTECTED"), (Object)"new"));
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeStaticField((Field)StaticContainer.class.getDeclaredField("IMMUTABLE_PACKAGE"), (Object)"new"));
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeStaticField((Field)StaticContainer.class.getDeclaredField("IMMUTABLE_PRIVATE"), (Object)"new"));
        LangAssertions.assertNullPointerException(() -> FieldUtils.writeStaticField(null, (Object)"new"));
    }

    @Test
    void testWriteStaticFieldForceAccess() throws Exception {
        Field field = StaticContainer.class.getDeclaredField("mutablePublic");
        FieldUtils.writeStaticField((Field)field, (Object)"new", (boolean)true);
        Assertions.assertEquals((Object)"new", (Object)StaticContainer.mutablePublic);
        field = StaticContainer.class.getDeclaredField("mutableProtected");
        FieldUtils.writeStaticField((Field)field, (Object)"new", (boolean)true);
        Assertions.assertEquals((Object)"new", (Object)StaticContainer.getMutableProtected());
        field = StaticContainer.class.getDeclaredField("mutablePackage");
        FieldUtils.writeStaticField((Field)field, (Object)"new", (boolean)true);
        Assertions.assertEquals((Object)"new", (Object)StaticContainer.getMutablePackage());
        field = StaticContainer.class.getDeclaredField("mutablePrivate");
        FieldUtils.writeStaticField((Field)field, (Object)"new", (boolean)true);
        Assertions.assertEquals((Object)"new", (Object)StaticContainer.getMutablePrivate());
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeStaticField((Field)StaticContainer.class.getDeclaredField("IMMUTABLE_PUBLIC"), (Object)"new", (boolean)true));
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeStaticField((Field)StaticContainer.class.getDeclaredField("IMMUTABLE_PROTECTED"), (Object)"new", (boolean)true));
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeStaticField((Field)StaticContainer.class.getDeclaredField("IMMUTABLE_PACKAGE"), (Object)"new", (boolean)true));
        Assertions.assertThrows(IllegalAccessException.class, () -> FieldUtils.writeStaticField((Field)StaticContainer.class.getDeclaredField("IMMUTABLE_PRIVATE"), (Object)"new", (boolean)true));
        LangAssertions.assertNullPointerException(() -> FieldUtils.writeStaticField(null, (Object)"new", (boolean)true));
    }
}

