/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.SystemProperties;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.text.StrBuilder;
import org.apache.commons.text.StrLookup;
import org.apache.commons.text.StrMatcher;
import org.apache.commons.text.StrMatcherTest;
import org.apache.commons.text.StrSubstitutor;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@Deprecated
class StrSubstitutorTest {
    private Map<String, String> values;

    StrSubstitutorTest() {
    }

    private void doTestNoReplace(String replaceTemplate) {
        StrSubstitutor sub = new StrSubstitutor(this.values);
        if (replaceTemplate == null) {
            Assertions.assertNull((Object)sub.replace((String)null));
            Assertions.assertNull((Object)sub.replace((String)null, 0, 100));
            Assertions.assertNull((Object)sub.replace((char[])null));
            Assertions.assertNull((Object)sub.replace((char[])null, 0, 100));
            Assertions.assertNull((Object)sub.replace((StringBuffer)null));
            Assertions.assertNull((Object)sub.replace((StringBuffer)null, 0, 100));
            Assertions.assertNull((Object)sub.replace((StrBuilder)null));
            Assertions.assertNull((Object)sub.replace((StrBuilder)null, 0, 100));
            Assertions.assertNull((Object)sub.replace(null));
            Assertions.assertFalse((boolean)sub.replaceIn((StringBuffer)null));
            Assertions.assertFalse((boolean)sub.replaceIn((StringBuffer)null, 0, 100));
            Assertions.assertFalse((boolean)sub.replaceIn((StrBuilder)null));
            Assertions.assertFalse((boolean)sub.replaceIn((StrBuilder)null, 0, 100));
        } else {
            Assertions.assertEquals((Object)replaceTemplate, (Object)sub.replace(replaceTemplate));
            StrBuilder bld = new StrBuilder(replaceTemplate);
            Assertions.assertFalse((boolean)sub.replaceIn(bld));
            Assertions.assertEquals((Object)replaceTemplate, (Object)bld.toString());
        }
    }

    private void doTestReplace(String expectedResult, String replaceTemplate, boolean substring) {
        StrSubstitutor sub = new StrSubstitutor(this.values);
        this.doTestReplace(sub, expectedResult, replaceTemplate, substring);
    }

    private void doTestReplace(StrSubstitutor sub, String expectedResult, String replaceTemplate, boolean substring) {
        String expectedShortResult = expectedResult.substring(1, expectedResult.length() - 1);
        Assertions.assertEquals((Object)expectedResult, (Object)sub.replace(replaceTemplate));
        if (substring) {
            Assertions.assertEquals((Object)expectedShortResult, (Object)sub.replace(replaceTemplate, 1, replaceTemplate.length() - 2));
        }
        char[] chars = replaceTemplate.toCharArray();
        Assertions.assertEquals((Object)expectedResult, (Object)sub.replace(chars));
        if (substring) {
            Assertions.assertEquals((Object)expectedShortResult, (Object)sub.replace(chars, 1, chars.length - 2));
        }
        StringBuffer buf = new StringBuffer(replaceTemplate);
        Assertions.assertEquals((Object)expectedResult, (Object)sub.replace(buf));
        if (substring) {
            Assertions.assertEquals((Object)expectedShortResult, (Object)sub.replace(buf, 1, buf.length() - 2));
        }
        StringBuilder builder = new StringBuilder(replaceTemplate);
        Assertions.assertEquals((Object)expectedResult, (Object)sub.replace((CharSequence)builder));
        if (substring) {
            Assertions.assertEquals((Object)expectedShortResult, (Object)sub.replace((CharSequence)builder, 1, builder.length() - 2));
        }
        StrBuilder bld = new StrBuilder(replaceTemplate);
        Assertions.assertEquals((Object)expectedResult, (Object)sub.replace(bld));
        if (substring) {
            Assertions.assertEquals((Object)expectedShortResult, (Object)sub.replace(bld, 1, bld.length() - 2));
        }
        MutableObject obj = new MutableObject((Object)replaceTemplate);
        Assertions.assertEquals((Object)expectedResult, (Object)sub.replace((Object)obj));
        buf = new StringBuffer(replaceTemplate);
        Assertions.assertTrue((boolean)sub.replaceIn(buf));
        Assertions.assertEquals((Object)expectedResult, (Object)buf.toString());
        if (substring) {
            buf = new StringBuffer(replaceTemplate);
            Assertions.assertTrue((boolean)sub.replaceIn(buf, 1, buf.length() - 2));
            Assertions.assertEquals((Object)expectedResult, (Object)buf.toString());
        }
        builder = new StringBuilder(replaceTemplate);
        Assertions.assertTrue((boolean)sub.replaceIn(builder));
        Assertions.assertEquals((Object)expectedResult, (Object)builder.toString());
        if (substring) {
            builder = new StringBuilder(replaceTemplate);
            Assertions.assertTrue((boolean)sub.replaceIn(builder, 1, builder.length() - 2));
            Assertions.assertEquals((Object)expectedResult, (Object)builder.toString());
        }
        bld = new StrBuilder(replaceTemplate);
        Assertions.assertTrue((boolean)sub.replaceIn(bld));
        Assertions.assertEquals((Object)expectedResult, (Object)bld.toString());
        if (substring) {
            bld = new StrBuilder(replaceTemplate);
            Assertions.assertTrue((boolean)sub.replaceIn(bld, 1, bld.length() - 2));
            Assertions.assertEquals((Object)expectedResult, (Object)bld.toString());
        }
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.values = new HashMap<String, String>();
        this.values.put("animal", "quick brown fox");
        this.values.put("target", "lazy dog");
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.values = null;
    }

    @Test
    void testConstructorMapFull() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "commons");
        StrSubstitutor sub = new StrSubstitutor(map, "<", ">", '!');
        Assertions.assertEquals((Object)"Hi < commons", (Object)sub.replace("Hi !< <name>"));
        sub = new StrSubstitutor(map, "<", ">", '!', "||");
        Assertions.assertEquals((Object)"Hi < commons", (Object)sub.replace("Hi !< <name2||commons>"));
    }

    @Test
    void testConstructorMapPrefixSuffix() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "commons");
        StrSubstitutor sub = new StrSubstitutor(map, "<", ">");
        Assertions.assertEquals((Object)"Hi < commons", (Object)sub.replace("Hi $< <name>"));
    }

    @Test
    void testConstructorNoArgs() {
        StrSubstitutor sub = new StrSubstitutor();
        Assertions.assertEquals((Object)"Hi ${name}", (Object)sub.replace("Hi ${name}"));
    }

    @Test
    void testCreatesStrSubstitutorTakingStrLookupAndCallsReplaceTakingTwoAndThreeInts() {
        HashMap map = new HashMap();
        StrLookup strLookupMapStrLookup = StrLookup.mapLookup(map);
        StrSubstitutor strSubstitutor = new StrSubstitutor(strLookupMapStrLookup);
        Assertions.assertNull((Object)strSubstitutor.replace((CharSequence)null, 0, 0));
        Assertions.assertEquals((char)'$', (char)strSubstitutor.getEscapeChar());
    }

    @Test
    void testCyclicReplacement() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("animal", "${critter}");
        map.put("target", "${pet}");
        map.put("pet", "${petCharacteristic} dog");
        map.put("petCharacteristic", "lazy");
        map.put("critter", "${critterSpeed} ${critterColor} ${critterType}");
        map.put("critterSpeed", "quick");
        map.put("critterColor", "brown");
        map.put("critterType", "${animal}");
        StrSubstitutor sub = new StrSubstitutor(map);
        Assertions.assertThrows(IllegalStateException.class, () -> sub.replace("The ${animal} jumps over the ${target}."));
        map.put("critterType", "${animal:-fox}");
        Assertions.assertThrows(IllegalStateException.class, () -> new StrSubstitutor(map).replace("The ${animal} jumps over the ${target}."));
    }

    @Test
    void testDefaultValueDelimiters() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("animal", "fox");
        map.put("target", "dog");
        StrSubstitutor sub = new StrSubstitutor(map, "${", "}", '$');
        Assertions.assertEquals((Object)"The fox jumps over the lazy dog. 1234567890.", (Object)sub.replace("The ${animal} jumps over the lazy ${target}. ${undefined.number:-1234567890}."));
        sub = new StrSubstitutor(map, "${", "}", '$', "?:");
        Assertions.assertEquals((Object)"The fox jumps over the lazy dog. 1234567890.", (Object)sub.replace("The ${animal} jumps over the lazy ${target}. ${undefined.number?:1234567890}."));
        sub = new StrSubstitutor(map, "${", "}", '$', "||");
        Assertions.assertEquals((Object)"The fox jumps over the lazy dog. 1234567890.", (Object)sub.replace("The ${animal} jumps over the lazy ${target}. ${undefined.number||1234567890}."));
        sub = new StrSubstitutor(map, "${", "}", '$', "!");
        Assertions.assertEquals((Object)"The fox jumps over the lazy dog. 1234567890.", (Object)sub.replace("The ${animal} jumps over the lazy ${target}. ${undefined.number!1234567890}."));
        sub = new StrSubstitutor(map, "${", "}", '$', "");
        sub.setValueDelimiterMatcher(null);
        Assertions.assertEquals((Object)"The fox jumps over the lazy dog. ${undefined.number!1234567890}.", (Object)sub.replace("The ${animal} jumps over the lazy ${target}. ${undefined.number!1234567890}."));
        sub = new StrSubstitutor(map, "${", "}", '$');
        sub.setValueDelimiterMatcher(null);
        Assertions.assertEquals((Object)"The fox jumps over the lazy dog. ${undefined.number!1234567890}.", (Object)sub.replace("The ${animal} jumps over the lazy ${target}. ${undefined.number!1234567890}."));
    }

    @Test
    void testDisableSubstitutionInValues() {
        StrSubstitutor sub = new StrSubstitutor(this.values);
        sub.setDisableSubstitutionInValues(true);
        this.values.put("animal", "${critter}");
        this.values.put("target", "${pet}");
        this.values.put("pet", "${petCharacteristic} dog");
        this.values.put("petCharacteristic", "lazy");
        this.values.put("critter", "${critterSpeed} ${critterColor} ${critterType}");
        this.values.put("critterSpeed", "quick");
        this.values.put("critterColor", "brown");
        this.values.put("critterType", "fox");
        this.doTestReplace(sub, "The ${critter} jumps over the ${pet}.", "The ${animal} jumps over the ${target}.", true);
    }

    @Test
    void testGetSetEscape() {
        StrSubstitutor sub = new StrSubstitutor();
        Assertions.assertEquals((char)'$', (char)sub.getEscapeChar());
        sub.setEscapeChar('<');
        Assertions.assertEquals((char)'<', (char)sub.getEscapeChar());
    }

    @Test
    void testGetSetPrefix() {
        StrSubstitutor sub = new StrSubstitutor();
        StrMatcherTest.assertStrMatcherPrefixImpl("StringMatcher", sub);
        StrMatcherTest.assertStrMatcherSuffixImpl("StringMatcher", sub);
        sub.setVariablePrefix('<');
        StrMatcherTest.assertStrMatcherPrefixImpl("CharMatcher", sub);
        StrMatcherTest.assertStrMatcherSuffixImpl("StringMatcher", sub);
        sub.setVariablePrefix("<<");
        StrMatcherTest.assertStrMatcherPrefixImpl("StringMatcher", sub);
        StrMatcherTest.assertStrMatcherSuffixImpl("StringMatcher", sub);
        Assertions.assertThrows(IllegalArgumentException.class, () -> sub.setVariablePrefix((String)null));
        StrMatcherTest.assertStrMatcherPrefixImpl("StringMatcher", sub);
        StrMatcherTest.assertStrMatcherSuffixImpl("StringMatcher", sub);
        StrMatcher matcher = StrMatcher.commaMatcher();
        sub.setVariablePrefixMatcher(matcher);
        Assertions.assertSame((Object)matcher, (Object)sub.getVariablePrefixMatcher());
        Assertions.assertThrows(IllegalArgumentException.class, () -> sub.setVariablePrefixMatcher((StrMatcher)null));
        Assertions.assertSame((Object)matcher, (Object)sub.getVariablePrefixMatcher());
    }

    @Test
    void testGetSetSuffix() {
        StrSubstitutor sub = new StrSubstitutor();
        StrMatcherTest.assertStrMatcherPrefixImpl("StringMatcher", sub);
        StrMatcherTest.assertStrMatcherSuffixImpl("StringMatcher", sub);
        sub.setVariableSuffix('<');
        StrMatcherTest.assertStrMatcherPrefixImpl("StringMatcher", sub);
        StrMatcherTest.assertStrMatcherSuffixImpl("CharMatcher", sub);
        sub.setVariableSuffix("<<");
        StrMatcherTest.assertStrMatcherPrefixImpl("StringMatcher", sub);
        StrMatcherTest.assertStrMatcherSuffixImpl("StringMatcher", sub);
        Assertions.assertThrows(IllegalArgumentException.class, () -> sub.setVariableSuffix((String)null));
        StrMatcherTest.assertStrMatcherPrefixImpl("StringMatcher", sub);
        StrMatcherTest.assertStrMatcherSuffixImpl("StringMatcher", sub);
        StrMatcher matcher = StrMatcher.commaMatcher();
        sub.setVariableSuffixMatcher(matcher);
        Assertions.assertSame((Object)matcher, (Object)sub.getVariableSuffixMatcher());
        Assertions.assertThrows(IllegalArgumentException.class, () -> sub.setVariableSuffixMatcher((StrMatcher)null));
        Assertions.assertSame((Object)matcher, (Object)sub.getVariableSuffixMatcher());
    }

    @Test
    void testGetSetValueDelimiter() {
        StrSubstitutor sub = new StrSubstitutor();
        StrMatcherTest.assertStrMatcherPrefixImpl("StringMatcher", sub);
        StrMatcherTest.assertStrMatcherSuffixImpl("StringMatcher", sub);
        sub.setValueDelimiter(':');
        StrMatcherTest.assertStrMatcherPrefixImpl("StringMatcher", sub);
        StrMatcherTest.assertStrMatcherSuffixImpl("StringMatcher", sub);
        sub.setValueDelimiter("||");
        StrMatcherTest.assertStrMatcherPrefixImpl("StringMatcher", sub);
        StrMatcherTest.assertStrMatcherSuffixImpl("StringMatcher", sub);
        sub.setValueDelimiter((String)null);
        Assertions.assertNull((Object)sub.getValueDelimiterMatcher());
        StrMatcher matcher = StrMatcher.commaMatcher();
        sub.setValueDelimiterMatcher(matcher);
        Assertions.assertSame((Object)matcher, (Object)sub.getValueDelimiterMatcher());
        sub.setValueDelimiterMatcher((StrMatcher)null);
        Assertions.assertNull((Object)sub.getValueDelimiterMatcher());
    }

    @Test
    void testLANG1055() {
        System.setProperty("test_key", "test_value");
        String expected = StrSubstitutor.replace((Object)"test_key=${test_key}", (Properties)System.getProperties());
        String actual = StrSubstitutor.replaceSystemProperties((Object)"test_key=${test_key}");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    void testReplaceAdjacentAtEnd() {
        this.values.put("code", "GBP");
        this.values.put("amount", "12.50");
        StrSubstitutor sub = new StrSubstitutor(this.values);
        Assertions.assertEquals((Object)"Amount is GBP12.50", (Object)sub.replace("Amount is ${code}${amount}"));
    }

    @Test
    void testReplaceAdjacentAtStart() {
        this.values.put("code", "GBP");
        this.values.put("amount", "12.50");
        StrSubstitutor sub = new StrSubstitutor(this.values);
        Assertions.assertEquals((Object)"GBP12.50 charged", (Object)sub.replace("${code}${amount} charged"));
    }

    @Test
    void testReplaceChangedMap() {
        StrSubstitutor sub = new StrSubstitutor(this.values);
        this.values.put("target", "moon");
        Assertions.assertEquals((Object)"The quick brown fox jumps over the moon.", (Object)sub.replace("The ${animal} jumps over the ${target}."));
    }

    @Test
    void testReplaceComplexEscaping() {
        this.doTestReplace("The ${quick brown fox} jumps over the lazy dog.", "The $${${animal}} jumps over the ${target}.", true);
        this.doTestReplace("The ${quick brown fox} jumps over the lazy dog. ${1234567890}.", "The $${${animal}} jumps over the ${target}. $${${undefined.number:-1234567890}}.", true);
    }

    @Test
    void testReplaceEmpty() {
        this.doTestNoReplace("");
    }

    @Test
    void testReplaceEmptyKeys() {
        this.doTestReplace("The ${} jumps over the lazy dog.", "The ${} jumps over the ${target}.", true);
        this.doTestReplace("The animal jumps over the lazy dog.", "The ${:-animal} jumps over the ${target}.", true);
    }

    @Test
    void testReplaceEscaping() {
        this.doTestReplace("The ${animal} jumps over the lazy dog.", "The $${animal} jumps over the ${target}.", true);
    }

    @Test
    void testReplaceIncompletePrefix() {
        this.doTestReplace("The {animal} jumps over the lazy dog.", "The {animal} jumps over the ${target}.", true);
    }

    @Test
    void testReplaceInTakingStringBufferWithNonNull() {
        StrSubstitutor strSubstitutor = new StrSubstitutor(new HashMap(), "WV@i#y?N*[", "WV@i#y?N*[", '*');
        Assertions.assertFalse((boolean)strSubstitutor.isPreserveEscapes());
        Assertions.assertFalse((boolean)strSubstitutor.replaceIn(new StringBuffer("WV@i#y?N*[")));
        Assertions.assertEquals((char)'*', (char)strSubstitutor.getEscapeChar());
    }

    @Test
    void testReplaceInTakingStringBuilderWithNonNull() {
        StrLookup strLookup = StrLookup.systemPropertiesLookup();
        StrSubstitutor strSubstitutor = new StrSubstitutor(strLookup, "b<H", "b<H", '\'');
        StringBuilder stringBuilder = new StringBuilder((CharSequence)"b<H");
        Assertions.assertEquals((char)'\'', (char)strSubstitutor.getEscapeChar());
        Assertions.assertFalse((boolean)strSubstitutor.replaceIn(stringBuilder));
    }

    @Test
    void testReplaceInTakingStringBuilderWithNull() {
        HashMap map = new HashMap();
        StrSubstitutor strSubstitutor = new StrSubstitutor(map, "", "", 'T', "K+<'f");
        Assertions.assertFalse((boolean)strSubstitutor.replaceIn((StringBuilder)null));
    }

    @Test
    void testReplaceInTakingTwoAndThreeIntsReturningFalse() {
        HashMap hashMap = new HashMap();
        StrLookup strLookupMapStrLookup = StrLookup.mapLookup(hashMap);
        StrMatcher strMatcher = StrMatcher.tabMatcher();
        StrSubstitutor strSubstitutor = new StrSubstitutor(strLookupMapStrLookup, strMatcher, strMatcher, 'b', strMatcher);
        Assertions.assertFalse((boolean)strSubstitutor.replaceIn((StringBuilder)null, 1315, -1369));
        Assertions.assertEquals((char)'b', (char)strSubstitutor.getEscapeChar());
        Assertions.assertFalse((boolean)strSubstitutor.isPreserveEscapes());
    }

    @Test
    void testReplaceInVariable() {
        this.values.put("animal.1", "fox");
        this.values.put("animal.2", "mouse");
        this.values.put("species", "2");
        StrSubstitutor sub = new StrSubstitutor(this.values);
        sub.setEnableSubstitutionInVariables(true);
        Assertions.assertEquals((Object)"The mouse jumps over the lazy dog.", (Object)sub.replace("The ${animal.${species}} jumps over the ${target}."));
        this.values.put("species", "1");
        Assertions.assertEquals((Object)"The fox jumps over the lazy dog.", (Object)sub.replace("The ${animal.${species}} jumps over the ${target}."));
        Assertions.assertEquals((Object)"The fox jumps over the lazy dog.", (Object)sub.replace("The ${unknown.animal.${unknown.species:-1}:-fox} jumps over the ${unknow.target:-lazy dog}."));
    }

    @Test
    void testReplaceInVariableDisabled() {
        this.values.put("animal.1", "fox");
        this.values.put("animal.2", "mouse");
        this.values.put("species", "2");
        StrSubstitutor sub = new StrSubstitutor(this.values);
        Assertions.assertEquals((Object)"The ${animal.${species}} jumps over the lazy dog.", (Object)sub.replace("The ${animal.${species}} jumps over the ${target}."));
        Assertions.assertEquals((Object)"The ${animal.${species:-1}} jumps over the lazy dog.", (Object)sub.replace("The ${animal.${species:-1}} jumps over the ${target}."));
    }

    @Test
    void testReplaceInVariableRecursive() {
        this.values.put("animal.2", "brown fox");
        this.values.put("animal.1", "white mouse");
        this.values.put("color", "white");
        this.values.put("species.white", "1");
        this.values.put("species.brown", "2");
        StrSubstitutor sub = new StrSubstitutor(this.values);
        sub.setEnableSubstitutionInVariables(true);
        Assertions.assertEquals((Object)"The white mouse jumps over the lazy dog.", (Object)sub.replace("The ${animal.${species.${color}}} jumps over the ${target}."));
        Assertions.assertEquals((Object)"The brown fox jumps over the lazy dog.", (Object)sub.replace("The ${animal.${species.${unknownColor:-brown}}} jumps over the ${target}."));
    }

    @Test
    void testReplaceNoPrefixNoSuffix() {
        this.doTestReplace("The animal jumps over the lazy dog.", "The animal jumps over the ${target}.", true);
    }

    @Test
    void testReplaceNoPrefixSuffix() {
        this.doTestReplace("The animal} jumps over the lazy dog.", "The animal} jumps over the ${target}.", true);
    }

    @Test
    void testReplaceNoVariables() {
        this.doTestNoReplace("The balloon arrived.");
    }

    @Test
    void testReplaceNull() {
        this.doTestNoReplace(null);
    }

    @Test
    void testReplacePartialString_noReplace() {
        StrSubstitutor sub = new StrSubstitutor();
        Assertions.assertEquals((Object)"${animal} jumps", (Object)sub.replace("The ${animal} jumps over the ${target}.", 4, 15));
    }

    @Test
    void testReplacePrefixNoSuffix() {
        this.doTestReplace("The ${animal jumps over the ${target} lazy dog.", "The ${animal jumps over the ${target} ${target}.", true);
    }

    @Test
    void testReplaceRecursive() {
        this.values.put("animal", "${critter}");
        this.values.put("target", "${pet}");
        this.values.put("pet", "${petCharacteristic} dog");
        this.values.put("petCharacteristic", "lazy");
        this.values.put("critter", "${critterSpeed} ${critterColor} ${critterType}");
        this.values.put("critterSpeed", "quick");
        this.values.put("critterColor", "brown");
        this.values.put("critterType", "fox");
        this.doTestReplace("The quick brown fox jumps over the lazy dog.", "The ${animal} jumps over the ${target}.", true);
        this.values.put("pet", "${petCharacteristicUnknown:-lazy} dog");
        this.doTestReplace("The quick brown fox jumps over the lazy dog.", "The ${animal} jumps over the ${target}.", true);
    }

    @Test
    void testReplaceSimple() {
        this.doTestReplace("The quick brown fox jumps over the lazy dog.", "The ${animal} jumps over the ${target}.", true);
    }

    @Test
    void testReplaceSolo() {
        this.doTestReplace("quick brown fox", "${animal}", false);
    }

    @Test
    void testReplaceSoloEscaping() {
        this.doTestReplace("${animal}", "$${animal}", false);
    }

    @Test
    void testReplaceTakingCharSequenceReturningNull() {
        StrSubstitutor strSubstitutor = new StrSubstitutor((StrLookup)null);
        Assertions.assertNull((Object)strSubstitutor.replace((CharSequence)null));
        Assertions.assertFalse((boolean)strSubstitutor.isPreserveEscapes());
        Assertions.assertEquals((char)'$', (char)strSubstitutor.getEscapeChar());
    }

    @Test
    void testReplaceTakingThreeArgumentsThrowsNullPointerException() {
        Assertions.assertThrows(NullPointerException.class, () -> StrSubstitutor.replace(null, (Properties)null));
    }

    @Test
    void testReplaceToIdentical() {
        this.values.put("animal", "$${${thing}}");
        this.values.put("thing", "animal");
        this.doTestReplace("The ${animal} jumps.", "The ${animal} jumps.", true);
    }

    @Test
    void testReplaceUnknownKey() {
        this.doTestReplace("The ${person} jumps over the lazy dog.", "The ${person} jumps over the ${target}.", true);
        this.doTestReplace("The ${person} jumps over the lazy dog. 1234567890.", "The ${person} jumps over the ${target}. ${undefined.number:-1234567890}.", true);
    }

    @Test
    void testReplaceWeirdPattens() {
        this.doTestNoReplace("");
        this.doTestNoReplace("${}");
        this.doTestNoReplace("${ }");
        this.doTestNoReplace("${\t}");
        this.doTestNoReplace("${\n}");
        this.doTestNoReplace("${\b}");
        this.doTestNoReplace("${");
        this.doTestNoReplace("$}");
        this.doTestNoReplace("}");
        this.doTestNoReplace("${}$");
        this.doTestNoReplace("${${");
        this.doTestNoReplace("${${}}");
        this.doTestNoReplace("${$${}}");
        this.doTestNoReplace("${$$${}}");
        this.doTestNoReplace("${$$${$}}");
        this.doTestNoReplace("${${}}");
        this.doTestNoReplace("${${ }}");
    }

    @Test
    void testResolveVariable() {
        final StrBuilder builder = new StrBuilder("Hi ${name}!");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "commons");
        StrSubstitutor sub = new StrSubstitutor(this, map){
            final /* synthetic */ StrSubstitutorTest this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            protected String resolveVariable(String variableName, StrBuilder buf, int startPos, int endPos) {
                Assertions.assertEquals((Object)"name", (Object)variableName);
                Assertions.assertSame((Object)builder, (Object)buf);
                Assertions.assertEquals((int)3, (int)startPos);
                Assertions.assertEquals((int)10, (int)endPos);
                return "jakarta";
            }
        };
        sub.replaceIn(builder);
        Assertions.assertEquals((Object)"Hi jakarta!", (Object)builder.toString());
    }

    @Test
    void testSamePrefixAndSuffix() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("greeting", "Hello");
        map.put(" there ", "XXX");
        map.put("name", "commons");
        Assertions.assertEquals((Object)"Hi commons!", (Object)StrSubstitutor.replace((Object)"Hi @name@!", map, (String)"@", (String)"@"));
        Assertions.assertEquals((Object)"Hello there commons!", (Object)StrSubstitutor.replace((Object)"@greeting@ there @name@!", map, (String)"@", (String)"@"));
    }

    @Test
    void testStaticReplace() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "commons");
        Assertions.assertEquals((Object)"Hi commons!", (Object)StrSubstitutor.replace((Object)"Hi ${name}!", map));
    }

    @Test
    void testStaticReplacePrefixSuffix() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "commons");
        Assertions.assertEquals((Object)"Hi commons!", (Object)StrSubstitutor.replace((Object)"Hi <name>!", map, (String)"<", (String)">"));
    }

    @Test
    void testStaticReplaceSystemProperties() {
        StrBuilder buf = new StrBuilder();
        buf.append("Hi ").append(SystemProperties.getUserName());
        buf.append(", you are working with ");
        buf.append(SystemProperties.getOsName());
        buf.append(", your home directory is ");
        buf.append(SystemProperties.getUserHome()).append('.');
        Assertions.assertEquals((Object)buf.toString(), (Object)StrSubstitutor.replaceSystemProperties((Object)"Hi ${user.name}, you are working with ${os.name}, your home directory is ${user.home}."));
    }

    @Test
    void testSubstituteDefaultProperties() {
        String org = "${doesnotwork}";
        System.setProperty("doesnotwork", "It works!");
        Properties props = new Properties(System.getProperties());
        Assertions.assertEquals((Object)"It works!", (Object)StrSubstitutor.replace((Object)"${doesnotwork}", (Properties)props));
    }

    @Test
    void testSubstitutePreserveEscape() {
        String org = "${not-escaped} $${escaped}";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("not-escaped", "value");
        StrSubstitutor sub = new StrSubstitutor(map, "${", "}", '$');
        Assertions.assertFalse((boolean)sub.isPreserveEscapes());
        Assertions.assertEquals((Object)"value ${escaped}", (Object)sub.replace("${not-escaped} $${escaped}"));
        sub.setPreserveEscapes(true);
        Assertions.assertTrue((boolean)sub.isPreserveEscapes());
        Assertions.assertEquals((Object)"value $${escaped}", (Object)sub.replace("${not-escaped} $${escaped}"));
    }
}

