/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.RFC2396;
import org.apache.commons.vfs2.provider.UriParser;

public class GenericFileName
extends AbstractFileName {
    private final String userName;
    private final String hostName;
    private final int defaultPort;
    private final String password;
    private final int port;

    protected GenericFileName(String scheme, String hostName, int port, int defaultPort, String userName, String password, String path, FileType type) {
        super(scheme, path, type);
        this.hostName = hostName;
        this.defaultPort = defaultPort;
        this.password = password;
        this.userName = userName;
        this.port = port > 0 ? port : defaultPort;
    }

    protected void appendCredentials(StringBuilder buffer, boolean addPassword) {
        if (!StringUtils.isEmpty((CharSequence)this.userName)) {
            UriParser.appendEncodedRfc2396(buffer, this.userName, RFC2396.USERINFO_UNESCAPED);
            if (this.password != null && !this.password.isEmpty()) {
                buffer.append(':');
                if (addPassword) {
                    UriParser.appendEncodedRfc2396(buffer, this.password, RFC2396.USERINFO_UNESCAPED);
                } else {
                    buffer.append("***");
                }
            }
            buffer.append('@');
        }
    }

    @Override
    protected void appendRootUri(StringBuilder buffer, boolean addPassword) {
        buffer.append(this.getScheme());
        buffer.append("://");
        this.appendCredentials(buffer, addPassword);
        buffer.append(this.hostName);
        if (this.port != this.getDefaultPort()) {
            buffer.append(':');
            buffer.append(this.port);
        }
    }

    @Override
    public FileName createName(String absPath, FileType type) {
        return new GenericFileName(this.getScheme(), this.hostName, this.port, this.defaultPort, this.userName, this.password, absPath, type);
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getPassword() {
        return this.password;
    }

    public int getPort() {
        return this.port;
    }

    public String getUserName() {
        return this.userName;
    }
}

