/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jca.cxf.handlers;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jca.core.resourceadapter.ResourceAdapterInternalException;
import org.apache.cxf.jca.cxf.CXFInvocationHandler;
import org.apache.cxf.jca.cxf.CXFInvocationHandlerData;
import org.apache.cxf.jca.cxf.CXFManagedConnection;
import org.apache.cxf.jca.cxf.handlers.CXFInvocationHandlerDataImpl;

public class InvocationHandlerFactory {
    public static final String JCA_HANDLERS_RESOURCE = "META-INF/cxf-jca-handlers.properties";
    private static final Logger LOG = LogUtils.getL7dLogger(InvocationHandlerFactory.class);
    final Class<?>[] handlerChainTypes;
    private final Bus bus;
    private final CXFManagedConnection managedConnection;

    public InvocationHandlerFactory(Bus b, CXFManagedConnection connection) throws ResourceAdapterInternalException {
        this.bus = b;
        this.managedConnection = connection;
        try {
            this.handlerChainTypes = this.getHandlerChainDefinition();
        }
        catch (Exception ex) {
            ResourceAdapterInternalException raie = new ResourceAdapterInternalException("unable to load handler chain definition", ex);
            LOG.warning(ex.getMessage());
            throw raie;
        }
    }

    public CXFInvocationHandler createHandlers(Object target, Subject subject) throws ResourceAdapterInternalException {
        CXFInvocationHandler first = null;
        CXFInvocationHandler last = null;
        CXFInvocationHandlerDataImpl data = new CXFInvocationHandlerDataImpl();
        data.setBus(this.bus);
        data.setManagedConnection(this.managedConnection);
        data.setSubject(subject);
        data.setTarget(target);
        for (int i = 0; i < this.handlerChainTypes.length; ++i) {
            CXFInvocationHandler newHandler;
            try {
                Constructor<?> newHandlerConstructor = this.handlerChainTypes[i].getDeclaredConstructor(CXFInvocationHandlerData.class);
                newHandler = (CXFInvocationHandler)newHandlerConstructor.newInstance(data);
            }
            catch (Exception ex) {
                ResourceAdapterInternalException raie = new ResourceAdapterInternalException("error creating InvocationHandler: " + String.valueOf(this.handlerChainTypes[i]), ex);
                LOG.warning(raie.getMessage());
                throw raie;
            }
            if (last != null) {
                last.setNext(newHandler);
                last = newHandler;
                continue;
            }
            first = newHandler;
            last = newHandler;
        }
        return first;
    }

    private Class<?>[] getHandlerChainDefinition() throws IOException, ClassNotFoundException {
        TreeMap<Long, String> handlersMap = new TreeMap<Long, String>();
        Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources(JCA_HANDLERS_RESOURCE);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            this.loadProperties(handlersMap, url);
        }
        Class[] handlers = new Class[handlersMap.size()];
        String[] handlerClasses = new String[handlersMap.size()];
        handlersMap.values().toArray(handlerClasses);
        for (int i = 0; i < handlerClasses.length; ++i) {
            LOG.fine("reading handler class: " + handlerClasses[i]);
            handlers[i] = this.getClass().getClassLoader().loadClass(handlerClasses[i]);
        }
        return handlers;
    }

    private void loadProperties(Map<Long, String> handlersMap, URL url) throws IOException {
        Properties p = new Properties();
        p.load(url.openStream());
        for (String string : p.keySet()) {
            handlersMap.put(Long.valueOf(string), p.getProperty(string));
        }
    }
}

