/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.codegen.c.generators;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.daffodil.codegen.c.generators.ComplexCGState;
import org.apache.daffodil.codegen.c.generators.ComplexCGState$;
import org.apache.daffodil.codegen.c.generators.package$;
import org.apache.daffodil.core.dsom.Choice;
import org.apache.daffodil.core.dsom.ElementBase;
import org.apache.daffodil.core.dsom.GlobalComplexTypeDef;
import org.apache.daffodil.core.dsom.GlobalElementDecl;
import org.apache.daffodil.core.dsom.ModelGroup;
import org.apache.daffodil.core.dsom.SchemaComponent;
import org.apache.daffodil.lib.cookers.ChoiceBranchKeyCooker$;
import org.apache.daffodil.lib.exceptions.ThrowsSDE;
import org.apache.daffodil.lib.iapi.WarnID;
import org.apache.daffodil.lib.schema.annotation.props.gen.OccursCountKind;
import org.apache.daffodil.lib.util.MaybeJULong;
import org.apache.daffodil.lib.util.MaybeULong$;
import org.apache.daffodil.runtime1.dpath.NodeInfo;
import org.apache.daffodil.runtime1.dpath.PrimTypeNode;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.SetOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Stack;
import scala.collection.mutable.Stack$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.RichChar;
import scala.runtime.RichChar$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.matching.Regex;

public class CodeGeneratorState {
    private final ElementBase root;
    private final Map<String, ElementBase> elementsAlreadySeen;
    private final Stack<ComplexCGState> structs;
    private final ArrayBuffer<String> prototypes;
    private final ArrayBuffer<String> erds;
    private final ArrayBuffer<String> finalStructs;
    private final ArrayBuffer<String> finalImplementation;

    public CodeGeneratorState(ElementBase root) {
        this.root = root;
        this.elementsAlreadySeen = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.structs = new Stack(Stack$.MODULE$.$lessinit$greater$default$1());
        this.prototypes = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.erds = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.finalStructs = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.finalImplementation = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.structs.push((Object)new ComplexCGState(this.cStructName(root), root, ComplexCGState$.MODULE$.$lessinit$greater$default$3()));
    }

    private ElementBase root() {
        return this.root;
    }

    public boolean hasArray() {
        return this.structs.nonEmpty() && ((ComplexCGState)this.structs.top()).inArray();
    }

    public boolean hasChoice() {
        return this.structs.nonEmpty() && ((ComplexCGState)this.structs.top()).initChoiceStatements().nonEmpty();
    }

    public void pushElement(ElementBase context) {
        block6: {
            block5: {
                if (this.hasChoice()) {
                    int position = context.position();
                    ((ComplexCGState)this.structs.top()).initChoiceStatements().$plus$plus$eq((IterableOnce)((List)ChoiceBranchKeyCooker$.MODULE$.convertConstant((Object)context.choiceBranchKey(), (ThrowsSDE)context, false)).map((Function1 & Serializable)key -> "    case " + key + ":"));
                    ((ComplexCGState)this.structs.top()).initChoiceStatements().$plus$eq((Object)("        instance->_choice = " + position + ";"));
                    ((ComplexCGState)this.structs.top()).parserStatements().$plus$eq((Object)("    case " + position + ":"));
                    ((ComplexCGState)this.structs.top()).unparserStatements().$plus$eq((Object)("    case " + position + ":"));
                }
                if (context.isComplexType()) break block5;
                ElementBase elementBase = context;
                ElementBase elementBase2 = this.root();
                if (elementBase != null ? !elementBase.equals(elementBase2) : elementBase2 != null) break block6;
            }
            String C = this.cStructName(context);
            this.structs.push((Object)new ComplexCGState(C, context, ComplexCGState$.MODULE$.$lessinit$greater$default$3()));
            String erd = this.erdName(context);
            ((ComplexCGState)this.structs.top()).initERDStatements().$plus$eq((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("    instance->_base.erd = &" + erd + ";\n           |    instance->_base.parent = parent;")));
            if (context.isComplexType() && MaybeULong$.MODULE$.isDefined$extension(context.maybeFixedLengthInBits()) && MaybeULong$.MODULE$.get$extension(context.maybeFixedLengthInBits()) > 0L) {
                long lengthInBits = MaybeULong$.MODULE$.get$extension(context.maybeFixedLengthInBits());
                ((ComplexCGState)this.structs.top()).parserStatements().$plus$eq((Object)("    const size_t end_bitPos0b = pstate->pu.bitPos0b + " + lengthInBits + ";"));
                ((ComplexCGState)this.structs.top()).unparserStatements().$plus$eq((Object)("    const size_t end_bitPos0b = ustate->pu.bitPos0b + " + lengthInBits + ";"));
                return;
            }
            return;
        }
    }

    public void popElement(ElementBase context) {
        if (context.isComplexType()) {
            if (MaybeULong$.MODULE$.isDefined$extension(context.maybeFixedLengthInBits()) && MaybeULong$.MODULE$.get$extension(context.maybeFixedLengthInBits()) > 0L) {
                ((ComplexCGState)this.structs.top()).parserStatements().$plus$eq((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("    parse_alignment_bits(end_bitPos0b, pstate);\n             |    if (pstate->pu.error) return;")));
                String octalFillByte = RichInt$.MODULE$.toOctalString$extension(Predef$.MODULE$.intWrapper((int)((byte)Predef$.MODULE$.Integer2int((Integer)context.fillByteEv().constValue()))));
                ((ComplexCGState)this.structs.top()).unparserStatements().$plus$eq((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("    unparse_alignment_bits(end_bitPos0b, '\\" + octalFillByte + "', ustate);\n             |    if (ustate->pu.error) return;")));
            }
            if (this.elementNotSeenYet(context, this.cStructName(context))) {
                this.addComplexTypeERD(context);
                this.addStruct(context);
                this.addImplementation(context);
            }
            this.structs.pop();
            String indent1 = this.hasChoice() ? package$.MODULE$.INDENT() : package$.MODULE$.NO_INDENT();
            String indent2 = this.hasArray() ? package$.MODULE$.INDENT() : package$.MODULE$.NO_INDENT();
            String C = this.cStructName(context);
            String e = this.cName(context);
            String deref = this.hasArray() ? "[i]" : "";
            ArrayBuffer arrayBuffer = this.hasChoice() ? (ArrayBuffer)((ComplexCGState)this.structs.top()).initChoiceStatements().$plus$eq((Object)(indent2 + "        " + C + "_initERD(&instance->" + e + deref + ", (InfosetBase *)instance);")) : (ArrayBuffer)((ComplexCGState)this.structs.top()).initERDStatements().$plus$eq((Object)(indent2 + "    " + C + "_initERD(&instance->" + e + deref + ", (InfosetBase *)instance);"));
            ((ComplexCGState)this.structs.top()).parserStatements().$plus$eq((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(indent1 + indent2 + "    " + C + "_parseSelf(&instance->" + e + deref + ", pstate);\n           |" + indent1 + indent2 + "    if (pstate->pu.error) return;")));
            v1 = ((ComplexCGState)this.structs.top()).unparserStatements().$plus$eq((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(indent1 + indent2 + "    " + C + "_unparseSelf(&instance->" + e + deref + ", ustate);\n           |" + indent1 + indent2 + "    if (ustate->pu.error) return;")));
        } else {
            ElementBase elementBase = context;
            ElementBase elementBase2 = this.root();
            if (!(elementBase != null ? !elementBase.equals(elementBase2) : elementBase2 != null)) {
                this.addFieldDeclaration(context);
                this.addComputations(context);
                this.addSimpleTypeERD(context);
                this.addStruct(context);
                this.addImplementation(context);
                v1 = this.structs.pop();
            } else if (this.elementNotSeenYet(context, this.cStructName(context))) {
                this.addSimpleTypeERD(context);
                v1 = BoxedUnit.UNIT;
            } else {
                v1 = BoxedUnit.UNIT;
            }
        }
        this.addFieldDeclaration(context);
        this.addComputations(context);
        if (this.hasChoice()) {
            String string = "        break;";
            ((ComplexCGState)this.structs.top()).initChoiceStatements().$plus$eq((Object)string);
            ((ComplexCGState)this.structs.top()).parserStatements().$plus$eq((Object)string);
            ((ComplexCGState)this.structs.top()).unparserStatements().$plus$eq((Object)string);
            return;
        }
    }

    public void pushArray(SchemaComponent context) {
        String C = ((ComplexCGState)this.structs.top()).C();
        ElementBase e = (ElementBase)context;
        this.structs.push((Object)new ComplexCGState(C, e, true));
    }

    public void popArray(SchemaComponent context) {
        ElementBase e = (ElementBase)context;
        String C = ((ComplexCGState)this.structs.top()).C();
        String arrayName = "array_" + this.cStructName(e) + C;
        if (this.elementNotSeenYet(e, arrayName)) {
            this.addArrayImplementation(e);
        }
        ArrayBuffer<String> declarations = ((ComplexCGState)this.structs.top()).declarations();
        ArrayBuffer<String> offsetComputations = ((ComplexCGState)this.structs.top()).offsetComputations();
        ArrayBuffer<String> erdComputations = ((ComplexCGState)this.structs.top()).erdComputations();
        this.structs.pop();
        ((ComplexCGState)this.structs.top()).declarations().$plus$plus$eq(declarations);
        ((ComplexCGState)this.structs.top()).offsetComputations().$plus$plus$eq(offsetComputations);
        ((ComplexCGState)this.structs.top()).erdComputations().$plus$plus$eq(erdComputations);
        String indent = this.hasChoice() ? package$.MODULE$.INDENT() : package$.MODULE$.NO_INDENT();
        ArrayBuffer arrayBuffer = this.hasChoice() ? (ArrayBuffer)((ComplexCGState)this.structs.top()).initChoiceStatements().$plus$eq((Object)(indent + "    " + arrayName + "_initERD(instance, parent);")) : (ArrayBuffer)((ComplexCGState)this.structs.top()).initERDStatements().$plus$eq((Object)(indent + "    " + arrayName + "_initERD(instance, parent);"));
        ((ComplexCGState)this.structs.top()).parserStatements().$plus$eq((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(indent + "    " + arrayName + "_parseSelf(instance, pstate);\n         |" + indent + "    if (pstate->pu.error) return;")));
        ((ComplexCGState)this.structs.top()).unparserStatements().$plus$eq((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(indent + "    " + arrayName + "_unparseSelf(instance, ustate);\n         |" + indent + "    if (ustate->pu.error) return;")));
    }

    public void addBeforeSwitchStatements() {
        ElementBase context = ((ComplexCGState)this.structs.top()).context();
        String erd = this.erdName(context);
        String dispatchField = this.choiceDispatchField(context);
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(dispatchField))) {
            String C = this.cStructName(context);
            String declaration = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("    size_t      _choice; // choice of which union field to use\n           |    union\n           |    {"));
            String erdDef = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("static const ERD _choice_" + erd + " = {\n           |    {\n           |        NULL, // namedQName.prefix\n           |        \"_choice\", // namedQName.local\n           |        NULL, // namedQName.ns\n           |    },\n           |    CHOICE, // typeCode\n           |    0, NULL, NULL, NULL, NULL, {NULL}\n           |};\n           |"));
            String offsetComputation = "    (const char *)&" + C + "_compute_offsets._choice - (const char *)&" + C + "_compute_offsets";
            String erdComputation = "    &_choice_" + erd;
            String initChoiceStatement = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("    static Error error = {ERR_CHOICE_KEY, {0}};\n           |\n           |    int64_t key = " + dispatchField + ";\n           |    switch (key)\n           |    {"));
            String parseStatement = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("    static Error error = {ERR_CHOICE_KEY, {0}};\n           |\n           |    pstate->pu.error = instance->_base.erd->initChoice(&instance->_base);\n           |    if (pstate->pu.error) return;\n           |\n           |    switch (instance->_choice)\n           |    {"));
            String unparseStatement = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("    static Error error = {ERR_CHOICE_KEY, {0}};\n           |\n           |    ustate->pu.error = instance->_base.erd->initChoice(&instance->_base);\n           |    if (ustate->pu.error) return;\n           |\n           |    switch (instance->_choice)\n           |    {"));
            if (this.elementNotSeenYet(context, erd)) {
                this.erds.$plus$eq((Object)erdDef);
            }
            ((ComplexCGState)this.structs.top()).declarations().$plus$eq((Object)declaration);
            ((ComplexCGState)this.structs.top()).offsetComputations().$plus$eq((Object)offsetComputation);
            ((ComplexCGState)this.structs.top()).erdComputations().$plus$eq((Object)erdComputation);
            ((ComplexCGState)this.structs.top()).initChoiceStatements().$plus$eq((Object)initChoiceStatement);
            ((ComplexCGState)this.structs.top()).parserStatements().$plus$eq((Object)parseStatement);
            ((ComplexCGState)this.structs.top()).unparserStatements().$plus$eq((Object)unparseStatement);
            return;
        }
    }

    public void addAfterSwitchStatements() {
        if (this.hasChoice()) {
            String declaration = "    };";
            String initChoiceStatement = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("    default:\n           |        error.arg.d64 = key;\n           |        return &error;\n           |    }\n           |\n           |    return NULL;"));
            String parseStatement = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("    default:\n           |        // Should never happen because initChoice would return an error first\n           |        error.arg.d64 = (int64_t)instance->_choice;\n           |        pstate->pu.error = &error;\n           |        return;\n           |    }"));
            String unparseStatement = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("    default:\n           |        // Should never happen because initChoice would return an error first\n           |        error.arg.d64 = (int64_t)instance->_choice;\n           |        ustate->pu.error = &error;\n           |        return;\n           |    }"));
            ((ComplexCGState)this.structs.top()).declarations().$plus$eq((Object)declaration);
            ((ComplexCGState)this.structs.top()).initChoiceStatements().$plus$eq((Object)initChoiceStatement);
            ((ComplexCGState)this.structs.top()).parserStatements().$plus$eq((Object)parseStatement);
            ((ComplexCGState)this.structs.top()).unparserStatements().$plus$eq((Object)unparseStatement);
            return;
        }
    }

    public void addSimpleTypeStatements(String initERDStatement, String parseStatement, String unparseStatement) {
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(initERDStatement))) {
            if (this.hasChoice()) {
                ((ComplexCGState)this.structs.top()).initChoiceStatements().$plus$eq((Object)initERDStatement);
            } else {
                ((ComplexCGState)this.structs.top()).initERDStatements().$plus$eq((Object)initERDStatement);
            }
        }
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(parseStatement))) {
            ((ComplexCGState)this.structs.top()).parserStatements().$plus$eq((Object)parseStatement);
        }
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(unparseStatement))) {
            ((ComplexCGState)this.structs.top()).unparserStatements().$plus$eq((Object)unparseStatement);
            return;
        }
    }

    public String generateVersionHeader() {
        String daffodil = this.getClass().getPackage().getImplementationTitle();
        String version = this.getClass().getPackage().getImplementationVersion();
        String versionHeader = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("#ifndef DAFFODIL_VERSION_H\n         |#define DAFFODIL_VERSION_H\n         |\n         |const char *daffodil_version = \"" + daffodil + " " + version + "\";\n         |\n         |#endif // DAFFODIL_VERSION_H\n         |"));
        return versionHeader.replace("\r\n", "\n").replace("\n", System.lineSeparator());
    }

    public String generateCodeHeader() {
        String structs = this.finalStructs.mkString("\n");
        String header = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("#ifndef GENERATED_CODE_H\n         |#define GENERATED_CODE_H\n         |\n         |// auto-maintained by iwyu\n         |// clang-format off\n         |#include <stdbool.h>  // for bool\n         |#include <stddef.h>   // for size_t\n         |#include <stdint.h>   // for uint8_t, int16_t, int32_t, int64_t, uint32_t, int8_t, uint16_t, uint64_t\n         |#include \"infoset.h\"  // for InfosetBase, HexBinary\n         |// clang-format on\n         |\n         |// Define schema version (will be empty if schema did not define any version string)\n         |\n         |extern const char *schema_version;\n         |\n         |// Define infoset structures\n         |\n         |" + structs + "\n         |#endif // GENERATED_CODE_H\n         |"));
        return header.replace("\r\n", "\n").replace("\n", System.lineSeparator());
    }

    public String generateCodeFile() {
        String rootName = this.cStructName(this.root());
        String version = this.root().schemaDocument().version();
        String prototypes = this.prototypes.mkString("\n");
        String erds = this.erds.mkString("\n");
        String finalImplementation = this.finalImplementation.mkString("\n");
        String code = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("// auto-maintained by iwyu\n         |// clang-format off\n         |#include \"generated_code.h\"\n         |#include <stdbool.h>    // for false, bool, true\n         |#include <stddef.h>     // for NULL, size_t\n         |#include <string.h>     // for memcmp, memset\n         |#include \"errors.h\"     // for Error, PState, UState, ERR_CHOICE_KEY, Error::(anonymous), UNUSED\n         |#include \"parsers.h\"    // for alloc_hexBinary, parse_hexBinary, parse_be_float, parse_be_int16, parse_be_bool32, parse_be_bool16, parse_be_int32, parse_be_uint16, parse_be_uint32, parse_le_bool32, parse_le_int64, parse_le_uint16, parse_le_uint8, parse_be_bool8, parse_be_double, parse_be_int64, parse_be_int8, parse_be_uint64, parse_be_uint8, parse_le_bool16, parse_le_bool8, parse_le_double, parse_le_float, parse_le_int16, parse_le_int32, parse_le_int8, parse_le_uint32, parse_le_uint64\n         |#include \"unparsers.h\"  // for unparse_hexBinary, unparse_be_float, unparse_be_int16, unparse_be_bool32, unparse_be_bool16, unparse_be_int32, unparse_be_uint16, unparse_be_uint32, unparse_le_bool32, unparse_le_int64, unparse_le_uint16, unparse_le_uint8, unparse_be_bool8, unparse_be_double, unparse_be_int64, unparse_be_int8, unparse_be_uint64, unparse_be_uint8, unparse_le_bool16, unparse_le_bool8, unparse_le_double, unparse_le_float, unparse_le_int16, unparse_le_int32, unparse_le_int8, unparse_le_uint32, unparse_le_uint64\n         |#include \"validators.h\" // for validate_array_bounds, validate_fixed_attribute, validate_floatpt_enumeration, validate_integer_enumeration, validate_schema_range\n         |// clang-format on\n         |\n         |// Declare prototypes for easier compilation\n         |\n         |" + prototypes + "\n         |\n         |// Define schema version (will be empty if schema did not define any version string)\n         |\n         |const char *schema_version = \"" + version + "\";\n         |\n         |// Define metadata for the infoset\n         |\n         |" + erds + "\n         |// Initialize, parse, and unparse nodes of the infoset\n         |\n         |" + finalImplementation + "\n         |// Get an infoset (optionally clearing it first) for parsing/walking\n         |\n         |InfosetBase *\n         |get_infoset(bool clear_infoset)\n         |{\n         |    static " + rootName + " infoset;\n         |\n         |    if (clear_infoset)\n         |    {\n         |        // If your infoset contains hexBinary prefixed length elements,\n         |        // you may want to walk infoset first to free their malloc'ed\n         |        // storage - we are not handling that case for now...\n         |        memset(&infoset, 0, sizeof(infoset));\n         |        " + rootName + "_initERD(&infoset, (InfosetBase *)&infoset);\n         |    }\n         |\n         |    return &infoset._base;\n         |}\n         |"));
        return code.replace("\r\n", "\n").replace("\n", System.lineSeparator());
    }

    private String cStructName(ElementBase context) {
        StringBuilder sb = this.buildName((SchemaComponent)context, new StringBuilder());
        this.makeLegalForC(sb);
        String name = sb.toString();
        return name;
    }

    private String erdName(ElementBase context) {
        StringBuilder sb = this.buildName((SchemaComponent)context, new StringBuilder()).$plus$plus$eq("ERD");
        this.makeLegalForC(sb);
        String name = sb.toString();
        return name;
    }

    public String cName(ElementBase context) {
        StringBuilder sb = new StringBuilder(context.namedQName().local());
        this.makeLegalForC(sb);
        String name = sb.toString();
        return name;
    }

    public String cExpression(String expr) {
        Regex field = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(((\\.\\./)+|/)[\\p{L}_][\\p{L}:_\\-.0-9/]*)"));
        String exprWithFields = field.replaceAllIn((CharSequence)expr, (Function1 & Serializable)m -> {
            String fieldName = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(m.group(1)), "../");
            String cFieldName = this.cStructFieldAccess(fieldName);
            return cFieldName;
        });
        Regex operator = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(\\band\\b|\\bdiv\\b|\\beq\\b|\\bge\\b|\\bgt\\b|\\bidiv\\b|\\ble\\b|\\blt\\b|\\bmod\\b|\\bne\\b|\\bor\\b)"));
        String exprWithOperators = operator.replaceAllIn((CharSequence)exprWithFields, (Function1 & Serializable)m -> {
            String operatorName = m.group(1);
            String string = operatorName;
            switch (string == null ? 0 : string.hashCode()) {
                case 3244: {
                    if (!"eq".equals(string)) throw new MatchError((Object)string);
                    return "==";
                }
                case 3294: {
                    if (!"ge".equals(string)) throw new MatchError((Object)string);
                    return ">=";
                }
                case 3309: {
                    if (!"gt".equals(string)) throw new MatchError((Object)string);
                    return ">";
                }
                case 3449: {
                    if (!"le".equals(string)) throw new MatchError((Object)string);
                    return "<=";
                }
                case 3464: {
                    if (!"lt".equals(string)) throw new MatchError((Object)string);
                    return "<";
                }
                case 3511: {
                    if (!"ne".equals(string)) throw new MatchError((Object)string);
                    return "!=";
                }
                case 3555: {
                    if (!"or".equals(string)) throw new MatchError((Object)string);
                    return "||";
                }
                case 96727: {
                    if (!"and".equals(string)) throw new MatchError((Object)string);
                    return "&&";
                }
                case 99473: {
                    if (!"div".equals(string)) throw new MatchError((Object)string);
                    return "/";
                }
                case 108290: {
                    if (!"mod".equals(string)) throw new MatchError((Object)string);
                    return "%";
                }
                case 3227528: {
                    if (!"idiv".equals(string)) throw new MatchError((Object)string);
                    return "/";
                }
                default: {
                    throw new MatchError((Object)string);
                }
            }
        });
        return exprWithOperators;
    }

    private void addComplexTypeERD(ElementBase context) {
        String C = this.cStructName(context);
        String erd = this.erdName(context);
        int count = ((ComplexCGState)this.structs.top()).offsetComputations().length();
        String offsetComputations = ((ComplexCGState)this.structs.top()).offsetComputations().mkString(",\n");
        String erdComputations = ((ComplexCGState)this.structs.top()).erdComputations().mkString(",\n");
        String qNameInit = this.defineQNameInit(context);
        int numChildren = this.hasChoice() ? 2 : count;
        Object initChoice = this.hasChoice() ? "(InitChoiceRD)&" + C + "_initChoice" : "NULL";
        String complexERD = numChildren > 0 ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("static const " + C + " " + C + "_compute_offsets;\n         |\n         |static const size_t " + C + "_childrenOffsets[" + count + "] = {\n         |" + offsetComputations + "\n         |};\n         |\n         |static const ERD *const " + C + "_childrenERDs[" + count + "] = {\n         |" + erdComputations + "\n         |};\n         |\n         |static const ERD " + erd + " = {\n         |" + qNameInit + "\n         |    COMPLEX, // typeCode\n         |    " + numChildren + ", // numChildren\n         |    " + C + "_childrenOffsets,\n         |    " + C + "_childrenERDs,\n         |    (ERDParseSelf)&" + C + "_parseSelf,\n         |    (ERDUnparseSelf)&" + C + "_unparseSelf,\n         |    {.initChoice = " + (String)initChoice + "}\n         |};\n         |")) : StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("static const ERD " + erd + " = {\n         |" + qNameInit + "\n         |    COMPLEX, // typeCode\n         |    " + numChildren + ", // numChildren\n         |    NULL, // childrenOffsets\n         |    NULL, // childrenERDs\n         |    (ERDParseSelf)&" + C + "_parseSelf,\n         |    (ERDUnparseSelf)&" + C + "_unparseSelf,\n         |    {.initChoice = " + (String)initChoice + "}\n         |};\n         |"));
        this.erds.$plus$eq((Object)complexERD);
    }

    private void addStruct(ElementBase context) {
        String C = this.cStructName(context);
        String declarations = ((ComplexCGState)this.structs.top()).declarations().mkString("\n");
        String struct = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("typedef struct " + C + "\n         |{\n         |    InfosetBase _base;\n         |" + declarations + "\n         |} " + C + ";\n         |"));
        this.finalStructs.$plus$eq((Object)struct);
    }

    private void addImplementation(ElementBase context) {
        String C = this.cStructName(context);
        String initERDStatements = ((ComplexCGState)this.structs.top()).initERDStatements().mkString("\n");
        String initChoiceStatements = ((ComplexCGState)this.structs.top()).initChoiceStatements().mkString("\n");
        String parserStatements = ((ComplexCGState)this.structs.top()).parserStatements().nonEmpty() ? ((ComplexCGState)this.structs.top()).parserStatements().mkString("\n") : StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("    // Empty struct, but need to prevent compiler warnings\n         |    UNUSED(instance);\n         |    UNUSED(pstate);"));
        String unparserStatements = ((ComplexCGState)this.structs.top()).unparserStatements().nonEmpty() ? ((ComplexCGState)this.structs.top()).unparserStatements().mkString("\n") : StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("    // Empty struct, but need to prevent compiler warnings\n         |    UNUSED(instance);\n         |    UNUSED(ustate);"));
        String prototypeInitChoice = this.hasChoice() ? "static const Error *" + C + "_initChoice(" + C + " *instance);\n" : "";
        String implementInitChoice = this.hasChoice() ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |static const Error *\n         |" + C + "_initChoice(" + C + " *instance)\n         |{\n         |" + initChoiceStatements + "\n         |}\n         |")) : "";
        String prototypeFunctions = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(prototypeInitChoice + "static void " + C + "_parseSelf(" + C + " *instance, PState *pstate);\n         |static void " + C + "_unparseSelf(const " + C + " *instance, UState *ustate);"));
        String functions = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("static void\n         |" + C + "_initERD(" + C + " *instance, InfosetBase *parent)\n         |{\n         |" + initERDStatements + "\n         |}\n         |" + implementInitChoice + "\n         |static void\n         |" + C + "_parseSelf(" + C + " *instance, PState *pstate)\n         |{\n         |" + parserStatements + "\n         |}\n         |\n         |static void\n         |" + C + "_unparseSelf(const " + C + " *instance, UState *ustate)\n         |{\n         |" + unparserStatements + "\n         |}\n         |"));
        this.prototypes.$plus$eq((Object)prototypeFunctions);
        this.finalImplementation.$plus$eq((Object)functions);
    }

    private boolean elementNotSeenYet(ElementBase context, String key) {
        boolean alreadySeen = this.elementsAlreadySeen.contains((Object)key);
        if (!alreadySeen) {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
            this.elementsAlreadySeen.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)context));
        }
        return !alreadySeen;
    }

    private void addSimpleTypeERD(ElementBase context) {
        String string;
        String C = this.cStructName(context);
        String erd = this.erdName(context);
        int count = ((ComplexCGState)this.structs.top()).offsetComputations().length();
        String offsetComputations = ((ComplexCGState)this.structs.top()).offsetComputations().mkString(",\n");
        String qNameInit = this.defineQNameInit(context);
        NodeInfo.PrimType primType = this.getPrimType(context);
        if (NodeInfo.PrimType$.Boolean$.MODULE$.equals(primType)) {
            string = "PRIMITIVE_BOOLEAN";
        } else if (NodeInfo.PrimType$.Double$.MODULE$.equals(primType)) {
            string = "PRIMITIVE_DOUBLE";
        } else if (NodeInfo.PrimType$.Float$.MODULE$.equals(primType)) {
            string = "PRIMITIVE_FLOAT";
        } else if (NodeInfo.PrimType$.HexBinary$.MODULE$.equals(primType)) {
            string = "PRIMITIVE_HEXBINARY";
        } else if (NodeInfo.PrimType$.Short$.MODULE$.equals(primType)) {
            string = "PRIMITIVE_INT16";
        } else if (NodeInfo.PrimType$.Int$.MODULE$.equals(primType)) {
            string = "PRIMITIVE_INT32";
        } else if (NodeInfo.PrimType$.Long$.MODULE$.equals(primType)) {
            string = "PRIMITIVE_INT64";
        } else if (NodeInfo.PrimType$.Byte$.MODULE$.equals(primType)) {
            string = "PRIMITIVE_INT8";
        } else if (NodeInfo.PrimType$.UnsignedShort$.MODULE$.equals(primType)) {
            string = "PRIMITIVE_UINT16";
        } else if (NodeInfo.PrimType$.UnsignedInt$.MODULE$.equals(primType)) {
            string = "PRIMITIVE_UINT32";
        } else if (NodeInfo.PrimType$.UnsignedLong$.MODULE$.equals(primType)) {
            string = "PRIMITIVE_UINT64";
        } else if (NodeInfo.PrimType$.UnsignedByte$.MODULE$.equals(primType)) {
            string = "PRIMITIVE_UINT8";
        } else {
            NodeInfo.PrimType p = primType;
            throw context.SDE("PrimType %s is not supported.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{p.toString()}));
        }
        String typeCode = string;
        ElementBase elementBase = context;
        ElementBase elementBase2 = this.root();
        String erdDef = !(elementBase != null ? !elementBase.equals(elementBase2) : elementBase2 != null) ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|static const " + C + " " + C + "_compute_offsets;\n          |\n          |static const size_t " + C + "_childrenOffsets[" + count + "] = {\n          |" + offsetComputations + "\n          |};\n          |\n          |static const ERD " + erd + " = {\n          |" + qNameInit + "\n          |    " + typeCode + ", // typeCode\n          |    0, // numChildren\n          |    " + C + "_childrenOffsets,\n          |    NULL, // childrenERDs\n          |    (ERDParseSelf)&" + C + "_parseSelf,\n          |    (ERDUnparseSelf)&" + C + "_unparseSelf,\n          |    {.initChoice = NULL}\n          |};\n          |")) : StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|static const ERD " + erd + " = {\n          |" + qNameInit + "\n          |    " + typeCode + ", // typeCode\n          |    0, NULL, NULL, NULL, NULL, {NULL}\n          |};\n          |"));
        this.erds.$plus$eq((Object)erdDef);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addFieldDeclaration(ElementBase child) {
        String string;
        block8: {
            block9: {
                NodeInfo.PrimType primType;
                block18: {
                    block17: {
                        block16: {
                            block15: {
                                block14: {
                                    block13: {
                                        block12: {
                                            block11: {
                                                block10: {
                                                    if (!child.isSimpleType()) break block9;
                                                    primType = this.getPrimType(child);
                                                    if (!NodeInfo.PrimType$.Boolean$.MODULE$.equals(primType)) break block10;
                                                    string = "bool       ";
                                                    break block8;
                                                }
                                                if (!NodeInfo.PrimType$.Double$.MODULE$.equals(primType)) break block11;
                                                string = "double     ";
                                                break block8;
                                            }
                                            if (!NodeInfo.PrimType$.Float$.MODULE$.equals(primType)) break block12;
                                            string = "float      ";
                                            break block8;
                                        }
                                        if (!NodeInfo.PrimType$.HexBinary$.MODULE$.equals(primType)) break block13;
                                        string = "HexBinary  ";
                                        break block8;
                                    }
                                    if (!NodeInfo.PrimType$.Short$.MODULE$.equals(primType)) break block14;
                                    string = "int16_t    ";
                                    break block8;
                                }
                                if (!NodeInfo.PrimType$.Int$.MODULE$.equals(primType)) break block15;
                                string = "int32_t    ";
                                break block8;
                            }
                            if (!NodeInfo.PrimType$.Long$.MODULE$.equals(primType)) break block16;
                            string = "int64_t    ";
                            break block8;
                        }
                        if (!NodeInfo.PrimType$.Byte$.MODULE$.equals(primType)) break block17;
                        string = "int8_t     ";
                        break block8;
                    }
                    if (!NodeInfo.PrimType$.UnsignedShort$.MODULE$.equals(primType)) break block18;
                    string = "uint16_t   ";
                    break block8;
                }
                if (NodeInfo.PrimType$.UnsignedInt$.MODULE$.equals(primType)) {
                    string = "uint32_t   ";
                    break block8;
                } else if (NodeInfo.PrimType$.UnsignedLong$.MODULE$.equals(primType)) {
                    string = "uint64_t   ";
                    break block8;
                } else {
                    if (!NodeInfo.PrimType$.UnsignedByte$.MODULE$.equals(primType)) {
                        NodeInfo.PrimType p = primType;
                        throw child.SDE("PrimType %s is not supported: ", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{p.toString()}));
                    }
                    string = "uint8_t    ";
                }
                break block8;
            }
            string = this.cStructName(child);
        }
        String definition = string;
        String e = this.cName(child);
        int arraySize = this.arrayMaxOccurs(child);
        Object arrayDef = arraySize > 0 ? "[" + arraySize + "]" : "";
        String indent = this.hasChoice() ? package$.MODULE$.INDENT() : package$.MODULE$.NO_INDENT();
        String declaration = indent + "    " + definition + " " + e + (String)arrayDef + ";";
        ((ComplexCGState)this.structs.top()).declarations().$plus$eq((Object)declaration);
        if (!child.isSimpleType()) return;
        if (!child.isFixedLength()) return;
        Object object = child.optPrimType().get();
        NodeInfo.PrimType$.HexBinary$ hexBinary$ = NodeInfo.PrimType$.HexBinary$.MODULE$;
        if (object == null) {
            if (hexBinary$ != null) {
                return;
            }
        } else if (!object.equals(hexBinary$)) return;
        if (MaybeULong$.MODULE$.get$extension(child.maybeFixedLengthInBits()) <= 0L) return;
        long fixedLength = MaybeULong$.MODULE$.get$extension(child.maybeFixedLengthInBits()) / 8L;
        String declaration2 = indent + "    uint8_t     _a_" + e + (String)arrayDef + "[" + fixedLength + "];";
        ((ComplexCGState)this.structs.top()).declarations().$plus$eq((Object)declaration2);
    }

    private void addComputations(ElementBase child) {
        String C = ((ComplexCGState)this.structs.top()).C();
        String e = this.cName(child);
        boolean hasArray = this.arrayMaxOccurs(child) > 0;
        String arrayName = "array_" + this.cStructName(child) + C;
        Object erd = hasArray ? arrayName + "ERD" : this.erdName(child);
        String deref = hasArray ? "[0]" : "";
        String offsetComputation = "    (const char *)&" + C + "_compute_offsets." + e + deref + " - (const char *)&" + C + "_compute_offsets";
        String erdComputation = "    &" + (String)erd;
        ((ComplexCGState)this.structs.top()).offsetComputations().$plus$eq((Object)offsetComputation);
        ((ComplexCGState)this.structs.top()).erdComputations().$plus$eq((Object)erdComputation);
    }

    private void addArrayImplementation(ElementBase elem) {
        String C = ((ComplexCGState)this.structs.top()).C();
        String e = this.cName(elem);
        String arrayName = "array_" + this.cStructName(elem) + C;
        String erd = this.erdName(elem);
        int maxOccurs = elem.maxOccurs();
        int minOccurs = elem.minOccurs();
        String qNameInit = this.defineQNameInit(elem);
        String arrayERD = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("static const " + C + " " + arrayName + "_compute_offsets;\n         |\n         |static const size_t " + arrayName + "_childrenOffsets[1] = {\n         |    (const char *)&" + arrayName + "_compute_offsets." + e + "[1] - (const char *)&" + arrayName + "_compute_offsets." + e + "[0]\n         |};\n         |\n         |static const ERD *const " + arrayName + "_childrenERDs[1] = {\n         |    &" + erd + "\n         |};\n         |\n         |static const ERD " + arrayName + "ERD = {\n         |" + qNameInit + "\n         |    ARRAY, // typeCode\n         |    " + maxOccurs + ", // maxOccurs\n         |    " + arrayName + "_childrenOffsets,\n         |    " + arrayName + "_childrenERDs,\n         |    (ERDParseSelf)&" + arrayName + "_parseSelf,\n         |    (ERDUnparseSelf)&" + arrayName + "_unparseSelf,\n         |    {.getArraySize = (GetArraySize)&" + arrayName + "_getArraySize}\n         |};\n         |"));
        this.erds.$plus$eq((Object)arrayERD);
        String initERDStatements = ((ComplexCGState)this.structs.top()).initERDStatements().nonEmpty() ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("    UNUSED(parent);\n         |    for (size_t i = 0; i < " + maxOccurs + "; i++)\n         |    {\n         |" + ((ComplexCGState)this.structs.top()).initERDStatements().mkString("\n") + "\n         |    }")) : StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("    UNUSED(instance);\n         |    UNUSED(parent);"));
        String parserStatements = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("    const size_t arraySize = " + arrayName + "_getArraySize(instance);\n         |    validate_array_bounds(\"" + arrayName + "\", arraySize, " + minOccurs + ", " + maxOccurs + ", &pstate->pu);\n         |    if (pstate->pu.error) return;\n         |\n         |    for (size_t i = 0; i < arraySize; i++)\n         |    {\n         |" + ((ComplexCGState)this.structs.top()).parserStatements().mkString("\n") + "\n         |    }"));
        String unparserStatements = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("    const size_t arraySize = " + arrayName + "_getArraySize(instance);\n         |    validate_array_bounds(\"" + arrayName + "\", arraySize, " + minOccurs + ", " + maxOccurs + ", &ustate->pu);\n         |    if (ustate->pu.error) return;\n         |\n         |    for (size_t i = 0; i < arraySize; i++)\n         |    {\n         |" + ((ComplexCGState)this.structs.top()).unparserStatements().mkString("\n") + "\n         |    }"));
        String arraySizeStatements = this.getOccursCount(elem);
        String prototypeFunctions = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("static void " + arrayName + "_parseSelf(" + C + " *instance, PState *pstate);\n         |static void " + arrayName + "_unparseSelf(const " + C + " *instance, UState *ustate);\n         |static size_t " + arrayName + "_getArraySize(const " + C + " *instance);"));
        String functions = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("static void\n         |" + arrayName + "_initERD(" + C + " *instance, InfosetBase *parent)\n         |{\n         |" + initERDStatements + "\n         |}\n         |\n         |static void\n         |" + arrayName + "_parseSelf(" + C + " *instance, PState *pstate)\n         |{\n         |" + parserStatements + "\n         |}\n         |\n         |static void\n         |" + arrayName + "_unparseSelf(const " + C + " *instance, UState *ustate)\n         |{\n         |" + unparserStatements + "\n         |}\n         |\n         |static size_t\n         |" + arrayName + "_getArraySize(const " + C + " *instance)\n         |{\n         |" + arraySizeStatements + "\n         |}\n         |"));
        this.prototypes.$plus$eq((Object)prototypeFunctions);
        this.finalImplementation.$plus$eq((Object)functions);
    }

    private String choiceDispatchField(ElementBase context) {
        String string;
        Choice choice;
        ModelGroup modelGroup = context.complexType().modelGroup();
        if (modelGroup instanceof Choice && (choice = (Choice)modelGroup).isDirectDispatch()) {
            String fieldAccess;
            String xml = StringOps$.MODULE$.filterNot$extension(Predef$.MODULE$.augmentString(choice.choiceDispatchKeyEv().expr().toBriefXML(choice.choiceDispatchKeyEv().expr().toBriefXML$default$1())), (Function1 & Serializable)_$1 -> RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)_$1))));
            String expr = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(xml), "'{xs:string(")), ")}'");
            string = fieldAccess = this.cStructFieldAccess(expr);
        } else {
            string = "";
        }
        String dispatchField = string;
        return dispatchField;
    }

    private StringBuilder buildName(SchemaComponent sc, StringBuilder sb) {
        SchemaComponent schemaComponent = sc;
        if (schemaComponent instanceof ElementBase) {
            ElementBase eb = (ElementBase)schemaComponent;
            v0 = sb.$plus$plus$eq(eb.namedQName().local()).$plus$eq((Object)BoxesRunTime.boxToCharacter((char)'_'));
        } else if (schemaComponent instanceof GlobalElementDecl) {
            GlobalElementDecl gd = (GlobalElementDecl)schemaComponent;
            v0 = sb.$plus$plus$eq(gd.namedQName().local()).$plus$eq((Object)BoxesRunTime.boxToCharacter((char)'_'));
        } else if (schemaComponent instanceof GlobalComplexTypeDef) {
            GlobalComplexTypeDef ct = (GlobalComplexTypeDef)schemaComponent;
            v0 = sb.$plus$plus$eq(ct.namedQName().local()).$plus$eq((Object)BoxesRunTime.boxToCharacter((char)'_'));
        } else {
            v0 = BoxedUnit.UNIT;
        }
        sc.optLexicalParent().foreach((Function1 & Serializable)_$2 -> this.buildName((SchemaComponent)_$2, sb));
        return sb;
    }

    private void makeLegalForC(StringBuilder sb) {
        LazyRef lazyRef = new LazyRef();
        Matcher matcher = Pattern.compile("^[^/:]+:").matcher((CharSequence)sb);
        if (matcher.lookingAt()) {
            sb.replace(matcher.start(), matcher.end(), "");
        }
        sb.indices().foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            if (!CodeGeneratorState.legalCharsForC$1(lazyRef).contains((Object)BoxesRunTime.boxToCharacter((char)sb.charAt(i)))) {
                sb.setCharAt(i, '_');
                return;
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    private String defineQNameInit(ElementBase context) {
        prefix = (String)context.namedQName().prefix().map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$4(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)()).getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$5(), ()Ljava/lang/String;)());
        local = context.namedQName().local();
        nsUri = context.namedQName().namespace().toStringOrNullIfNoNS();
        parentNsUri = (String)context.enclosingElements().headOption().map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$6(org.apache.daffodil.core.dsom.ElementBase ), (Lorg/apache/daffodil/core/dsom/ElementBase;)Ljava/lang/String;)()).getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$7(), ()Ljava/lang/String;)());
        if (nsUri == null) ** GOTO lbl-1000
        v0 = nsUri;
        var7_6 = parentNsUri;
        if (!(v0 != null ? v0.equals(var7_6) == false : var7_6 != null)) lbl-1000:
        // 2 sources

        {
            v1 = "NULL";
        } else {
            v1 = "\"" + nsUri + "\"";
        }
        ns = v1;
        qNameInit = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("    {\n         |        " + prefix + ", // namedQName.prefix\n         |        \"" + local + "\", // namedQName.local\n         |        " + ns + ", // namedQName.ns\n         |    },"));
        return qNameInit;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private NodeInfo.PrimType getPrimType(ElementBase e) {
        PrimTypeNode primType;
        NodeInfo.PrimType$.Boolean$ boolean$;
        long lengthInBits = this.getLengthInBits(e);
        NodeInfo.PrimType primType2 = (NodeInfo.PrimType)e.optPrimType().get();
        if (NodeInfo.PrimType$.Boolean$.MODULE$.equals(primType2)) {
            long l = lengthInBits;
            long n = l;
            if (n > 32L) throw e.SDE("Boolean lengths longer than 32 bits are not supported.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
            boolean$ = NodeInfo.PrimType$.Boolean$.MODULE$;
        } else if (NodeInfo.PrimType$.Double$.MODULE$.equals(primType2) || NodeInfo.PrimType$.Float$.MODULE$.equals(primType2)) {
            long l = lengthInBits;
            if (32L == l) {
                boolean$ = NodeInfo.PrimType$.Float$.MODULE$;
            } else {
                if (64L != l) throw e.SDE("Floating point lengths other than 32 or 64 bits are not supported.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                boolean$ = NodeInfo.PrimType$.Double$.MODULE$;
            }
        } else if (NodeInfo.PrimType$.HexBinary$.MODULE$.equals(primType2)) {
            boolean$ = NodeInfo.PrimType$.HexBinary$.MODULE$;
        } else if (NodeInfo.PrimType$.Byte$.MODULE$.equals(primType2) || NodeInfo.PrimType$.Short$.MODULE$.equals(primType2) || NodeInfo.PrimType$.Int$.MODULE$.equals(primType2) || NodeInfo.PrimType$.Long$.MODULE$.equals(primType2) || NodeInfo.PrimType$.Integer$.MODULE$.equals(primType2)) {
            long l = lengthInBits;
            long n = l;
            if (n <= 8L) {
                boolean$ = NodeInfo.PrimType$.Byte$.MODULE$;
            } else {
                long n2 = l;
                if (n2 <= 16L) {
                    boolean$ = NodeInfo.PrimType$.Short$.MODULE$;
                } else {
                    long n3 = l;
                    if (n3 <= 32L) {
                        boolean$ = NodeInfo.PrimType$.Int$.MODULE$;
                    } else {
                        long n4 = l;
                        if (n4 > 64L) throw e.SDE("Integer lengths longer than 64 bits are not supported.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                        boolean$ = NodeInfo.PrimType$.Long$.MODULE$;
                    }
                }
            }
        } else if (NodeInfo.PrimType$.UnsignedByte$.MODULE$.equals(primType2) || NodeInfo.PrimType$.UnsignedShort$.MODULE$.equals(primType2) || NodeInfo.PrimType$.UnsignedInt$.MODULE$.equals(primType2) || NodeInfo.PrimType$.UnsignedLong$.MODULE$.equals(primType2) || NodeInfo.PrimType$.NonNegativeInteger$.MODULE$.equals(primType2)) {
            long l = lengthInBits;
            long n = l;
            if (n <= 8L) {
                boolean$ = NodeInfo.PrimType$.UnsignedByte$.MODULE$;
            } else {
                long n5 = l;
                if (n5 <= 16L) {
                    boolean$ = NodeInfo.PrimType$.UnsignedShort$.MODULE$;
                } else {
                    long n6 = l;
                    if (n6 <= 32L) {
                        boolean$ = NodeInfo.PrimType$.UnsignedInt$.MODULE$;
                    } else {
                        long n7 = l;
                        if (n7 > 64L) throw e.SDE("Unsigned integer lengths longer than 64 bits are not supported.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                        boolean$ = NodeInfo.PrimType$.UnsignedLong$.MODULE$;
                    }
                }
            }
        } else {
            NodeInfo.PrimType p = primType2;
            throw e.SDE("PrimType %s is not supported in C code generator.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{p.toString()}));
        }
        PrimTypeNode primTypeNode = primType = (PrimTypeNode)boolean$;
        Object object = e.optPrimType().get();
        if (!(primTypeNode == null ? object != null : !primTypeNode.equals(object))) return primType;
        Object object2 = e.optPrimType().get();
        NodeInfo.PrimType$.Integer$ integer$ = NodeInfo.PrimType$.Integer$.MODULE$;
        if (!(object2 == null ? integer$ != null : !object2.equals(integer$))) return primType;
        Object object3 = e.optPrimType().get();
        NodeInfo.PrimType$.NonNegativeInteger$ nonNegativeInteger$ = NodeInfo.PrimType$.NonNegativeInteger$.MODULE$;
        if (!(object3 == null ? nonNegativeInteger$ != null : !object3.equals(nonNegativeInteger$))) return primType;
        e.SDW((WarnID)WarnID.IgnoreDFDLProperty$.MODULE$, "Ignoring PrimType %s, using %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{((NodeInfo.PrimType)e.optPrimType().get()).toString(), primType.toString()}));
        return primType;
    }

    /*
     * Unable to fully structure code
     */
    private int arrayMaxOccurs(ElementBase e) {
        block8: {
            block6: {
                block7: {
                    var3_2 = e.occursCountKind();
                    if (!OccursCountKind.Fixed$.MODULE$.equals(var3_2)) break block6;
                    if (e.maxOccurs() <= 1) break block7;
                    v0 = e.maxOccurs();
                    break block8;
                }
                if (e.maxOccurs() != 1) break block6;
                v0 = 0;
                break block8;
            }
            if (!OccursCountKind.Implicit$.MODULE$.equals(var3_2)) ** GOTO lbl-1000
            if (e.minOccurs() == 1 && e.maxOccurs() == 1) {
                v0 = 0;
            } else if (e.maxOccurs() > 0) {
                v0 = e.maxOccurs();
            } else if (OccursCountKind.Expression$.MODULE$.equals(var3_2) && e.maxOccurs() > 0) {
                v0 = e.maxOccurs();
            } else {
                throw e.SDE("occursCountKind %s minOccurs %d maxOccurs %d is not supported in C code generator", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{e.occursCountKind().toString(), BoxesRunTime.boxToInteger((int)e.minOccurs()), BoxesRunTime.boxToInteger((int)e.maxOccurs())}));
            }
        }
        arrayMaxOccurs = v0;
        return arrayMaxOccurs;
    }

    private String getOccursCount(ElementBase e) {
        Object object;
        OccursCountKind occursCountKind = e.occursCountKind();
        if (OccursCountKind.Fixed$.MODULE$.equals(occursCountKind)) {
            object = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("    UNUSED(instance);\n           |    return " + e.maxOccurs() + ";"));
        } else if (OccursCountKind.Expression$.MODULE$.equals(occursCountKind)) {
            String expr = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.filterNot$extension(Predef$.MODULE$.augmentString(e.occursCountExpr().prettyExpr()), (Function1 & Serializable)_$4 -> RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)_$4))))), "{")), "}")), "xs:long(")), ")");
            String fieldAccess = this.cStructFieldAccess(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(expr), "../"));
            object = fieldAccess.startsWith("instance") ? "    return " + fieldAccess + ";" : StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("    UNUSED(instance);\n             |    return " + fieldAccess + ";"));
        } else {
            throw e.SDE("getArraySize %s minOccurs %d maxOccurs %d is not supported in C code generator", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{e.occursCountKind().toString(), BoxesRunTime.boxToInteger((int)e.minOccurs()), BoxesRunTime.boxToInteger((int)e.maxOccurs())}));
        }
        String occursCount = object;
        return occursCount;
    }

    private String cStructFieldAccess(String expr) {
        String string;
        Regex localName = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("([\\p{L}_][\\p{L}:_\\-.0-9]*)"));
        String exprWithFields = localName.replaceAllIn((CharSequence)expr, (Function1 & Serializable)m -> {
            StringBuilder sb = new StringBuilder(m.group(1));
            this.makeLegalForC(sb);
            return sb.mkString();
        });
        if (exprWithFields.startsWith("/")) {
            String rootName = this.root().namedQName().local();
            String exprWORoot = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(exprWithFields), "/" + rootName + "/");
            String C = this.cStructName(this.root());
            string = "((" + C + " *)get_infoset(false))->" + exprWORoot;
        } else if (exprWithFields.startsWith("../")) {
            String afterUpDirs = Predef$.MODULE$.wrapRefArray((Object[])exprWithFields.split("\\.\\./")).mkString();
            String upDirs = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(exprWithFields), afterUpDirs);
            int nUpDirs = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(upDirs), '/').length;
            String C = ((ComplexCGState)this.structs.apply(nUpDirs)).C();
            String parents = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(upDirs.replace("../", "parent->")), "->");
            string = "((" + C + " *)instance->_base." + parents + ")->" + afterUpDirs;
        } else {
            string = "instance->" + exprWithFields;
        }
        String fieldAccess = string;
        String notation = fieldAccess.replace('/', '.');
        return notation;
    }

    private long getLengthInBits(ElementBase e) {
        Object object = e.optPrimType().get();
        NodeInfo.PrimType$.HexBinary$ hexBinary$ = NodeInfo.PrimType$.HexBinary$.MODULE$;
        if (!(object != null ? !object.equals(hexBinary$) : hexBinary$ != null)) {
            return 0L;
        }
        ElementBase SDEUsingMacrosMixin_this = e;
        boolean testThatWillThrowIfFalse$proxy1 = e.elementLengthInBitsEv().isConstant();
        if (!testThatWillThrowIfFalse$proxy1) {
            throw SDEUsingMacrosMixin_this.SDE("Runtime dfdl:length expressions are not supported.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        return ((MaybeJULong)e.elementLengthInBitsEv().constValue()).get();
    }

    private static final Set legalCharsForC$lzyINIT1$1(LazyRef legalCharsForC$lzy1$1) {
        Set set;
        LazyRef lazyRef = legalCharsForC$lzy1$1;
        synchronized (lazyRef) {
            set = (Set)(legalCharsForC$lzy1$1.initialized() ? legalCharsForC$lzy1$1.value() : legalCharsForC$lzy1$1.initialize((Object)((Set)((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{'_'}))).$plus$plus((IterableOnce)new RichChar(Predef$.MODULE$.charWrapper('a')).to((Object)BoxesRunTime.boxToCharacter((char)'z'))).$plus$plus((IterableOnce)new RichChar(Predef$.MODULE$.charWrapper('A')).to((Object)BoxesRunTime.boxToCharacter((char)'Z'))).$plus$plus((IterableOnce)new RichChar(Predef$.MODULE$.charWrapper('0')).to((Object)BoxesRunTime.boxToCharacter((char)'9'))))));
        }
        return set;
    }

    private static final Set legalCharsForC$1(LazyRef legalCharsForC$lzy1$2) {
        return (Set)(legalCharsForC$lzy1$2.initialized() ? legalCharsForC$lzy1$2.value() : CodeGeneratorState.legalCharsForC$lzyINIT1$1(legalCharsForC$lzy1$2));
    }

    private static final /* synthetic */ String $anonfun$4(String p) {
        return "\"" + p + "\"";
    }

    private static final String $anonfun$5() {
        return "NULL";
    }

    private static final /* synthetic */ String $anonfun$6(ElementBase _$3) {
        return _$3.namedQName().namespace().toStringOrNullIfNoNS();
    }

    private static final String $anonfun$7() {
        return "no-ns";
    }
}

