/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.ldap;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.directory.fortress.core.CfgRuntimeException;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.core.util.ResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LdapClientTrustStoreManager
implements X509TrustManager,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String CLS_NM = LdapClientTrustStoreManager.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLS_NM);
    private final boolean isExamineValidityDates;
    private final char[] trustStorePw;
    private final String trustStoreFile;
    private final String trustStoreFormat;

    public LdapClientTrustStoreManager(String trustStoreFile, char[] trustStorePw, String trustStoreFormat, boolean isExamineValidity) {
        if (trustStoreFile == null) {
            throw new CfgRuntimeException(136, "LdapClientTrustStoreManager constructor : input file name is null");
        }
        this.trustStoreFile = trustStoreFile;
        this.trustStorePw = (char[])trustStorePw.clone();
        this.isExamineValidityDates = isExamineValidity;
        this.trustStoreFormat = trustStoreFormat == null ? KeyStore.getDefaultType() : trustStoreFormat;
    }

    @Override
    public synchronized void checkClientTrusted(X509Certificate[] x509Chain, String authNType) throws CertificateException {
        for (X509TrustManager trustMgr : this.getTrustManagers(x509Chain)) {
            trustMgr.checkClientTrusted(x509Chain, authNType);
        }
    }

    @Override
    public synchronized void checkServerTrusted(X509Certificate[] x509Chain, String authNType) throws CertificateException {
        for (X509TrustManager trustManager : this.getTrustManagers(x509Chain)) {
            trustManager.checkServerTrusted(x509Chain, authNType);
        }
    }

    @Override
    public synchronized X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    private synchronized X509TrustManager[] getTrustManagers(X509Certificate[] x509Chain) throws CertificateException {
        if (!Config.getInstance().getBoolean("trust.store.onclasspath", true)) {
            LOG.debug(CLS_NM + ".getTrustManager on filepath");
            return this.getTrustManagersOnFilepath(x509Chain);
        }
        LOG.debug(CLS_NM + ".getTrustManager on classpath");
        return this.getTrustManagersOnClasspath(x509Chain);
    }

    private synchronized X509TrustManager[] getTrustManagersOnClasspath(X509Certificate[] x509Chain) throws CertificateException {
        InputStream trustStoreInputStream;
        if (this.isExamineValidityDates) {
            Date currentDate = new Date();
            for (X509Certificate x509Cert : x509Chain) {
                x509Cert.checkValidity(currentDate);
            }
        }
        if ((trustStoreInputStream = this.getTrustStoreInputStream()) == null) {
            throw new CertificateException("LdapClientTrustStoreManager.getTrustManagers : file not found");
        }
        try {
            trustStoreInputStream.close();
        }
        catch (IOException e) {
            LOG.warn("LdapClientTrustStoreManager.getTrustManagers on input stream close operation caught IOException={}", (Object)e.getMessage());
        }
        return this.loadTrustManagers(this.getTrustStore());
    }

    private synchronized X509TrustManager[] getTrustManagersOnFilepath(X509Certificate[] x509Chain) throws CertificateException {
        File trustStoreFile;
        if (this.isExamineValidityDates) {
            Date currentDate = new Date();
            for (X509Certificate x509Cert : x509Chain) {
                x509Cert.checkValidity(currentDate);
            }
        }
        if (!(trustStoreFile = new File(this.trustStoreFile)).exists()) {
            throw new CertificateException("FortressTrustStoreManager.getTrustManagers : file not found");
        }
        return this.loadTrustManagers(this.getTrustStore());
    }

    private X509TrustManager[] loadTrustManagers(KeyStore trustStore) throws CertificateException {
        X509TrustManager[] x509TrustManagers;
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
            x509TrustManagers = new X509TrustManager[trustManagers.length];
            for (int i = 0; i < trustManagers.length; ++i) {
                x509TrustManagers[i] = (X509TrustManager)trustManagers[i];
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertificateException("LdapClientTrustStoreManager.loadTrustManagers caught NoSuchAlgorithmException", e);
        }
        catch (KeyStoreException e) {
            throw new CertificateException("LdapClientTrustStoreManager.loadTrustManagers caught KeyStoreException", e);
        }
        return x509TrustManagers;
    }

    private KeyStore getTrustStore() throws CertificateException {
        KeyStore trustStore;
        try {
            trustStore = KeyStore.getInstance(this.trustStoreFormat);
        }
        catch (KeyStoreException e) {
            throw new CertificateException("LdapClientTrustStoreManager.getTrustManagers caught KeyStoreException", e);
        }
        InputStream trustStoreInputStream = null;
        try {
            trustStoreInputStream = this.getTrustStoreInputStream();
            trustStore.load(trustStoreInputStream, this.trustStorePw);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertificateException("LdapClientTrustStoreManager.getTrustManagers caught NoSuchAlgorithmException", e);
        }
        catch (IOException e) {
            throw new CertificateException("LdapClientTrustStoreManager.getTrustManagers caught KeyStoreException", e);
        }
        finally {
            if (trustStoreInputStream != null) {
                try {
                    trustStoreInputStream.close();
                }
                catch (IOException e) {
                    LOG.warn("LdapClientTrustStoreManager.getTrustStore finally block on input stream close operation caught IOException={}", (Object)e.getMessage());
                }
            }
        }
        return trustStore;
    }

    private InputStream getTrustStoreInputStream() throws CertificateException {
        InputStream result = ResourceUtil.getInputStream(this.trustStoreFile);
        if (null == result) {
            throw new CertificateException("LdapClientTrustStoreManager.getTrustStoreInputStream file does not exist on fortress classpath");
        }
        return result;
    }
}

