/*
 * Decompiled with CFR 0.152.
 */
package jdbm.helper;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import jdbm.helper.CacheEvictionException;
import jdbm.helper.EntryIO;
import jdbm.helper.ExplicitList;
import jdbm.helper.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LRUCache<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(LRUCache.class);
    private List<CacheEntry>[] buckets;
    private Lock[] latches;
    private final int numBuckets;
    private static final int LOG_BUCKET_PER_LATCH = 0;
    private static final int NUM_LRUS = 16;
    private static final int MIN_ENTRIES = 1024;
    private static final long MAX_WRITE_SLEEP_TIME = 600000L;
    LRU[] lrus;
    Random lruRandomizer = new Random();
    private AtomicInteger numEntries;
    private final int maxEntries;
    private final EntryIO<K, V> entryIO;
    private long minReadVersion;
    private long cacheGets;
    private long cacheMisses;
    private long cachePuts;
    private long cachePutSleeps;

    public LRUCache(EntryIO<K, V> entryIO, int cacheSize) {
        int idx;
        int numHashBuckets;
        this.entryIO = entryIO;
        if (cacheSize < 1024) {
            cacheSize = 1024;
        }
        this.maxEntries = cacheSize;
        for (numHashBuckets = 1024; numHashBuckets < this.maxEntries; numHashBuckets <<= 1) {
        }
        this.numBuckets = numHashBuckets > this.maxEntries ? numHashBuckets >> 1 : numHashBuckets;
        this.buckets = new LinkedList[this.numBuckets];
        for (idx = 0; idx < this.numBuckets; ++idx) {
            this.buckets[idx] = new LinkedList<CacheEntry>();
        }
        int numLatches = this.numBuckets >> 0;
        this.latches = new Lock[numLatches];
        for (idx = 0; idx < numLatches; ++idx) {
            this.latches[idx] = new ReentrantLock();
        }
        this.lrus = new LRU[16];
        for (idx = 0; idx < 16; ++idx) {
            this.lrus[idx] = new LRU();
        }
        this.numEntries = new AtomicInteger(0);
    }

    public void advanceMinReadVersion(long minVersion) {
        this.minReadVersion = minVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void put(K key, V value, long newVersion, Serializer serializer, boolean neverReplace) throws IOException, CacheEvictionException {
        hashValue = this.hash(key);
        hashIndex = hashValue & this.numBuckets - 1;
        latchIndex = hashIndex >> 0;
        sleepInterval = 100L;
        totalSleepTime = 0L;
        ++this.cachePuts;
        while (true) {
            block21: {
                this.latches[latchIndex].lock();
                entryExists = false;
                sleepForFreeEntry = false;
                it = this.buckets[hashIndex].listIterator();
                entry = null;
                while (it.hasNext()) {
                    entry = (CacheEntry)it.next();
                    if (!entry.getKey().equals(key)) continue;
                    entryExists = true;
                    break;
                }
                try {
                    block22: {
                        if (!entryExists) break block22;
                        switch (1.$SwitchMap$jdbm$helper$LRUCache$EntryState[entry.getState().ordinal()]) {
                            case 1: {
                                if (entry.isCurrentVersion()) ** GOTO lbl40
                                if (entry.isNeverReplace()) {
                                    throw new IllegalStateException(" Non current entry should not have neverReplace set " + entry);
                                }
                                entry.setNeverReplace();
                                newEntry = null;
                                try {
                                    newEntry = this.findNewEntry(key, hashIndex >> 0);
                                }
                                finally {
                                    entry.clearNeverReplace();
                                }
                                this.buckets[hashIndex].remove(entry);
                                newEntry.getVersionsLink().splice(entry.getVersionsLink());
                                this.buckets[hashIndex].add(newEntry);
                                entry = newEntry;
                                this.doRead(entry, this.latches[latchIndex], serializer);
lbl40:
                                // 2 sources

                                this.putNewVersion(entry, key, value, newVersion, hashIndex, this.latches[latchIndex], serializer, neverReplace);
                                break block21;
                            }
                            case 2: {
                                this.doWaitForStateChange(entry, this.latches[latchIndex]);
                                if (entry.getState() == EntryState.ENTRY_READY) {
                                    this.putNewVersion(entry, key, value, newVersion, hashIndex, this.latches[latchIndex], serializer, neverReplace);
                                    break block21;
                                }
                                LRUCache.LOG.warn("Entry with key {} is at intial state after waiting for IO", entry.getKey());
                            }
                            case 3: {
                                LRUCache.LOG.warn("Entry with key {} is at intial while trying to read from it", entry.getKey());
                                this.doRead(entry, this.latches[latchIndex], serializer);
                                this.putNewVersion(entry, key, value, newVersion, hashIndex, this.latches[latchIndex], serializer, neverReplace);
                                break block21;
                            }
                            default: {
                                throw new IllegalStateException("Unknown cache entry state: " + entry);
                            }
                        }
                    }
                    entry = this.findNewEntry(key, latchIndex);
                    this.buckets[hashIndex].add(entry);
                    this.doRead(entry, this.latches[latchIndex], serializer);
                    this.putNewVersion(entry, key, value, newVersion, hashIndex, this.latches[latchIndex], serializer, neverReplace);
                }
                catch (CacheEvictionException e) {
                    v0 = sleepForFreeEntry = totalSleepTime < 600000L;
                    if (!sleepForFreeEntry) {
                        System.out.println(" NO cache entry for write " + totalSleepTime);
                        throw e;
                    }
                }
                finally {
                    this.latches[latchIndex].unlock();
                }
            }
            if (!sleepForFreeEntry) break;
            try {
                Thread.sleep(sleepInterval);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            totalSleepTime += sleepInterval;
        }
        if (totalSleepTime != 0L) {
            ++this.cachePutSleeps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public V get(K key, long version, Serializer serializer, boolean neverReplace) throws IOException {
        block21: {
            hashValue = this.hash(key);
            hashIndex = hashValue & this.numBuckets - 1;
            latchIndex = hashIndex >> 0;
            value = null;
            ++this.cacheGets;
            this.latches[latchIndex].lock();
            chainExists = false;
            it = this.buckets[hashIndex].listIterator();
            entry = null;
            while (it.hasNext()) {
                entry = (CacheEntry)it.next();
                if (!entry.getKey().equals(key)) continue;
                chainExists = true;
                break;
            }
            try {
                block22: {
                    if (!chainExists) break block22;
                    switch (1.$SwitchMap$jdbm$helper$LRUCache$EntryState[entry.getState().ordinal()]) {
                        case 1: {
                            if (entry.isCurrentVersion()) ** GOTO lbl43
                            value = this.searchChainForVersion(entry, version, neverReplace);
                            if (value != null) {
                                break block21;
                            }
                            if (neverReplace) {
                                break block21;
                            }
                            ++this.cacheMisses;
                            if (entry.isNeverReplace()) {
                                throw new IllegalStateException("Non Current Entry has neverReplace set to true:" + entry);
                            }
                            entry.setNeverReplace();
                            newEntry = null;
                            try {
                                newEntry = this.findNewEntry(key, hashIndex >> 0);
                            }
                            finally {
                                entry.clearNeverReplace();
                            }
                            this.buckets[hashIndex].remove(entry);
                            newEntry.getVersionsLink().splice(entry.getVersionsLink());
                            this.buckets[hashIndex].add(newEntry);
                            entry = newEntry;
                            this.doRead(entry, this.latches[latchIndex], serializer);
                        }
lbl43:
                        // 3 sources

                        case 4: {
                            value = this.searchChainForVersion(entry, version, neverReplace);
                            break block21;
                        }
                        case 2: {
                            this.doWaitForStateChange(entry, this.latches[latchIndex]);
                            if (entry.getState() == EntryState.ENTRY_READY) {
                                value = this.searchChainForVersion(entry, version, neverReplace);
                                break block21;
                            }
                            LRUCache.LOG.warn("Entry with key {} is at intial state after waiting for IO", entry.getKey());
                        }
                        case 3: {
                            LRUCache.LOG.warn("Entry with key {} is at intial while trying to read from it", entry.getKey());
                            if (neverReplace) {
                            } else {
                                ++this.cacheMisses;
                                this.doRead(entry, this.latches[latchIndex], serializer);
                                value = this.searchChainForVersion(entry, version, neverReplace);
                            }
                            break block21;
                        }
                        default: {
                            throw new IllegalStateException("Unknown cache entry state: " + entry);
                        }
                    }
                }
                ++this.cacheMisses;
                entry = this.findNewEntry(key, latchIndex);
                this.buckets[hashIndex].add(entry);
                this.doRead(entry, this.latches[latchIndex], serializer);
                value = this.searchChainForVersion(entry, version, neverReplace);
            }
            catch (CacheEvictionException e) {
                var14_15 = this.entryIO.read(key, serializer);
                return var14_15;
            }
            finally {
                this.latches[latchIndex].unlock();
            }
        }
        return value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LRUCache: ");
        sb.append("(numEntries:").append(this.numEntries);
        sb.append(",maxEntries:").append(this.maxEntries);
        sb.append(",cacheGets:").append(this.cacheGets);
        sb.append(",cacheMisses:").append(this.cacheMisses);
        sb.append(",cachePuts:").append(this.cachePuts);
        sb.append(",cachePutSleeps:").append(this.cachePutSleeps);
        sb.append(")\n");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putNewVersion(CacheEntry entry, K key, V value, long newVersion, int hashIndex, Lock latch, Serializer serializer, boolean neverReplace) throws IOException, CacheEvictionException {
        if (entry.getStartVersion() != newVersion) {
            boolean resetNeverReplace = true;
            if (entry.isNeverReplace()) {
                resetNeverReplace = false;
            }
            entry.setNeverReplace();
            CacheEntry newEntry = null;
            try {
                newEntry = this.findNewEntry(key, hashIndex >> 0);
            }
            finally {
                if (resetNeverReplace) {
                    entry.clearNeverReplace();
                }
            }
            newEntry.setAsCurrentVersion(value, newVersion);
            this.buckets[hashIndex].remove(entry);
            entry.setAsSnapshotVersion(newVersion);
            newEntry.getVersionsLink().splice(entry.getVersionsLink());
            this.buckets[hashIndex].add(newEntry);
            entry = newEntry;
        } else {
            if (!entry.isCurrentVersion()) {
                throw new IllegalStateException("Entry not at expected version: " + entry);
            }
            entry.setAsCurrentVersion(value, newVersion);
        }
        if (neverReplace) {
            entry.setNeverReplace();
        }
        entry.setState(EntryState.ENTRY_WRITING);
        latch.unlock();
        try {
            this.entryIO.write(key, value, serializer);
        }
        catch (IOException e) {
            latch.lock();
            entry.setState(EntryState.ENTRY_INITIAL);
            entry.clearNeverReplace();
            if (entry.anyWaiters()) {
                entry.getStateCondition(latch).notifyAll();
            } else {
                LRU lru = entry.getLru();
                lru.getLock().lock();
                lru.moveToTail(entry);
                lru.getLock().unlock();
            }
            latch.unlock();
            throw e;
        }
        latch.lock();
        entry.setState(EntryState.ENTRY_READY);
    }

    private V searchChainForVersion(CacheEntry head, long version, boolean neverReplace) {
        ExplicitList.Link<CacheEntry> curLink = head.getVersionsLink();
        boolean mustFind = true;
        long curStartVersion = 0L;
        V value = null;
        if (head.getState() != EntryState.ENTRY_READY || !head.isCurrentVersion() || neverReplace) {
            mustFind = false;
        }
        do {
            CacheEntry curEntry;
            if ((curEntry = curLink.getElement()).getState() != EntryState.ENTRY_READY) {
                if (curEntry != head) {
                    throw new IllegalStateException("Unexpected state for entry: " + curEntry);
                }
                curLink = curLink.getNext();
                continue;
            }
            if (curStartVersion != 0L && curEntry.getEndVersion() > curStartVersion) {
                throw new IllegalStateException("Unexpected version number for entry. curStartVersion: " + curStartVersion + " entry: " + curEntry);
            }
            curStartVersion = curEntry.getStartVersion();
            if (!curEntry.canReadFrom(version)) {
                curLink = curLink.getNext();
                continue;
            }
            if (curEntry.isCurrentVersion()) {
                LRU lru = curEntry.getLru();
                lru.getLock().lock();
                lru.touch(curEntry);
                lru.getLock().unlock();
            }
            value = curEntry.getValue();
            break;
        } while (curLink != head.getVersionsLink());
        if (value == null && mustFind) {
            throw new IllegalStateException("Traversed all versions and could not find cache entry");
        }
        return value;
    }

    private void doWaitForStateChange(CacheEntry entry, Lock latch) {
        EntryState curState = entry.getState();
        Condition cond = entry.getStateCondition(latch);
        entry.bumpWaiters();
        do {
            cond.awaitUninterruptibly();
        } while (curState == entry.getState());
        entry.decrementWaiters();
    }

    private void doRead(CacheEntry entry, Lock latch, Serializer serializer) throws IOException {
        Object value = null;
        entry.setState(EntryState.ENTRY_READING);
        latch.unlock();
        try {
            value = this.entryIO.read(entry.getKey(), serializer);
        }
        catch (IOException e) {
            latch.lock();
            entry.setState(EntryState.ENTRY_INITIAL);
            if (entry.anyWaiters()) {
                entry.getStateCondition(latch).notifyAll();
            } else {
                LRU lru = entry.getLru();
                lru.getLock().lock();
                lru.moveToTail(entry);
                lru.getLock().unlock();
            }
            latch.unlock();
            throw e;
        }
        latch.lock();
        ExplicitList.Link<CacheEntry> nextLink = entry.getVersionsLink().getNext();
        long startVersion = entry.getVersionsLink().isUnLinked() ? 0L : nextLink.getElement().getEndVersion();
        entry.setAsCurrentVersion(value, startVersion);
        if (entry.anyWaiters()) {
            entry.getStateCondition(latch).signalAll();
        }
    }

    private CacheEntry findNewEntry(K key, int latchIndex) throws CacheEvictionException {
        int index = this.lruRandomizer.nextInt(16);
        boolean lruLocked = false;
        if (this.numEntries.get() < this.maxEntries) {
            this.numEntries.incrementAndGet();
            CacheEntry newEntry = new CacheEntry(index);
            LRU lru = this.lrus[index];
            newEntry.initialize(key);
            lru.getLock().lock();
            lru.addToLRU(newEntry);
            lru.getLock().unlock();
            return newEntry;
        }
        CacheEntry victimEntry = null;
        LRU lru = null;
        int curIndex = 0;
        for (int id = 0; id < 16; ++id) {
            curIndex = (index + id) % 16;
            lru = this.lrus[curIndex];
            if (!lru.getLock().tryLock()) continue;
            lruLocked = true;
            break;
        }
        if (!lruLocked) {
            curIndex = index;
            lru = this.lrus[curIndex];
            lru.getLock().lock();
        }
        if ((victimEntry = lru.findVictim(latchIndex)) == null) {
            lru.getLock().unlock();
            LOG.warn("Cache eviction failure: " + this.minReadVersion);
            throw new CacheEvictionException(null);
        }
        victimEntry.initialize(key);
        lru.getLock().unlock();
        return victimEntry;
    }

    private int hash(K key) {
        int h = key.hashCode();
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    private class LRU {
        private ExplicitList<CacheEntry> mostRecentVersions = new ExplicitList();
        private ExplicitList<CacheEntry> snapshotVersions = new ExplicitList();
        private Lock lock = new ReentrantLock();
        private int numSnapshotsCreated;

        private LRU() {
        }

        public Lock getLock() {
            return this.lock;
        }

        public void addToLRU(CacheEntry entry) {
            this.mostRecentVersions.addFirst(entry.getLruLink());
        }

        public void addToSnapshots(CacheEntry entry) {
            this.mostRecentVersions.remove(entry.getLruLink());
            this.snapshotVersions.addLast(entry.getLruLink());
            ++this.numSnapshotsCreated;
        }

        public void moveToTail(CacheEntry entry) {
            this.mostRecentVersions.remove(entry.getLruLink());
            this.mostRecentVersions.addFirst(entry.getLruLink());
        }

        public void touch(CacheEntry entry) {
            this.mostRecentVersions.remove(entry.getLruLink());
            this.mostRecentVersions.addLast(entry.getLruLink());
        }

        public CacheEntry findVictim(int latchIndex) {
            int victimLatchIndex;
            int victimBucketIndex;
            CacheEntry victimEntry = null;
            ExplicitList.Link<CacheEntry> curLink = this.snapshotVersions.begin();
            while (curLink != this.snapshotVersions.end() && (victimEntry = curLink.getElement()).getEndVersion() <= LRUCache.this.minReadVersion) {
                if (victimEntry.getKey() == null) {
                    throw new IllegalStateException("Snapshot victimEntry doesnt have key set:" + victimEntry);
                }
                if (victimEntry.isNeverReplace()) {
                    curLink = curLink.getNext();
                    continue;
                }
                victimBucketIndex = victimEntry.getHashIndex();
                victimLatchIndex = victimBucketIndex >> 0;
                if (latchIndex != victimLatchIndex && !LRUCache.this.latches[victimLatchIndex].tryLock()) {
                    curLink = curLink.getNext();
                    continue;
                }
                if (!victimEntry.isEntryFreeable()) {
                    throw new IllegalStateException("Snapshot victimEntry is not freeable:" + victimEntry);
                }
                int hashChainIndex = LRUCache.this.buckets[victimEntry.getHashIndex()].indexOf(victimEntry);
                if (hashChainIndex != -1) {
                    LRUCache.this.buckets[victimEntry.getHashIndex()].remove(hashChainIndex);
                    if (victimEntry.getVersionsLink().isLinked()) {
                        ExplicitList.Link<CacheEntry> nextLink = victimEntry.getVersionsLink().getNext();
                        victimEntry.getVersionsLink().remove();
                        CacheEntry newEntry = nextLink.getElement();
                        LRUCache.this.buckets[newEntry.getHashIndex()].add(newEntry);
                    }
                } else if (victimEntry.getVersionsLink().isLinked()) {
                    victimEntry.getVersionsLink().remove();
                }
                if (latchIndex != victimLatchIndex) {
                    LRUCache.this.latches[victimLatchIndex].unlock();
                }
                this.snapshotVersions.remove(victimEntry.getLruLink());
                this.mostRecentVersions.addLast(victimEntry.getLruLink());
                return victimEntry;
            }
            curLink = this.mostRecentVersions.begin();
            while (curLink != this.mostRecentVersions.end()) {
                victimEntry = curLink.getElement();
                if (!victimEntry.isEntryFreeable()) {
                    curLink = curLink.getNext();
                    continue;
                }
                victimBucketIndex = victimEntry.getHashIndex();
                victimLatchIndex = victimBucketIndex >> 0;
                if (latchIndex != victimLatchIndex && !LRUCache.this.latches[victimLatchIndex].tryLock()) {
                    curLink = curLink.getNext();
                    continue;
                }
                if (!victimEntry.isEntryFreeable()) {
                    if (latchIndex != victimLatchIndex) {
                        LRUCache.this.latches[victimLatchIndex].unlock();
                    }
                    curLink = curLink.getNext();
                    continue;
                }
                LRUCache.this.buckets[victimEntry.getHashIndex()].remove(victimEntry);
                if (victimEntry.getVersionsLink().isLinked()) {
                    ExplicitList.Link<CacheEntry> nextLink = victimEntry.getVersionsLink().getNext();
                    victimEntry.getVersionsLink().remove();
                    CacheEntry newEntry = nextLink.getElement();
                    LRUCache.this.buckets[newEntry.getHashIndex()].add(newEntry);
                }
                if (latchIndex != victimLatchIndex) {
                    LRUCache.this.latches[victimLatchIndex].unlock();
                }
                this.touch(victimEntry);
                return victimEntry;
            }
            return null;
        }
    }

    private class CacheEntry {
        private K key;
        private V value;
        private long startVersion;
        private long endVersion;
        private int hashIndex;
        private Condition stateCondition;
        private int numWaiters;
        private EntryState state;
        private ExplicitList.Link<CacheEntry> versionsLink = new ExplicitList.Link<CacheEntry>(this);
        private ExplicitList.Link<CacheEntry> lruLink = new ExplicitList.Link<CacheEntry>(this);
        int lruid;
        boolean neverReplace;

        public CacheEntry(int lruid) {
            this.lruid = lruid;
        }

        public void initialize(K key) {
            this.key = key;
            this.value = null;
            this.startVersion = 0L;
            this.endVersion = Long.MAX_VALUE;
            this.stateCondition = null;
            if (this.numWaiters != 0) {
                throw new IllegalStateException("Numwaiters is not zero when entry is newly initialized: " + this);
            }
            this.state = EntryState.ENTRY_INITIAL;
            if (!this.versionsLink.isUnLinked()) {
                throw new IllegalStateException("Versions link is still linked when entry is initialized");
            }
            this.hashIndex = LRUCache.this.hash(key) & LRUCache.this.numBuckets - 1;
            if (this.neverReplace) {
                throw new IllegalStateException("Neverreplace is true when entry is newly intialized:" + this);
            }
        }

        public void setNeverReplace() {
            this.neverReplace = true;
        }

        public void clearNeverReplace() {
            this.neverReplace = false;
        }

        public boolean isNeverReplace() {
            return this.neverReplace;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public int getHashIndex() {
            return this.hashIndex;
        }

        public LRU getLru() {
            return LRUCache.this.lrus[this.lruid];
        }

        public Condition getStateCondition(Lock lock) {
            if (this.stateCondition == null) {
                this.stateCondition = lock.newCondition();
            }
            return this.stateCondition;
        }

        public void bumpWaiters() {
            ++this.numWaiters;
        }

        public void decrementWaiters() {
            if (this.numWaiters <= 0) {
                throw new IllegalStateException("Unexpected num waiters for entry:" + this);
            }
            --this.numWaiters;
        }

        public boolean anyWaiters() {
            return this.numWaiters > 0;
        }

        public long getEndVersion() {
            return this.endVersion;
        }

        public long getStartVersion() {
            return this.startVersion;
        }

        public boolean isCurrentVersion() {
            return this.endVersion == Long.MAX_VALUE;
        }

        public boolean canReadFrom(long readVersion) {
            return readVersion >= this.startVersion && readVersion < this.endVersion;
        }

        public EntryState getState() {
            return this.state;
        }

        public void setState(EntryState newState) {
            this.state = newState;
        }

        public ExplicitList.Link<CacheEntry> getVersionsLink() {
            return this.versionsLink;
        }

        public ExplicitList.Link<CacheEntry> getLruLink() {
            return this.lruLink;
        }

        public void setAsCurrentVersion(V newValue, long startVersion) {
            this.startVersion = startVersion;
            this.endVersion = Long.MAX_VALUE;
            this.value = newValue;
            this.state = EntryState.ENTRY_READY;
        }

        public void setAsSnapshotVersion(long newEndVersion) {
            this.clearNeverReplace();
            LRU lru = this.getLru();
            lru.getLock().lock();
            this.endVersion = newEndVersion;
            lru.addToSnapshots(this);
            lru.getLock().unlock();
        }

        public boolean isEntryFreeable() {
            return this.state != EntryState.ENTRY_READING && this.numWaiters == 0 && this.state != EntryState.ENTRY_WRITING && !this.neverReplace;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Entry: ");
            sb.append("(state: ").append((Object)this.state);
            sb.append(",numWaiters:").append(this.numWaiters);
            sb.append(",startVersion:").append(this.startVersion);
            sb.append(",endVersion:").append(this.endVersion);
            sb.append(",key:").append(this.key);
            sb.append(",value:").append(this.value).append(")");
            sb.append("\n");
            return sb.toString();
        }
    }

    private static enum EntryState {
        ENTRY_INITIAL,
        ENTRY_READING,
        ENTRY_WRITING,
        ENTRY_READY;

    }
}

