/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.column;

import java.util.Map;
import java.util.Set;
import org.apache.empire.commons.ArrayMap;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBExpr;
import org.apache.empire.db.DBSQLBuilder;
import org.apache.empire.db.expr.column.DBCaseExpr;
import org.apache.empire.exceptions.InvalidArgumentException;

public class DBCaseMapExpr
extends DBCaseExpr {
    private final DBColumnExpr caseExpr;
    private final Map<Object, Object> valueMap;
    private final Object elseValue;

    public DBCaseMapExpr(DBColumnExpr caseExpr, Map<? extends Object, ? extends Object> valueMap, Object elseValue) {
        super(caseExpr);
        if (valueMap == null || valueMap.isEmpty() && this.isNull(elseValue)) {
            throw new InvalidArgumentException("valueMap", valueMap);
        }
        this.caseExpr = caseExpr;
        this.valueMap = valueMap;
        this.elseValue = elseValue;
        this.init(valueMap, elseValue);
    }

    public DBCaseMapExpr(DBColumnExpr caseExpr, Object cmpVal, Object trueValue, Object elseValue) {
        super(caseExpr);
        if (this.isNull(trueValue) && this.isNull(elseValue)) {
            throw new InvalidArgumentException("colExpr", caseExpr);
        }
        this.caseExpr = caseExpr;
        this.valueMap = new ArrayMap<Object, Object>(1);
        this.valueMap.put(cmpVal, trueValue);
        this.elseValue = elseValue;
        this.init(this.valueMap, elseValue);
    }

    public DBCaseMapExpr(DBColumnExpr caseExpr, Object cmpVal1, Object trueValue1, Object cmpVal2, Object trueValue2, Object elseValue) {
        super(caseExpr);
        if (this.isNull(trueValue1) && this.isNull(trueValue2) && this.isNull(elseValue)) {
            throw new InvalidArgumentException("colExpr", caseExpr);
        }
        this.caseExpr = caseExpr;
        this.valueMap = new ArrayMap<Object, Object>(2);
        this.valueMap.put(cmpVal1, trueValue1);
        this.valueMap.put(cmpVal2, trueValue2);
        this.elseValue = elseValue;
        this.init(this.valueMap, elseValue);
    }

    @Override
    public String getName() {
        return "CASE_" + this.caseExpr.getName();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DBCaseMapExpr) {
            DBCaseMapExpr otherCase = (DBCaseMapExpr)other;
            if (!this.caseExpr.equals(otherCase.caseExpr)) {
                return false;
            }
        }
        return false;
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
        this.caseExpr.addReferencedColumns(list);
        for (Map.Entry<Object, Object> e : this.valueMap.entrySet()) {
            if (e.getKey() instanceof DBExpr) {
                ((DBExpr)e.getKey()).addReferencedColumns(list);
            }
            if (!(e.getValue() instanceof DBExpr)) continue;
            ((DBExpr)e.getValue()).addReferencedColumns(list);
        }
        if (this.elseValue instanceof DBExpr) {
            ((DBColumnExpr)this.elseValue).addReferencedColumns(list);
        }
    }

    @Override
    public void addSQL(DBSQLBuilder sql, long context) {
        context &= 0xFFFFFFFFFFFFFFF7L;
        if (!this.valueMap.isEmpty()) {
            sql.append("CASE ");
            this.caseExpr.addSQL(sql, context);
            for (Map.Entry<Object, Object> entry : this.valueMap.entrySet()) {
                sql.append(" WHEN ");
                sql.appendValue(this.caseExpr.getDataType(), entry.getKey(), context);
                sql.append(" THEN ");
                sql.appendValue(this.getDataType(), entry.getValue(), context);
            }
            sql.append(" ELSE ");
        }
        sql.appendValue(this.getDataType(), this.elseValue, context);
        if (!this.valueMap.isEmpty()) {
            sql.append(" END");
        }
    }
}

