/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser;

import com.github.javaparser.JavaToken;
import com.github.javaparser.Token;
import com.github.javaparser.TokenRange;
import com.github.javaparser.TokenTypes;
import com.github.javaparser.ast.comments.BlockComment;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.comments.LineComment;
import com.github.javaparser.ast.comments.MarkdownComment;
import com.github.javaparser.ast.comments.TraditionalJavadocComment;
import java.util.ArrayDeque;

abstract class GeneratedJavaParserTokenManagerBase {
    GeneratedJavaParserTokenManagerBase() {
    }

    private static TokenRange tokenRange(Token token) {
        JavaToken javaToken = token.javaToken;
        return new TokenRange(javaToken, javaToken);
    }

    static boolean isMarkdownCommentLineCandidate(Token token) {
        return token.kind == 5 && token.image.startsWith("///");
    }

    static MarkdownComment createMarkdownCommentFromTokenList(ArrayDeque<Token> tokens) {
        if (tokens.isEmpty()) {
            throw new IllegalArgumentException("Cannot create markdown comment from empty token list");
        }
        while (!tokens.isEmpty() && TokenTypes.isWhitespace(tokens.peekLast().kind)) {
            Token lastToken = tokens.removeLast();
            if (TokenTypes.isComment(lastToken.kind)) {
                tokens.addLast(lastToken);
                break;
            }
            if (tokens.isEmpty()) {
                throw new IllegalArgumentException("createMarkdownCommentFromTokenList may not be called with a token list consisting only of whitespace tokens");
            }
            if (!TokenTypes.isEndOfLineToken(lastToken.kind) || !TokenTypes.isComment(tokens.peekLast().kind)) continue;
            break;
        }
        TokenRange range = new TokenRange(tokens.peekFirst().javaToken, tokens.peekLast().javaToken);
        StringBuilder contentBuilder = new StringBuilder();
        for (Token token : tokens) {
            contentBuilder.append(token.image);
        }
        return new MarkdownComment(range, contentBuilder.toString());
    }

    static Comment createCommentFromToken(Token token) {
        String commentText = token.image;
        if (token.kind == 8) {
            return new TraditionalJavadocComment(GeneratedJavaParserTokenManagerBase.tokenRange(token), commentText.substring(3, commentText.length() - 2));
        }
        if (token.kind == 9) {
            return new BlockComment(GeneratedJavaParserTokenManagerBase.tokenRange(token), commentText.substring(2, commentText.length() - 2));
        }
        if (token.kind == 5) {
            return new LineComment(GeneratedJavaParserTokenManagerBase.tokenRange(token), commentText.substring(2));
        }
        throw new AssertionError((Object)"Unexpectedly got passed a non-comment token.");
    }
}

