/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjaropenbeans;

import groovyjarjaropenbeans.Encoder;
import groovyjarjaropenbeans.Expression;

public abstract class PersistenceDelegate {
    protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder enc) {
        Class<?> c = type.getSuperclass();
        if (null != c) {
            PersistenceDelegate pd = enc.getPersistenceDelegate(c);
            pd.initialize(c, oldInstance, newInstance, enc);
        }
    }

    protected abstract Expression instantiate(Object var1, Encoder var2);

    protected boolean mutatesTo(Object o1, Object o2) {
        return null != o1 && null != o2 && o1.getClass() == o2.getClass();
    }

    public void writeObject(Object oldInstance, Encoder out) {
        Object newInstance = out.get(oldInstance);
        Class<?> clazz = oldInstance.getClass();
        if (this.mutatesTo(oldInstance, newInstance)) {
            this.initialize(clazz, oldInstance, newInstance, out);
        } else {
            out.remove(oldInstance);
            out.writeExpression(this.instantiate(oldInstance, out));
            newInstance = out.get(oldInstance);
            if (newInstance != null) {
                this.initialize(clazz, oldInstance, newInstance, out);
            }
        }
    }
}

