/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import org.apache.hc.core5.http.MessageConstraintException;
import org.apache.hc.core5.http.impl.BasicHttpTransportMetrics;
import org.apache.hc.core5.http.impl.io.SessionInputBufferImpl;
import org.apache.hc.core5.http.impl.io.SessionOutputBufferImpl;
import org.apache.hc.core5.http.io.HttpTransportMetrics;
import org.apache.hc.core5.http.io.SessionInputBuffer;
import org.apache.hc.core5.http.io.SessionOutputBuffer;
import org.apache.hc.core5.util.CharArrayBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class TestSessionInOutBuffers {
    static final int[] SWISS_GERMAN_HELLO = new int[]{71, 114, 252, 101, 122, 105, 95, 122, 228, 109, 228};
    static final int[] RUSSIAN_HELLO = new int[]{1042, 1089, 1077, 1084, 95, 1087, 1088, 1080, 1074, 1077, 1090};

    TestSessionInOutBuffers() {
    }

    @Test
    void testBasicBufferProperties() throws Exception {
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(new byte[]{1, 2, 3});
        Assertions.assertEquals((int)16, (int)inBuffer.capacity());
        Assertions.assertEquals((int)16, (int)inBuffer.available());
        Assertions.assertEquals((int)0, (int)inBuffer.length());
        inBuffer.read((InputStream)inputStream);
        Assertions.assertEquals((int)14, (int)inBuffer.available());
        Assertions.assertEquals((int)2, (int)inBuffer.length());
        SessionOutputBufferImpl outbuffer = new SessionOutputBufferImpl(16);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)16, (int)outbuffer.capacity());
        Assertions.assertEquals((int)16, (int)outbuffer.available());
        Assertions.assertEquals((int)0, (int)outbuffer.length());
        outbuffer.write(new byte[]{1, 2, 3}, (OutputStream)outputStream);
        Assertions.assertEquals((int)13, (int)outbuffer.available());
        Assertions.assertEquals((int)3, (int)outbuffer.length());
    }

    @Test
    void testBasicReadWriteLine() throws Exception {
        String[] teststrs = new String[5];
        teststrs[0] = "Hello";
        teststrs[1] = "This string should be much longer than the size of the output buffer which is only 16 bytes for this test";
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < 15; ++i) {
            buffer.append("123456789 ");
        }
        buffer.append("and stuff like that");
        teststrs[2] = buffer.toString();
        teststrs[3] = "";
        teststrs[4] = "And goodbye";
        CharArrayBuffer chbuffer = new CharArrayBuffer(16);
        SessionOutputBufferImpl outbuffer = new SessionOutputBufferImpl(16);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        for (String teststr : teststrs) {
            chbuffer.clear();
            chbuffer.append(teststr);
            outbuffer.writeLine(chbuffer, (OutputStream)outputStream);
        }
        outbuffer.writeLine(null, (OutputStream)outputStream);
        outbuffer.flush((OutputStream)outputStream);
        HttpTransportMetrics tmetrics = outbuffer.getMetrics();
        long bytesWritten = tmetrics.getBytesTransferred();
        long expected = 0L;
        for (String teststr : teststrs) {
            expected += (long)(teststr.length() + 2);
        }
        Assertions.assertEquals((long)expected, (long)bytesWritten);
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        for (String teststr : teststrs) {
            chbuffer.clear();
            inBuffer.readLine(chbuffer, (InputStream)inputStream);
            Assertions.assertEquals((Object)teststr, (Object)chbuffer.toString());
        }
        chbuffer.clear();
        Assertions.assertEquals((int)-1, (int)inBuffer.readLine(chbuffer, (InputStream)inputStream));
        chbuffer.clear();
        Assertions.assertEquals((int)-1, (int)inBuffer.readLine(chbuffer, (InputStream)inputStream));
        tmetrics = inBuffer.getMetrics();
        long bytesRead = tmetrics.getBytesTransferred();
        Assertions.assertEquals((long)expected, (long)bytesRead);
    }

    @Test
    void testComplexReadWriteLine() throws Exception {
        SessionOutputBufferImpl outbuffer = new SessionOutputBufferImpl(16);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        outbuffer.write(new byte[]{97, 10}, (OutputStream)outputStream);
        outbuffer.write(new byte[]{13, 10}, (OutputStream)outputStream);
        outbuffer.write(new byte[]{13, 13, 10}, (OutputStream)outputStream);
        outbuffer.write(new byte[]{10}, (OutputStream)outputStream);
        outbuffer.write(null, (OutputStream)outputStream);
        outbuffer.write(null, 0, 12, (OutputStream)outputStream);
        outbuffer.flush((OutputStream)outputStream);
        long bytesWritten = outbuffer.getMetrics().getBytesTransferred();
        Assertions.assertEquals((long)8L, (long)bytesWritten);
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < 14; ++i) {
            buffer.append("a");
        }
        String s1 = buffer.toString();
        buffer.append("\r\n");
        outbuffer.write(buffer.toString().getBytes(StandardCharsets.US_ASCII), (OutputStream)outputStream);
        outbuffer.flush((OutputStream)outputStream);
        bytesWritten = outbuffer.getMetrics().getBytesTransferred();
        Assertions.assertEquals((long)24L, (long)bytesWritten);
        buffer.setLength(0);
        for (int i = 0; i < 15; ++i) {
            buffer.append("a");
        }
        String s2 = buffer.toString();
        buffer.append("\r\n");
        outbuffer.write(buffer.toString().getBytes(StandardCharsets.US_ASCII), (OutputStream)outputStream);
        outbuffer.flush((OutputStream)outputStream);
        bytesWritten = outbuffer.getMetrics().getBytesTransferred();
        Assertions.assertEquals((long)41L, (long)bytesWritten);
        buffer.setLength(0);
        for (int i = 0; i < 16; ++i) {
            buffer.append("a");
        }
        String s3 = buffer.toString();
        buffer.append("\r\n");
        outbuffer.write(buffer.toString().getBytes(StandardCharsets.US_ASCII), (OutputStream)outputStream);
        outbuffer.flush((OutputStream)outputStream);
        bytesWritten = outbuffer.getMetrics().getBytesTransferred();
        Assertions.assertEquals((long)59L, (long)bytesWritten);
        outbuffer.write(new byte[]{97}, (OutputStream)outputStream);
        outbuffer.flush((OutputStream)outputStream);
        bytesWritten = outbuffer.getMetrics().getBytesTransferred();
        Assertions.assertEquals((long)60L, (long)bytesWritten);
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        CharArrayBuffer chbuffer = new CharArrayBuffer(16);
        chbuffer.clear();
        inBuffer.readLine(chbuffer, (InputStream)inputStream);
        Assertions.assertEquals((Object)"a", (Object)chbuffer.toString());
        chbuffer.clear();
        inBuffer.readLine(chbuffer, (InputStream)inputStream);
        Assertions.assertEquals((Object)"", (Object)chbuffer.toString());
        chbuffer.clear();
        inBuffer.readLine(chbuffer, (InputStream)inputStream);
        Assertions.assertEquals((Object)"\r", (Object)chbuffer.toString());
        chbuffer.clear();
        inBuffer.readLine(chbuffer, (InputStream)inputStream);
        Assertions.assertEquals((Object)"", (Object)chbuffer.toString());
        chbuffer.clear();
        inBuffer.readLine(chbuffer, (InputStream)inputStream);
        Assertions.assertEquals((Object)s1, (Object)chbuffer.toString());
        chbuffer.clear();
        inBuffer.readLine(chbuffer, (InputStream)inputStream);
        Assertions.assertEquals((Object)s2, (Object)chbuffer.toString());
        chbuffer.clear();
        inBuffer.readLine(chbuffer, (InputStream)inputStream);
        Assertions.assertEquals((Object)s3, (Object)chbuffer.toString());
        chbuffer.clear();
        inBuffer.readLine(chbuffer, (InputStream)inputStream);
        Assertions.assertEquals((Object)"a", (Object)chbuffer.toString());
        chbuffer.clear();
        inBuffer.readLine(chbuffer, (InputStream)inputStream);
        Assertions.assertEquals((int)-1, (int)inBuffer.readLine(chbuffer, (InputStream)inputStream));
        chbuffer.clear();
        inBuffer.readLine(chbuffer, (InputStream)inputStream);
        Assertions.assertEquals((int)-1, (int)inBuffer.readLine(chbuffer, (InputStream)inputStream));
        long bytesRead = inBuffer.getMetrics().getBytesTransferred();
        Assertions.assertEquals((long)bytesWritten, (long)bytesRead);
    }

    @Test
    void testBasicReadWriteLineLargeBuffer() throws Exception {
        String[] teststrs = new String[5];
        teststrs[0] = "Hello";
        teststrs[1] = "This string should be much longer than the size of the output buffer which is only 16 bytes for this test";
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < 15; ++i) {
            buffer.append("123456789 ");
        }
        buffer.append("and stuff like that");
        teststrs[2] = buffer.toString();
        teststrs[3] = "";
        teststrs[4] = "And goodbye";
        CharArrayBuffer chbuffer = new CharArrayBuffer(16);
        SessionOutputBufferImpl outbuffer = new SessionOutputBufferImpl(16);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        for (String teststr : teststrs) {
            chbuffer.clear();
            chbuffer.append(teststr);
            outbuffer.writeLine(chbuffer, (OutputStream)outputStream);
        }
        outbuffer.writeLine(null, (OutputStream)outputStream);
        outbuffer.flush((OutputStream)outputStream);
        long bytesWritten = outbuffer.getMetrics().getBytesTransferred();
        long expected = 0L;
        for (String teststr : teststrs) {
            expected += (long)(teststr.length() + 2);
        }
        Assertions.assertEquals((long)expected, (long)bytesWritten);
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(1024);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        for (String teststr : teststrs) {
            chbuffer.clear();
            inBuffer.readLine(chbuffer, (InputStream)inputStream);
            Assertions.assertEquals((Object)teststr, (Object)chbuffer.toString());
        }
        chbuffer.clear();
        Assertions.assertEquals((int)-1, (int)inBuffer.readLine(chbuffer, (InputStream)inputStream));
        chbuffer.clear();
        Assertions.assertEquals((int)-1, (int)inBuffer.readLine(chbuffer, (InputStream)inputStream));
        long bytesRead = inBuffer.getMetrics().getBytesTransferred();
        Assertions.assertEquals((long)expected, (long)bytesRead);
    }

    @Test
    void testReadWriteBytes() throws Exception {
        int readLen;
        int remaining;
        int chunk;
        byte[] out = new byte[40];
        for (int i = 0; i < out.length; ++i) {
            out[i] = (byte)(48 + i);
        }
        SessionOutputBufferImpl outbuffer = new SessionOutputBufferImpl(16);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        int off = 0;
        for (remaining = out.length; remaining > 0; remaining -= chunk) {
            chunk = 10;
            if (chunk > remaining) {
                chunk = remaining;
            }
            outbuffer.write(out, off, chunk, (OutputStream)outputStream);
            off += chunk;
        }
        outbuffer.flush((OutputStream)outputStream);
        long bytesWritten = outbuffer.getMetrics().getBytesTransferred();
        Assertions.assertEquals((long)out.length, (long)bytesWritten);
        byte[] tmp = outputStream.toByteArray();
        Assertions.assertEquals((int)out.length, (int)tmp.length);
        for (int i = 0; i < out.length; ++i) {
            Assertions.assertEquals((byte)out[i], (byte)tmp[i]);
        }
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(tmp);
        Assertions.assertEquals((int)0, (int)inBuffer.read(null, 0, 10, (InputStream)inputStream));
        Assertions.assertEquals((int)0, (int)inBuffer.read(null, (InputStream)inputStream));
        long bytesRead = inBuffer.getMetrics().getBytesTransferred();
        Assertions.assertEquals((long)0L, (long)bytesRead);
        byte[] in = new byte[40];
        off = 0;
        for (remaining = in.length; remaining > 0; remaining -= readLen) {
            int chunk2 = 10;
            if (chunk2 > remaining) {
                chunk2 = remaining;
            }
            if ((readLen = inBuffer.read(in, off, chunk2, (InputStream)inputStream)) == -1) break;
            off += readLen;
        }
        for (int i = 0; i < out.length; ++i) {
            Assertions.assertEquals((byte)out[i], (byte)in[i]);
        }
        Assertions.assertEquals((int)-1, (int)inBuffer.read(tmp, (InputStream)inputStream));
        Assertions.assertEquals((int)-1, (int)inBuffer.read(tmp, (InputStream)inputStream));
        bytesRead = inBuffer.getMetrics().getBytesTransferred();
        Assertions.assertEquals((long)out.length, (long)bytesRead);
    }

    @Test
    void testReadWriteByte() throws Exception {
        int i;
        byte[] out = new byte[40];
        for (int i2 = 0; i2 < out.length; ++i2) {
            out[i2] = (byte)(120 + i2);
        }
        SessionOutputBufferImpl outbuffer = new SessionOutputBufferImpl(16);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        for (byte element : out) {
            outbuffer.write((int)element, (OutputStream)outputStream);
        }
        outbuffer.flush((OutputStream)outputStream);
        long bytesWritten = outbuffer.getMetrics().getBytesTransferred();
        Assertions.assertEquals((long)out.length, (long)bytesWritten);
        byte[] tmp = outputStream.toByteArray();
        Assertions.assertEquals((int)out.length, (int)tmp.length);
        for (int i3 = 0; i3 < out.length; ++i3) {
            Assertions.assertEquals((byte)out[i3], (byte)tmp[i3]);
        }
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(tmp);
        byte[] in = new byte[40];
        for (i = 0; i < in.length; ++i) {
            in[i] = (byte)inBuffer.read((InputStream)inputStream);
        }
        for (i = 0; i < out.length; ++i) {
            Assertions.assertEquals((byte)out[i], (byte)in[i]);
        }
        Assertions.assertEquals((int)-1, (int)inBuffer.read((InputStream)inputStream));
        Assertions.assertEquals((int)-1, (int)inBuffer.read((InputStream)inputStream));
        long bytesRead = inBuffer.getMetrics().getBytesTransferred();
        Assertions.assertEquals((long)out.length, (long)bytesRead);
    }

    @Test
    void testWriteSmallFragmentBuffering() throws Exception {
        OutputStream outputStream = (OutputStream)Mockito.mock(OutputStream.class);
        SessionOutputBufferImpl outbuffer = new SessionOutputBufferImpl(new BasicHttpTransportMetrics(), 16, 16, null);
        outbuffer.write(1, outputStream);
        outbuffer.write(2, outputStream);
        outbuffer.write(new byte[]{1, 2}, outputStream);
        outbuffer.write(new byte[]{3, 4}, outputStream);
        outbuffer.flush(outputStream);
        ((OutputStream)Mockito.verify((Object)outputStream, (VerificationMode)Mockito.times((int)1))).write((byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        ((OutputStream)Mockito.verify((Object)outputStream, (VerificationMode)Mockito.never())).write(ArgumentMatchers.anyInt());
    }

    @Test
    void testWriteSmallFragmentNoBuffering() throws Exception {
        OutputStream outputStream = (OutputStream)Mockito.mock(OutputStream.class);
        SessionOutputBufferImpl outbuffer = new SessionOutputBufferImpl(new BasicHttpTransportMetrics(), 16, 0, null);
        outbuffer.write(1, outputStream);
        outbuffer.write(2, outputStream);
        outbuffer.write(new byte[]{1, 2}, outputStream);
        outbuffer.write(new byte[]{3, 4}, outputStream);
        ((OutputStream)Mockito.verify((Object)outputStream, (VerificationMode)Mockito.times((int)2))).write((byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        ((OutputStream)Mockito.verify((Object)outputStream, (VerificationMode)Mockito.times((int)2))).write(ArgumentMatchers.anyInt());
    }

    @Test
    void testLineLimit() throws Exception {
        String s = "a very looooooooooooooooooooooooooooooooooooooooooong line\r\n";
        byte[] tmp = "a very looooooooooooooooooooooooooooooooooooooooooong line\r\n".getBytes(StandardCharsets.US_ASCII);
        SessionInputBufferImpl inBuffer1 = new SessionInputBufferImpl(5);
        ByteArrayInputStream inputStream1 = new ByteArrayInputStream(tmp);
        CharArrayBuffer chbuffer = new CharArrayBuffer(16);
        inBuffer1.readLine(chbuffer, (InputStream)inputStream1);
        long bytesRead = inBuffer1.getMetrics().getBytesTransferred();
        Assertions.assertEquals((long)60L, (long)bytesRead);
        SessionInputBufferImpl inBuffer2 = new SessionInputBufferImpl(5, 15);
        ByteArrayInputStream inputStream2 = new ByteArrayInputStream(tmp);
        chbuffer.clear();
        Assertions.assertThrows(MessageConstraintException.class, () -> TestSessionInOutBuffers.lambda$testLineLimit$0((SessionInputBuffer)inBuffer2, chbuffer, inputStream2));
    }

    @Test
    void testLineLimit2() throws Exception {
        String s = "just a line\r\n";
        byte[] tmp = "just a line\r\n".getBytes(StandardCharsets.US_ASCII);
        SessionInputBufferImpl inBuffer1 = new SessionInputBufferImpl(25);
        ByteArrayInputStream inputStream1 = new ByteArrayInputStream(tmp);
        CharArrayBuffer chbuffer = new CharArrayBuffer(16);
        inBuffer1.readLine(chbuffer, (InputStream)inputStream1);
        long bytesRead = inBuffer1.getMetrics().getBytesTransferred();
        Assertions.assertEquals((long)13L, (long)bytesRead);
        SessionInputBufferImpl inBuffer2 = new SessionInputBufferImpl(25, 10);
        ByteArrayInputStream inputStream2 = new ByteArrayInputStream(tmp);
        chbuffer.clear();
        Assertions.assertThrows(MessageConstraintException.class, () -> TestSessionInOutBuffers.lambda$testLineLimit2$1((SessionInputBuffer)inBuffer2, chbuffer, inputStream2));
    }

    @Test
    void testLineLimit3() throws Exception {
        String s = "012345678\r\nblaaaaaaaaaaaaaaaaaah";
        byte[] tmp = "012345678\r\nblaaaaaaaaaaaaaaaaaah".getBytes(StandardCharsets.US_ASCII);
        SessionInputBufferImpl inBuffer1 = new SessionInputBufferImpl(128);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(tmp);
        CharArrayBuffer chbuffer = new CharArrayBuffer(16);
        inBuffer1.readLine(chbuffer, (InputStream)inputStream);
        Assertions.assertEquals((Object)"012345678", (Object)chbuffer.toString());
    }

    @Test
    void testReadLineFringeCase1() throws Exception {
        String s = "abc\r\n";
        byte[] tmp = "abc\r\n".getBytes(StandardCharsets.US_ASCII);
        SessionInputBufferImpl inBuffer1 = new SessionInputBufferImpl(128);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(tmp);
        Assertions.assertEquals((int)97, (int)inBuffer1.read((InputStream)inputStream));
        Assertions.assertEquals((int)98, (int)inBuffer1.read((InputStream)inputStream));
        Assertions.assertEquals((int)99, (int)inBuffer1.read((InputStream)inputStream));
        Assertions.assertEquals((int)13, (int)inBuffer1.read((InputStream)inputStream));
        CharArrayBuffer chbuffer = new CharArrayBuffer(16);
        Assertions.assertEquals((int)0, (int)inBuffer1.readLine(chbuffer, (InputStream)inputStream));
    }

    private static String constructString(int[] unicodeChars) {
        StringBuilder buffer = new StringBuilder();
        if (unicodeChars != null) {
            for (int unicodeChar : unicodeChars) {
                buffer.append((char)unicodeChar);
            }
        }
        return buffer.toString();
    }

    @Test
    void testMultibyteCodedReadWriteLine() throws Exception {
        String s1 = TestSessionInOutBuffers.constructString(SWISS_GERMAN_HELLO);
        String s2 = TestSessionInOutBuffers.constructString(RUSSIAN_HELLO);
        String s3 = "Like hello and stuff";
        SessionOutputBufferImpl outbuffer = new SessionOutputBufferImpl(16, StandardCharsets.UTF_8.newEncoder());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        CharArrayBuffer chbuffer = new CharArrayBuffer(16);
        for (int i = 0; i < 10; ++i) {
            chbuffer.clear();
            chbuffer.append(s1);
            outbuffer.writeLine(chbuffer, (OutputStream)outputStream);
            chbuffer.clear();
            chbuffer.append(s2);
            outbuffer.writeLine(chbuffer, (OutputStream)outputStream);
            chbuffer.clear();
            chbuffer.append("Like hello and stuff");
            outbuffer.writeLine(chbuffer, (OutputStream)outputStream);
        }
        outbuffer.flush((OutputStream)outputStream);
        long bytesWritten = outbuffer.getMetrics().getBytesTransferred();
        long expected = (s1.getBytes(StandardCharsets.UTF_8).length + 2 + (s2.getBytes(StandardCharsets.UTF_8).length + 2) + ("Like hello and stuff".getBytes(StandardCharsets.UTF_8).length + 2)) * 10;
        Assertions.assertEquals((long)expected, (long)bytesWritten);
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16, StandardCharsets.UTF_8.newDecoder());
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        for (int i = 0; i < 10; ++i) {
            chbuffer.clear();
            inBuffer.readLine(chbuffer, (InputStream)inputStream);
            Assertions.assertEquals((Object)s1, (Object)chbuffer.toString());
            chbuffer.clear();
            inBuffer.readLine(chbuffer, (InputStream)inputStream);
            Assertions.assertEquals((Object)s2, (Object)chbuffer.toString());
            chbuffer.clear();
            inBuffer.readLine(chbuffer, (InputStream)inputStream);
            Assertions.assertEquals((Object)"Like hello and stuff", (Object)chbuffer.toString());
        }
        chbuffer.clear();
        Assertions.assertEquals((int)-1, (int)inBuffer.readLine(chbuffer, (InputStream)inputStream));
        chbuffer.clear();
        Assertions.assertEquals((int)-1, (int)inBuffer.readLine(chbuffer, (InputStream)inputStream));
        long bytesRead = inBuffer.getMetrics().getBytesTransferred();
        Assertions.assertEquals((long)expected, (long)bytesRead);
    }

    @Test
    void testMultibyteCodedReadWriteLongLine() throws Exception {
        String s1 = TestSessionInOutBuffers.constructString(SWISS_GERMAN_HELLO);
        String s2 = TestSessionInOutBuffers.constructString(RUSSIAN_HELLO);
        String s3 = "Like hello and stuff";
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < 1024; ++i) {
            buf.append(s1).append(s2).append("Like hello and stuff");
        }
        String s = buf.toString();
        SessionOutputBufferImpl outbuffer = new SessionOutputBufferImpl(16, StandardCharsets.UTF_8.newEncoder());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        CharArrayBuffer chbuffer = new CharArrayBuffer(16);
        chbuffer.append(s);
        outbuffer.writeLine(chbuffer, (OutputStream)outputStream);
        outbuffer.flush((OutputStream)outputStream);
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16, StandardCharsets.UTF_8.newDecoder());
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        chbuffer.clear();
        inBuffer.readLine(chbuffer, (InputStream)inputStream);
        Assertions.assertEquals((Object)s, (Object)chbuffer.toString());
    }

    @Test
    void testNonAsciiReadWriteLine() throws Exception {
        String s1 = TestSessionInOutBuffers.constructString(SWISS_GERMAN_HELLO);
        SessionOutputBufferImpl outbuffer = new SessionOutputBufferImpl(16, StandardCharsets.UTF_8.newEncoder());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        CharArrayBuffer chbuffer = new CharArrayBuffer(16);
        for (int i = 0; i < 10; ++i) {
            chbuffer.clear();
            chbuffer.append(s1);
            outbuffer.writeLine(chbuffer, (OutputStream)outputStream);
        }
        chbuffer.clear();
        outbuffer.writeLine(chbuffer, (OutputStream)outputStream);
        outbuffer.flush((OutputStream)outputStream);
        long bytesWritten = outbuffer.getMetrics().getBytesTransferred();
        long expected = (s1.getBytes(StandardCharsets.UTF_8).length + 2) * 10 + 2;
        Assertions.assertEquals((long)expected, (long)bytesWritten);
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16, StandardCharsets.UTF_8.newDecoder());
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        for (int i = 0; i < 10; ++i) {
            chbuffer.clear();
            int len = inBuffer.readLine(chbuffer, (InputStream)inputStream);
            Assertions.assertEquals((int)len, (int)SWISS_GERMAN_HELLO.length);
            Assertions.assertEquals((Object)s1, (Object)chbuffer.toString());
        }
        chbuffer.clear();
        Assertions.assertEquals((int)0, (int)inBuffer.readLine(chbuffer, (InputStream)inputStream));
        chbuffer.clear();
        Assertions.assertEquals((int)-1, (int)inBuffer.readLine(chbuffer, (InputStream)inputStream));
        chbuffer.clear();
        Assertions.assertEquals((int)-1, (int)inBuffer.readLine(chbuffer, (InputStream)inputStream));
        long bytesRead = inBuffer.getMetrics().getBytesTransferred();
        Assertions.assertEquals((long)expected, (long)bytesRead);
    }

    @Test
    void testUnmappableInputActionReport() {
        String s = "This text contains a circumflex \u0302 !!!";
        CharsetEncoder encoder = StandardCharsets.ISO_8859_1.newEncoder();
        encoder.onMalformedInput(CodingErrorAction.IGNORE);
        encoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        SessionOutputBufferImpl outbuffer = new SessionOutputBufferImpl(16, encoder);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        CharArrayBuffer chbuffer = new CharArrayBuffer(32);
        chbuffer.append("This text contains a circumflex \u0302 !!!");
        Assertions.assertThrows(CharacterCodingException.class, () -> TestSessionInOutBuffers.lambda$testUnmappableInputActionReport$2((SessionOutputBuffer)outbuffer, chbuffer, outputStream));
    }

    @Test
    void testUnmappableInputActionReplace() throws Exception {
        String s = "This text contains a circumflex \u0302 !!!";
        CharsetEncoder encoder = StandardCharsets.ISO_8859_1.newEncoder();
        encoder.onMalformedInput(CodingErrorAction.IGNORE);
        encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        SessionOutputBufferImpl outbuffer = new SessionOutputBufferImpl(16, encoder);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        CharArrayBuffer chbuffer = new CharArrayBuffer(32);
        chbuffer.append("This text contains a circumflex \u0302 !!!");
        outbuffer.writeLine(chbuffer, (OutputStream)outputStream);
        outbuffer.flush((OutputStream)outputStream);
        String result = new String(outputStream.toByteArray(), StandardCharsets.ISO_8859_1);
        Assertions.assertEquals((Object)"This text contains a circumflex ? !!!\r\n", (Object)result);
    }

    @Test
    void testUnmappableInputActionIgnore() throws Exception {
        String s = "This text contains a circumflex \u0302 !!!";
        CharsetEncoder encoder = StandardCharsets.ISO_8859_1.newEncoder();
        encoder.onMalformedInput(CodingErrorAction.IGNORE);
        encoder.onUnmappableCharacter(CodingErrorAction.IGNORE);
        SessionOutputBufferImpl outbuffer = new SessionOutputBufferImpl(16, encoder);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        CharArrayBuffer chbuffer = new CharArrayBuffer(32);
        chbuffer.append("This text contains a circumflex \u0302 !!!");
        outbuffer.writeLine(chbuffer, (OutputStream)outputStream);
        outbuffer.flush((OutputStream)outputStream);
        String result = new String(outputStream.toByteArray(), StandardCharsets.ISO_8859_1);
        Assertions.assertEquals((Object)"This text contains a circumflex  !!!\r\n", (Object)result);
    }

    @Test
    void testMalformedInputActionReport() {
        byte[] tmp = TestSessionInOutBuffers.constructString(SWISS_GERMAN_HELLO).getBytes(StandardCharsets.ISO_8859_1);
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPORT);
        decoder.onUnmappableCharacter(CodingErrorAction.IGNORE);
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16, decoder);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(tmp);
        CharArrayBuffer chbuffer = new CharArrayBuffer(32);
        Assertions.assertThrows(CharacterCodingException.class, () -> TestSessionInOutBuffers.lambda$testMalformedInputActionReport$3((SessionInputBuffer)inBuffer, chbuffer, inputStream));
    }

    @Test
    void testMalformedInputActionReplace() throws Exception {
        byte[] tmp = TestSessionInOutBuffers.constructString(SWISS_GERMAN_HELLO).getBytes(StandardCharsets.ISO_8859_1);
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPLACE);
        decoder.onUnmappableCharacter(CodingErrorAction.IGNORE);
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16, decoder);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(tmp);
        CharArrayBuffer chbuffer = new CharArrayBuffer(32);
        inBuffer.readLine(chbuffer, (InputStream)inputStream);
        Assertions.assertEquals((Object)"Gr\ufffdezi_z\ufffdm\ufffd", (Object)chbuffer.toString());
    }

    @Test
    void testMalformedInputActionIgnore() throws Exception {
        byte[] tmp = TestSessionInOutBuffers.constructString(SWISS_GERMAN_HELLO).getBytes(StandardCharsets.ISO_8859_1);
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.IGNORE);
        decoder.onUnmappableCharacter(CodingErrorAction.IGNORE);
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16, decoder);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(tmp);
        CharArrayBuffer chbuffer = new CharArrayBuffer(32);
        inBuffer.readLine(chbuffer, (InputStream)inputStream);
        Assertions.assertEquals((Object)"Grezi_zm", (Object)chbuffer.toString());
    }

    private static /* synthetic */ void lambda$testMalformedInputActionReport$3(SessionInputBuffer inBuffer, CharArrayBuffer chbuffer, ByteArrayInputStream inputStream) throws Throwable {
        inBuffer.readLine(chbuffer, (InputStream)inputStream);
    }

    private static /* synthetic */ void lambda$testUnmappableInputActionReport$2(SessionOutputBuffer outbuffer, CharArrayBuffer chbuffer, ByteArrayOutputStream outputStream) throws Throwable {
        outbuffer.writeLine(chbuffer, (OutputStream)outputStream);
    }

    private static /* synthetic */ void lambda$testLineLimit2$1(SessionInputBuffer inBuffer2, CharArrayBuffer chbuffer, InputStream inputStream2) throws Throwable {
        inBuffer2.readLine(chbuffer, inputStream2);
    }

    private static /* synthetic */ void lambda$testLineLimit$0(SessionInputBuffer inBuffer2, CharArrayBuffer chbuffer, InputStream inputStream2) throws Throwable {
        inBuffer2.readLine(chbuffer, inputStream2);
    }
}

