/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.websession;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.websession.WebSessionEntity;
import org.apache.ignite.marshaller.Marshaller;
import org.jetbrains.annotations.Nullable;

class WebSessionV2
implements HttpSession {
    private static final HttpSessionContext EMPTY_SES_CTX = new HttpSessionContext(){

        @Nullable
        public HttpSession getSession(String id) {
            return null;
        }

        public Enumeration<String> getIds() {
            return Collections.enumeration(Collections.emptyList());
        }
    };
    private static final Object REMOVED_ATTR = new Object();
    @GridToStringExclude
    private final ServletContext ctx;
    private WebSessionEntity entity;
    protected Map<String, Object> attrs;
    private final long accessTime;
    private int maxInactiveInterval;
    private boolean maxInactiveIntervalChanged;
    private boolean isNew;
    private boolean invalidated;
    private final Marshaller marsh;
    private final HttpSession genuineSes;

    WebSessionV2(String id, @Nullable HttpSession ses, boolean isNew, ServletContext ctx, @Nullable WebSessionEntity entity, Marshaller marsh) {
        assert (id != null);
        assert (marsh != null);
        assert (ctx != null);
        assert (ses != null || entity != null);
        this.marsh = marsh;
        this.ctx = ctx;
        this.isNew = isNew;
        this.genuineSes = ses;
        this.accessTime = System.currentTimeMillis();
        if (entity == null) {
            entity = new WebSessionEntity(id, ses.getCreationTime(), this.accessTime, ses.getMaxInactiveInterval());
        }
        this.entity = entity;
        this.maxInactiveInterval = entity.maxInactiveInterval();
        if (ses != null) {
            Enumeration names = ses.getAttributeNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                this.attributes().put(name, ses.getAttribute(name));
            }
        }
    }

    public long getCreationTime() {
        this.assertValid();
        return this.entity.createTime();
    }

    public String getId() {
        return this.entity.id();
    }

    public String id() {
        return this.entity.id();
    }

    public long getLastAccessedTime() {
        this.assertValid();
        return this.accessTime;
    }

    public ServletContext getServletContext() {
        return this.ctx;
    }

    public void setMaxInactiveInterval(int interval) {
        this.maxInactiveInterval = interval;
        this.maxInactiveIntervalChanged = true;
    }

    public boolean isMaxInactiveIntervalChanged() {
        return this.maxInactiveIntervalChanged;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public HttpSessionContext getSessionContext() {
        return EMPTY_SES_CTX;
    }

    public Object getAttribute(String name) {
        byte[] bytes;
        this.assertValid();
        Object attr = this.attributes().get(name);
        if (attr == REMOVED_ATTR) {
            return null;
        }
        if (attr == null && (bytes = (byte[])this.entity.attributes().get(name)) != null) {
            try {
                attr = this.unmarshal(bytes);
            }
            catch (IOException e) {
                throw new IgniteException((Throwable)e);
            }
            this.attributes().put(name, attr);
        }
        return attr;
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public void setAttribute(String name, Object val) {
        this.assertValid();
        if (val == null) {
            this.removeAttribute(name);
        } else {
            this.attributes().put(name, val);
        }
    }

    public void putValue(String name, Object val) {
        this.setAttribute(name, val);
    }

    public Enumeration<String> getAttributeNames() {
        this.assertValid();
        return Collections.enumeration(this.attributeNames());
    }

    private Set<String> attributeNames() {
        if (!F.isEmpty(this.attrs)) {
            HashSet<String> names = new HashSet<String>(this.entity.attributes().size() + this.attrs.size());
            names.addAll(this.entity.attributes().keySet());
            for (Map.Entry<String, Object> entry : this.attrs.entrySet()) {
                if (entry == REMOVED_ATTR) continue;
                names.add(entry.getKey());
            }
            return names;
        }
        return this.entity.attributes().keySet();
    }

    public String[] getValueNames() {
        this.assertValid();
        Set<String> names = this.attributeNames();
        return names.toArray(new String[names.size()]);
    }

    public void removeAttribute(String name) {
        this.assertValid();
        this.attributes().put(name, REMOVED_ATTR);
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void invalidate() {
        this.assertValid();
        if (this.genuineSes != null) {
            try {
                this.genuineSes.invalidate();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.invalidated = true;
    }

    public boolean isNew() {
        this.assertValid();
        return this.isNew;
    }

    public Map<String, byte[]> binaryUpdatesMap() throws IOException {
        Map<String, Object> map = this.attributes();
        if (F.isEmpty(map)) {
            return Collections.emptyMap();
        }
        HashMap<String, byte[]> res = new HashMap<String, byte[]>(map.size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object val = entry.getValue() == REMOVED_ATTR ? null : entry.getValue();
            res.put(entry.getKey(), this.marshal(val));
        }
        return res;
    }

    @Nullable
    private <T> T unmarshal(byte[] bytes) throws IOException {
        if (this.marsh != null) {
            try {
                return (T)U.unmarshal((Marshaller)this.marsh, (byte[])bytes, (ClassLoader)this.getClass().getClassLoader());
            }
            catch (IgniteCheckedException e) {
                throw new IOException(e);
            }
        }
        return null;
    }

    @Nullable
    private byte[] marshal(Object obj) throws IOException {
        if (this.marsh != null) {
            try {
                return U.marshal((Marshaller)this.marsh, (Object)obj);
            }
            catch (IgniteCheckedException e) {
                throw new IOException(e);
            }
        }
        return null;
    }

    public WebSessionEntity marshalAttributes() throws IOException {
        WebSessionEntity marshaled = new WebSessionEntity(this.getId(), this.entity.createTime(), this.accessTime, this.maxInactiveInterval);
        for (Map.Entry<String, Object> entry : this.attributes().entrySet()) {
            marshaled.putAttribute(entry.getKey(), this.marshal(entry.getValue()));
        }
        return marshaled;
    }

    private Map<String, Object> attributes() {
        if (this.attrs == null) {
            this.attrs = new HashMap<String, Object>();
        }
        return this.attrs;
    }

    public boolean isValid() {
        return !this.invalidated;
    }

    private void assertValid() {
        if (this.invalidated) {
            throw new IllegalStateException("Session was invalidated.");
        }
    }
}

