/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.inline.types;

import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.NumericInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.keys.BooleanIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.NumericIndexKey;
import org.apache.ignite.internal.pagemem.PageUtils;

public class BooleanInlineIndexKeyType
extends NumericInlineIndexKeyType<BooleanIndexKey> {
    public BooleanInlineIndexKeyType() {
        super(IndexKeyType.BOOLEAN, (short)1);
    }

    @Override
    protected int put0(long pageAddr, int off, BooleanIndexKey key, int maxSize) {
        PageUtils.putByte(pageAddr, off, (byte)this.type().code());
        PageUtils.putByte(pageAddr, off + 1, (byte)((Boolean)key.key() != false ? 1 : 0));
        return this.keySize + 1;
    }

    @Override
    protected BooleanIndexKey get0(long pageAddr, int off) {
        boolean key = PageUtils.getByte(pageAddr, off + 1) != 0;
        return new BooleanIndexKey(key);
    }

    @Override
    public int compare0(long pageAddr, int off, IndexKey key) {
        boolean val = PageUtils.getByte(pageAddr, off + 1) != 0;
        return -Integer.signum(((NumericIndexKey)key).compareTo(val));
    }
}

