/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.schema.management;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.internal.processors.cache.GridCacheContextInfo;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.schema.management.IndexDescriptor;
import org.apache.ignite.internal.util.typedef.F;

public class TableDescriptor {
    private final GridCacheContextInfo<?, ?> cacheInfo;
    private final GridQueryTypeDescriptor typeDesc;
    private final boolean isSql;
    private final Map<String, IndexDescriptor> idxs = new ConcurrentHashMap<String, IndexDescriptor>();
    private final String affKey;
    private volatile boolean idxRebuildInProgress;

    public TableDescriptor(GridCacheContextInfo<?, ?> cacheInfo, GridQueryTypeDescriptor typeDesc, boolean isSql) {
        this.cacheInfo = cacheInfo;
        this.typeDesc = typeDesc;
        this.isSql = isSql;
        this.affKey = F.isEmpty(typeDesc.affinityKey()) || F.eq(typeDesc.affinityKey(), typeDesc.keyFieldName()) ? "_KEY" : (typeDesc.customAffinityKeyMapper() || !typeDesc.fields().containsKey(typeDesc.affinityKey()) ? null : typeDesc.affinityKey());
    }

    public GridCacheContextInfo<?, ?> cacheInfo() {
        return this.cacheInfo;
    }

    public GridQueryTypeDescriptor type() {
        return this.typeDesc;
    }

    public boolean isSql() {
        return this.isSql;
    }

    void addIndex(String idxName, IndexDescriptor idx) {
        this.idxs.put(idxName, idx);
    }

    IndexDescriptor dropIndex(String idxName) {
        return this.idxs.remove(idxName);
    }

    Map<String, IndexDescriptor> indexes() {
        return Collections.unmodifiableMap(this.idxs);
    }

    public String affinityKey() {
        return this.affKey;
    }

    public boolean isIndexRebuildInProgress() {
        return this.idxRebuildInProgress;
    }

    void markIndexRebuildInProgress(boolean idxRebuildInProgress) {
        this.idxRebuildInProgress = idxRebuildInProgress;
    }
}

